/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.text.translate;

import com.jn.langx.Transformer;
import com.jn.langx.codec.hex.Hex;
import com.jn.langx.text.translate.AggregateTranslator;
import com.jn.langx.util.Preconditions;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;

public abstract class CharSequenceTranslator
implements Transformer<CharSequence, String> {
    static final char[] HEX_DIGITS = Hex.DECIMAL_TO_DIGITS_UPPER;

    protected abstract int translate(CharSequence var1, int var2, Writer var3) throws IOException;

    @Override
    public final String transform(CharSequence input) {
        if (input == null) {
            return null;
        }
        try {
            StringWriter writer = new StringWriter(input.length() * 2);
            this.translate(input, writer);
            return writer.toString();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private void translate(CharSequence input, Writer out) throws IOException {
        Preconditions.checkTrue(out != null, "The Writer must not be null");
        if (input == null) {
            return;
        }
        int pos = 0;
        int len = input.length();
        while (pos < len) {
            int consumed = this.translate(input, pos, out);
            if (consumed == 0) {
                char c2;
                char c1 = input.charAt(pos);
                out.write(c1);
                if (!Character.isHighSurrogate(c1) || ++pos >= len || !Character.isLowSurrogate(c2 = input.charAt(pos))) continue;
                out.write(c2);
                ++pos;
                continue;
            }
            for (int pt = 0; pt < consumed; ++pt) {
                pos += Character.charCount(Character.codePointAt(input, pos));
            }
        }
    }

    public final CharSequenceTranslator with(CharSequenceTranslator ... translators) {
        CharSequenceTranslator[] newArray = new CharSequenceTranslator[translators.length + 1];
        newArray[0] = this;
        System.arraycopy(translators, 0, newArray, 1, translators.length);
        return new AggregateTranslator(newArray);
    }

    public static String hex(int codepoint) {
        return Integer.toHexString(codepoint).toUpperCase(Locale.ENGLISH);
    }
}

