/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.text.translate;

import com.jn.langx.text.translate.CodePointTranslator;
import com.jn.langx.util.ranges.IntRange;
import java.io.IOException;
import java.io.Writer;

class NumericEntityEscaper
extends CodePointTranslator {
    private final boolean between;
    private final IntRange range;

    private NumericEntityEscaper(int below, int above, boolean between) {
        this.range = new IntRange(below, above);
        this.between = between;
    }

    public NumericEntityEscaper() {
        this(0, Integer.MAX_VALUE, true);
    }

    public static NumericEntityEscaper below(int codepoint) {
        return NumericEntityEscaper.outsideOf(codepoint, Integer.MAX_VALUE);
    }

    public static NumericEntityEscaper above(int codepoint) {
        return NumericEntityEscaper.outsideOf(0, codepoint);
    }

    public static NumericEntityEscaper between(int codepointLow, int codepointHigh) {
        return new NumericEntityEscaper(codepointLow, codepointHigh, true);
    }

    public static NumericEntityEscaper outsideOf(int codepointLow, int codepointHigh) {
        return new NumericEntityEscaper(codepointLow, codepointHigh, false);
    }

    @Override
    protected boolean translate(int codepoint, Writer out) throws IOException {
        if (this.between != this.range.contains(codepoint)) {
            return false;
        }
        out.write("&#");
        out.write(Integer.toString(codepoint, 10));
        out.write(59);
        return true;
    }
}

