/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.text.xml;

import com.jn.langx.registry.GenericRegistry;
import com.jn.langx.security.prevention.injection.InjectionPreventionHandler;
import com.jn.langx.text.xml.XPathHandler;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.spi.CommonServiceProvider;
import java.util.Iterator;

public class XPathInjectionPreventionHandler
extends InjectionPreventionHandler {
    private static final GenericRegistry<XPathHandler> registry;
    private static final XPathInjectionPreventionHandler INSTANCE;

    public static XPathInjectionPreventionHandler getInstance() {
        return INSTANCE;
    }

    @Override
    public String apply(String xpathParameter) {
        XPathHandler OWASP_XPATH_ENCODER = (XPathHandler)registry.get("owasp-xpath-encoder");
        if (OWASP_XPATH_ENCODER != null) {
            return OWASP_XPATH_ENCODER.transform(xpathParameter);
        }
        return super.apply(xpathParameter);
    }

    static {
        final GenericRegistry _registry = new GenericRegistry();
        Iterator<XPathHandler> iterator = new CommonServiceProvider<XPathHandler>().get(XPathHandler.class);
        Pipeline.of(iterator).forEach(new Consumer<XPathHandler>(){

            @Override
            public void accept(XPathHandler xPathHandler) {
                _registry.register(xPathHandler);
            }
        });
        registry = _registry;
        INSTANCE = new XPathInjectionPreventionHandler();
    }
}

