/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.text.xml;

import com.jn.langx.text.xml.XPathInjectionPreventionHandler;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.function.Function;
import java.util.List;

public class XPaths {
    private XPaths() {
    }

    public static String notContainsAttr(String attrName) {
        XPathInjectionPreventionHandler handler = XPathInjectionPreventionHandler.getInstance();
        attrName = handler.apply(attrName);
        return "name(@" + attrName + ")=''";
    }

    public static String attrNotEquals(String attrName, String value) {
        XPathInjectionPreventionHandler handler = XPathInjectionPreventionHandler.getInstance();
        attrName = handler.apply(attrName);
        value = handler.apply(value);
        return "@" + attrName + "!=" + value;
    }

    public static String aorB_and_C(String expA, String expB, String expC) {
        XPathInjectionPreventionHandler handler = XPathInjectionPreventionHandler.getInstance();
        expA = handler.apply(expA);
        expB = handler.apply(expB);
        expC = handler.apply(expC);
        return "(" + expA + " or " + expB + ") and " + expC;
    }

    public static String a_or_BandC(String expA, String expB, String expC) {
        XPathInjectionPreventionHandler handler = XPathInjectionPreventionHandler.getInstance();
        expA = handler.apply(expA);
        expB = handler.apply(expB);
        expC = handler.apply(expC);
        return expA + " or (" + expB + " and " + expC + ")";
    }

    public static String wrapXpath(String xpath, boolean usingCustomNamespace, String namespacePrefix) {
        if (usingCustomNamespace && Emptys.isNotEmpty(xpath)) {
            return XPaths.wrapXpath(xpath, namespacePrefix);
        }
        return xpath;
    }

    public static String wrapXpath(String xpathExpr, String namespacePrefix) {
        boolean startWithSlash = Strings.startsWith(xpathExpr, "/");
        String[] segments = Strings.split(xpathExpr, "/");
        final String prefix = namespacePrefix + ":";
        List<String> prefixedSegments = Pipeline.of(segments).clearNulls().map(new Function<String, String>(){

            @Override
            public String apply(String segment) {
                return Strings.startsWith(segment, prefix) ? segment : prefix + segment;
            }
        }).asList();
        return (startWithSlash ? "/" : "") + Strings.join("/", prefixedSegments);
    }
}

