/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.text.xml;

import com.jn.langx.util.BasedStringAccessor;
import com.jn.langx.util.Throwables;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XmlNodeContentAccessor
extends BasedStringAccessor<XPathExpression, Document> {
    @Override
    public Object get(XPathExpression exp) {
        Node node = null;
        XPathExpressionException exception = null;
        try {
            node = (Node)exp.evaluate(this.getTarget(), XPathConstants.NODE);
        }
        catch (XPathExpressionException ex) {
            exception = ex;
        }
        if (node != null) {
            return node.getTextContent();
        }
        if (exception != null) {
            throw Throwables.wrapAsRuntimeException(exception);
        }
        return null;
    }

    @Override
    public boolean has(XPathExpression key) {
        return this.get(key) != null;
    }

    @Override
    public String getString(XPathExpression exp, String defaultValue) {
        Object content = this.get(exp);
        if (content == null) {
            return defaultValue;
        }
        return content.toString();
    }

    @Override
    public void set(XPathExpression exp, Object value) {
        String content = value == null ? "" : value.toString();
        Node node = null;
        XPathExpressionException exception = null;
        try {
            node = (Node)exp.evaluate(this.getTarget(), XPathConstants.NODE);
        }
        catch (XPathExpressionException ex) {
            exception = ex;
        }
        if (node != null) {
            node.setTextContent(content);
        }
        if (exception != null) {
            throw Throwables.wrapAsRuntimeException(exception);
        }
    }

    @Override
    public void remove(XPathExpression exp) {
        XPathExpressionException exception = null;
        try {
            Node node = (Node)exp.evaluate(this.getTarget(), XPathConstants.NODE);
            if (node != null && node.getParentNode() != null) {
                node.getParentNode().removeChild(node);
            }
        }
        catch (XPathExpressionException ex) {
            exception = ex;
        }
        if (exception != null) {
            throw Throwables.wrapAsRuntimeException(exception);
        }
    }
}

