/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.text.xml;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.navigation.Navigator;
import com.jn.langx.text.xml.NodeListIterator;
import com.jn.langx.text.xml.NodeNamespaceContext;
import com.jn.langx.text.xml.XPathInjectionPreventionHandler;
import com.jn.langx.util.collection.Lists;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.logging.Loggers;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XmlNodeNavigator
implements Navigator<Node> {
    private static final Logger logger = Loggers.getLogger(XmlNodeNavigator.class);
    @NonNull
    private XPathFactory xpathFactory;
    @Nullable
    private String namespacePrefix;

    public XmlNodeNavigator() {
        this(null, null);
    }

    public XmlNodeNavigator(@Nullable XPathFactory xpathFactory) {
        this(xpathFactory, null);
    }

    public XmlNodeNavigator(String namespacePrefix) {
        this(null, namespacePrefix);
    }

    public XmlNodeNavigator(@Nullable XPathFactory xpathFactory, @Nullable String namespacePrefix) {
        this.xpathFactory = xpathFactory == null ? XPathFactory.newInstance() : xpathFactory;
        this.namespacePrefix = namespacePrefix;
    }

    @Override
    public Node get(Node context, String pathExpression) {
        XPath xpath = this.xpathFactory.newXPath();
        xpath.setNamespaceContext(new NodeNamespaceContext(context, this.namespacePrefix));
        try {
            pathExpression = XPathInjectionPreventionHandler.getInstance().apply(pathExpression);
            XPathExpression exp = xpath.compile(pathExpression);
            Node node = (Node)exp.evaluate(context, XPathConstants.NODE);
            return node;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    @Override
    public List<Node> getList(Node context, String xpathExpression) {
        XPath xpath = this.xpathFactory.newXPath();
        xpath.setNamespaceContext(new NodeNamespaceContext(context, this.namespacePrefix));
        try {
            xpathExpression = XPathInjectionPreventionHandler.getInstance().apply(xpathExpression);
            XPathExpression exp = xpath.compile(xpathExpression);
            NodeList nodeList = (NodeList)exp.evaluate(context, XPathConstants.NODESET);
            return Pipeline.of(new NodeListIterator(nodeList)).asList();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return Lists.newArrayList();
        }
    }

    @Override
    public <T> void set(Node context, String xpath, T value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <E> Class<E> getType(Node context, String pathExpression) {
        Node node = this.get(context, pathExpression);
        if (node != null) {
            short nodeType = node.getNodeType();
            Class<Node> nodeClass = Node.class;
            switch (nodeType) {
                case 1: {
                    nodeClass = Element.class;
                    break;
                }
                case 2: {
                    nodeClass = Attr.class;
                    break;
                }
                case 3: {
                    nodeClass = Text.class;
                    break;
                }
                case 4: {
                    nodeClass = CDATASection.class;
                    break;
                }
                case 6: {
                    nodeClass = Entity.class;
                    break;
                }
                case 5: {
                    nodeClass = EntityReference.class;
                    break;
                }
                case 8: {
                    nodeClass = Comment.class;
                    break;
                }
                case 9: {
                    nodeClass = Document.class;
                }
            }
            return nodeClass;
        }
        return null;
    }

    @Override
    public String getParentPath(String pathExpression) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getLeaf(String pathExpression) {
        throw new UnsupportedOperationException();
    }
}

