/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.text.xml;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.text.xml.Namespaces;
import com.jn.langx.text.xml.XmlAccessor;
import com.jn.langx.text.xml.XmlDocumentHandler;
import com.jn.langx.text.xml.cutomizer.DocumentBuilderFactoryCustomizer;
import com.jn.langx.text.xml.cutomizer.TransformerFactoryCustomizer;
import com.jn.langx.text.xml.errorhandler.RaiseErrorHandler;
import com.jn.langx.text.xml.resolver.DTDEntityResolver;
import com.jn.langx.text.xml.resolver.NullEntityResolver;
import com.jn.langx.util.Throwables;
import com.jn.langx.util.io.Charsets;
import com.jn.langx.util.io.IOs;
import com.jn.langx.util.io.file.Files;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.SchemaFactory;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;

public class Xmls {
    public static final String NULL_XML_STR = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";

    private Xmls() {
    }

    public static Document getXmlDoc(InputStream xml) throws Exception {
        return Xmls.getXmlDoc(null, xml);
    }

    public static Document getXmlDoc(EntityResolver entityResolver, InputStream xml) throws Exception {
        return Xmls.getXmlDoc(entityResolver, null, xml);
    }

    public static Document getXmlDoc(EntityResolver entityResolver, ErrorHandler errorHandler, InputStream xml) throws Exception {
        return Xmls.getXmlDoc(entityResolver, errorHandler, xml, true);
    }

    public static Document getXmlDoc(EntityResolver entityResolver, ErrorHandler errorHandler, InputStream xml, boolean namespaceAware) throws Exception {
        return Xmls.getXmlDoc(entityResolver, errorHandler, xml, false, false, namespaceAware);
    }

    public static Document getXmlDoc(EntityResolver entityResolver, ErrorHandler errorHandler, InputStream xml, boolean ignoreComments, boolean ignoringElementContentWhitespace, boolean namespaceAware) throws Exception {
        return Xmls.getXmlDoc(entityResolver, errorHandler, xml, ignoreComments, ignoringElementContentWhitespace, namespaceAware, null);
    }

    public static Document getXmlDoc(EntityResolver entityResolver, ErrorHandler errorHandler, InputStream xml, boolean ignoreComments, boolean ignoringElementContentWhitespace, boolean namespaceAware, DocumentBuilderFactoryCustomizer customizer) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringComments(ignoreComments);
        factory.setIgnoringElementContentWhitespace(ignoringElementContentWhitespace);
        factory.setNamespaceAware(namespaceAware);
        boolean validation = entityResolver != null;
        factory.setValidating(validation);
        Xmls.securedDocumentBuilderFactory(factory, validation);
        if (customizer != null) {
            customizer.customize(factory);
        }
        DocumentBuilder builder = factory.newDocumentBuilder();
        entityResolver = entityResolver == null ? new NullEntityResolver() : entityResolver;
        builder.setEntityResolver(entityResolver);
        builder.setErrorHandler(errorHandler == null ? new RaiseErrorHandler() : errorHandler);
        return builder.parse(xml);
    }

    public static Document getXmlDoc(InputStream dtdInputStream, String src, boolean srcIsPath) throws Exception {
        if (srcIsPath) {
            return Xmls.getXmlDoc(dtdInputStream, src);
        }
        return Xmls.getXmlDoc(new DTDEntityResolver(dtdInputStream), new ByteArrayInputStream(src.getBytes(Charsets.UTF_8)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document getXmlDoc(InputStream dtdInputStream, String xmlfilepathOrURI) throws Exception {
        File file = new File(xmlfilepathOrURI);
        if (!file.exists()) {
            throw new FileNotFoundException(StringTemplates.formatWithPlaceholder("File '{}' does not exist .", xmlfilepathOrURI));
        }
        FileInputStream fis = null;
        try {
            fis = Files.openInputStream(file);
            Document document = Xmls.getXmlDoc(new DTDEntityResolver(dtdInputStream), fis);
            return document;
        }
        finally {
            IOs.close(fis);
        }
    }

    public static void writeDocToOutputStream(Document doc, OutputStream out) throws Exception {
        Transformer transformer = Xmls.newTransformer();
        transformer.transform(new DOMSource(doc), new StreamResult(out));
    }

    public static void writeDocToFile(Document doc, File file) throws TransformerFactoryConfigurationError, TransformerException {
        Transformer transformer = Xmls.newTransformer();
        transformer.transform(new DOMSource(doc), new StreamResult(file));
    }

    public static Transformer newTransformer(@NonNull TransformerFactoryCustomizer customizer) throws TransformerConfigurationException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Xmls.securedTransformerFactory(factory);
        if (customizer != null) {
            customizer.customize(factory);
        }
        return factory.newTransformer();
    }

    public static void securedDocumentBuilderFactory(DocumentBuilderFactory factory, boolean validation) {
        Xmls.setFeature(factory, "http://javax.xml.XMLConstants/feature/secure-processing", true);
        Xmls.setFeature(factory, "http://apache.org/xml/features/disallow-doctype-decl", true);
        Xmls.setFeature(factory, "http://xml.org/sax/features/external-general-entities", false);
        Xmls.setFeature(factory, "http://xml.org/sax/features/external-parameter-entities", false);
        Xmls.setFeature(factory, "http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        Xmls.setFeature(factory, "http://apache.org/xml/features/validation", validation);
        Xmls.setFeature(factory, "http://apache.org/xml/features/validation/schema", validation);
        Xmls.setFeature(factory, "http://javax.xml.XMLConstants/property/accessExternalDTD", false);
        Xmls.setFeature(factory, "http://javax.xml.XMLConstants/property/accessExternalSchema", false);
        factory.setXIncludeAware(false);
        factory.setExpandEntityReferences(false);
    }

    public static void securedTransformerFactory(TransformerFactory factory) {
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        factory.setAttribute("http://javax.xml.XMLConstants/feature/secure-processing", true);
    }

    public static void securedXmlInputFactory(XMLInputFactory factory) {
        factory.setProperty("javax.xml.stream.supportDTD", false);
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
    }

    public static void securedSchemaFactory(SchemaFactory factory) {
        Xmls.setFeature(factory, "http://apache.org/xml/features/disallow-doctype-decl", true);
        Xmls.setFeature(factory, "http://javax.xml.XMLConstants/property/accessExternalDTD", false);
        Xmls.setFeature(factory, "http://javax.xml.XMLConstants/property/accessExternalSchema", false);
    }

    public static void securedSAXParserFactory(SAXParserFactory factory) {
        Xmls.setFeature(factory, "http://apache.org/xml/features/disallow-doctype-decl", true);
        Xmls.setFeature(factory, "http://xml.org/sax/features/external-general-entities", false);
        Xmls.setFeature(factory, "http://xml.org/sax/features/external-parameter-entities", false);
        Xmls.setFeature(factory, "http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
    }

    public static Transformer newTransformer() throws TransformerConfigurationException {
        return Xmls.newTransformer(null);
    }

    public static <T> T handleXml(String xmlpath, XmlDocumentHandler<T> handler) {
        T t;
        FileInputStream input = null;
        try {
            File file = new File(xmlpath);
            if (!file.exists()) {
                throw new FileNotFoundException("File '" + xmlpath + "' does not exist .");
            }
            input = new FileInputStream(file);
            Document doc = Xmls.getXmlDoc(null, input);
            t = handler.handle(doc);
        }
        catch (Exception ex) {
            try {
                throw Throwables.wrapAsRuntimeException(ex);
            }
            catch (Throwable throwable) {
                IOs.close(input);
                throw throwable;
            }
        }
        IOs.close(input);
        return t;
    }

    public static NodeList findNodeList(Document doc, String xpath) throws XPathExpressionException {
        NodeList nodes = new XmlAccessor(Namespaces.hasCustomNamespace(doc) ? "x" : null).getNodeList(doc, XPathFactory.newInstance(), xpath);
        return nodes;
    }

    public static Element findElement(Document doc, String xpath) throws XPathExpressionException {
        Element element = new XmlAccessor(Namespaces.hasCustomNamespace(doc) ? "x" : null).getElement(doc, XPathFactory.newInstance(), xpath);
        return element;
    }

    public static void setFeature(DocumentBuilderFactory factory, String feature, boolean enabled) {
        try {
            factory.setFeature(feature, enabled);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
    }

    public static void setAttribute(DocumentBuilderFactory factory, String attribute, Object value) {
        try {
            factory.setAttribute(attribute, value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static void setFeature(SAXParserFactory factory, String feature, boolean enabled) {
        try {
            factory.setFeature(feature, enabled);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setProperty(XMLInputFactory factory, String feature, Object value) {
        try {
            factory.setProperty(feature, value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static void setAttribute(TransformerFactory factory, String feature, Object value) {
        try {
            factory.setAttribute(feature, value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static void setFeature(TransformerFactory factory, String feature, boolean enabled) {
        try {
            factory.setFeature(feature, enabled);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            // empty catch block
        }
    }

    public static void setProperty(SchemaFactory factory, String feature, Object value) {
        try {
            factory.setProperty(feature, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setFeature(SchemaFactory factory, String feature, boolean enabled) {
        try {
            factory.setFeature(feature, enabled);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setFeature(XPathFactory xpathFactory, String feature, boolean enabled) {
        try {
            xpathFactory.setFeature(feature, enabled);
        }
        catch (XPathFactoryConfigurationException xPathFactoryConfigurationException) {
            // empty catch block
        }
    }

    public static class SecuredPropertyNames {
        public static final String XML_PROPERTY_ACCESS_EXTERNAL_DTD = "http://javax.xml.XMLConstants/property/accessExternalDTD";
        public static final String XML_PROPERTY_ACCESS_EXTERNAL_SCHEMA = "http://javax.xml.XMLConstants/property/accessExternalSchema";
        public static final String XML_PROPERTY_ACCESS_EXTERNAL_STYLESHEET = "http://javax.xml.XMLConstants/property/accessExternalStylesheet";
        public static final String XML_FEATURE_SECURE_PROCESSING = "http://javax.xml.XMLConstants/feature/secure-processing";
        public static final String SAX_FEATURE_EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
        public static final String SAX_FEATURE_EXTERNAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
        public static final String APACHE_XML_FEATURE_NO_VALIDATING_LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
        public static final String APACHE_XML_FEATURE_DISALLOW_DOCTYPE_DECL = "http://apache.org/xml/features/disallow-doctype-decl";
        public static final String APACHE_XML_FEATURE_VALIDATION = "http://apache.org/xml/features/validation";
        public static final String APACHE_XML_FEATURE_VALIDATION_SCHEMA = "http://apache.org/xml/features/validation/schema";

        private SecuredPropertyNames() {
        }
    }
}

