/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.text.xml.resolver;

import com.jn.langx.util.io.Charsets;
import com.jn.langx.util.io.IOs;
import com.jn.langx.util.logging.Loggers;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import org.slf4j.Logger;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DTDEntityResolver
implements EntityResolver {
    private static final Logger logger = Loggers.getLogger(DTDEntityResolver.class);
    private StringReader dtdReader;

    public DTDEntityResolver(InputStream dtdInputStream) {
        this.setDtdInputStream(dtdInputStream);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputSource source = null;
        try {
            File file = null;
            if (systemId != null && !systemId.isEmpty()) {
                file = new File(systemId);
            } else if (publicId != null && !publicId.isEmpty()) {
                file = new File(publicId);
            }
            if (file != null && file.exists()) {
                FileInputStream fis = new FileInputStream(file);
                this.setDtdInputStream(fis);
            }
            if (this.dtdReader != null) {
                return new InputSource(this.dtdReader);
            }
            source = new InputSource(new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?>".getBytes(Charsets.UTF_8)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDtdInputStream(InputStream dtdInputStream) {
        try {
            StringReader reader;
            String content = IOs.readAsString(dtdInputStream);
            this.dtdReader = reader = new StringReader(content);
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
        finally {
            IOs.close(dtdInputStream);
        }
    }
}

