/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.datetime.DateField;
import java.util.Calendar;

public class Calendars {
    private static int[] arr = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    private Calendars() {
    }

    private static int getNumberOfFirstDayInMonth(int year, int month) {
        if (month < 3) {
            --year;
            month += 12;
        }
        int y = year % 100;
        int m = month;
        int result = (1 + 2 * m + 3 * (m + 1) / 5 + y + y / 4) % 7 + 1;
        return result;
    }

    private static boolean isLeapYear(int year) {
        return year % 400 != 0 && (year % 4 == 0 || year % 100 == 0);
    }

    public static int getMaxDay(int year, int month) {
        return month == 2 && Calendars.isLeapYear(year) ? 29 : arr[month - 1];
    }

    public static int getNumberInWeek(int year, int month, int day) {
        return (Calendars.getNumberOfFirstDayInMonth(year, month) + day - 1) % 7;
    }

    public static int getField(@NonNull Calendar calendar, @NonNull DateField field) {
        Preconditions.checkNotNull(calendar);
        Preconditions.checkNotNull(field);
        return Calendars.getField(calendar, field.getField());
    }

    public static int getField(@NonNull Calendar calendar, @NonNull int field) {
        return calendar.get(field);
    }

    public static int getYears(@NonNull Calendar calendar) {
        return Calendars.getField(calendar, DateField.YEAR);
    }

    public static int getMonths(@NonNull Calendar calendar) {
        return Calendars.getMonths(calendar, false);
    }

    public static int getMonths(@NonNull Calendar calendar, boolean actual) {
        int month = Calendars.getField(calendar, DateField.MONTH);
        return actual ? month + 1 : month;
    }

    public static int getDays(@NonNull Calendar calendar) {
        return Calendars.getField(calendar, DateField.DAY);
    }

    public static int getHours(@NonNull Calendar calendar) {
        return Calendars.getField(calendar, DateField.HOUR);
    }

    public static int getMinutes(@NonNull Calendar calendar) {
        return Calendars.getField(calendar, DateField.MINUTE);
    }

    public static int getSeconds(@NonNull Calendar calendar) {
        return Calendars.getField(calendar, DateField.SECOND);
    }

    public static int getMillis(@NonNull Calendar calendar) {
        return Calendars.getField(calendar, DateField.MILLIS);
    }

    public static void setField(@NonNull Calendar calendar, @NonNull DateField field, int value) {
        Preconditions.checkNotNull(calendar);
        Preconditions.checkNotNull(field);
        calendar.set(field.getField(), value);
        calendar.getTimeInMillis();
    }

    public static void setYears(@NonNull Calendar calendar, int year) {
        Preconditions.checkTrue(year >= 1970);
        Calendars.setField(calendar, DateField.YEAR, year);
    }

    public static void setMonths(@NonNull Calendar calendar, int month) {
        Calendars.setMonths(calendar, month, false);
    }

    public static void setMonths(@NonNull Calendar calendar, int month, boolean valueIsActual) {
        month = valueIsActual ? month - 1 : month;
        Calendars.setField(calendar, DateField.MONTH, month);
    }

    public static void setDays(@NonNull Calendar calendar, int year) {
        Calendars.setField(calendar, DateField.YEAR, year);
    }

    public static void setHours(@NonNull Calendar calendar, int year) {
        Calendars.setField(calendar, DateField.YEAR, year);
    }

    public static void setMinutes(@NonNull Calendar calendar, int year) {
        Calendars.setField(calendar, DateField.YEAR, year);
    }

    public static void setSeconds(@NonNull Calendar calendar, int year) {
        Calendars.setField(calendar, DateField.SECOND, year);
    }

    public static void setMillis(@NonNull Calendar calendar, int millis) {
        Calendars.setField(calendar, DateField.MILLIS, millis);
    }

    public static void addField(@NonNull Calendar calendar, @NonNull DateField field, int value) {
        Preconditions.checkNotNull(calendar);
        Preconditions.checkNotNull(field);
        calendar.add(field.getField(), value);
        calendar.getTimeInMillis();
    }

    public static void rollField(@NonNull Calendar calendar, @NonNull DateField field, int value) {
        Preconditions.checkNotNull(calendar);
        Preconditions.checkNotNull(field);
        calendar.roll(field.getField(), value);
        calendar.getTimeInMillis();
    }

    public static enum RecentIntervalType {
        NATURE_INTERVAL,
        TO_YESTERDAY,
        TO_NOW;

    }
}

