/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util;

import com.jn.langx.util.Preconditions;
import com.jn.langx.util.io.Charsets;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Arrays;

public class Chars {
    public static final char DOT = '.';
    public static final char SLASH = '/';
    public static final char BACKSLASH = '\\';
    public static final char DASHED = '-';
    public static final char UNDERLINE = '_';
    public static final char COMMA = ',';
    public static final char DELIM_START = '{';
    public static final char DELIM_END = '}';
    public static final char BRACKET_START = '[';
    public static final char BRACKET_END = ']';
    public static final char DOUBLE_QUOTES = '\"';
    public static final char SINGLE_QUOTE = '\'';
    public static final char AMP = '&';
    public static final char COLON = ':';
    public static final char AT = '@';
    public static final int CR = 13;
    public static final int LF = 10;
    public static final int SPACE = 32;
    public static final int TAB = 9;
    private static final char MAX_CHAR_VALUE = '\u00ff';

    private Chars() {
    }

    public static boolean isAlphabetic(int codePoint) {
        return (1086 >> Character.getType(codePoint) & 1) != 0 || Character.isValidCodePoint(codePoint) && Character.isLetter(codePoint);
    }

    public static boolean isAscii(char ch) {
        return ch < '\u0080';
    }

    public static boolean isAsciiPrintable(char ch) {
        return ch >= ' ' && ch < '\u007f';
    }

    public static boolean isNumber(char c) {
        return c >= '0' && c <= '9';
    }

    public static int toInt(char c) {
        Preconditions.checkTrue(Chars.isNumber(c));
        return c - 48;
    }

    public static char from(int i) {
        return (char)(i + 48);
    }

    public static char toLowerCase(char c) {
        return Chars.isUpperCase(c) ? (char)(c + 32) : c;
    }

    public static byte toLowerCase(byte c) {
        return Chars.isUpperCase(c) ? (byte)(c + 32) : c;
    }

    public static byte toUpperCase(byte b) {
        return Chars.isLowerCase(b) ? (byte)(b - 32) : b;
    }

    public static char toUpperCase(char b) {
        return Chars.isLowerCase(b) ? (char)(b - 32) : b;
    }

    public static boolean isLowerCase(byte value) {
        return value >= 97 && value <= 122;
    }

    public static boolean isLowerCase(char value) {
        return value >= 'a' && value <= 'z';
    }

    public static boolean isUpperCase(byte value) {
        return value >= 65 && value <= 90;
    }

    public static boolean isUpperCase(char value) {
        return value >= 'A' && value <= 'Z';
    }

    public static boolean isDigit(int ch) {
        return (ch - 48 | 57 - ch) >= 0;
    }

    public static boolean isLowOrUpperCase(char value) {
        return Chars.isUpperCase(value) || Chars.isLowerCase(value);
    }

    public static boolean isLowOrUpperCase(byte value) {
        return Chars.isUpperCase(value) || Chars.isLowerCase(value);
    }

    public static byte c2b(char c) {
        return (byte)(c > '\u00ff' ? 63 : (int)c);
    }

    public static char b2c(byte b) {
        return (char)(b & 0xFF);
    }

    public static int compare(char x, char y) {
        return x - y;
    }

    public static boolean isWhitespace(char ch) {
        return ch == ' ' || ch == '\t' || Chars.isCRorLF(ch);
    }

    public static boolean isCRorLF(char ch) {
        return ch == '\r' || ch == '\n';
    }

    public static boolean isNotCRAndLF(char ch) {
        return ch != '\r' && ch != '\n';
    }

    public static char[] utf8BytesToChars(byte[] utf8Bytes) {
        char[] chars;
        ByteBuffer byteBuffer = ByteBuffer.wrap(utf8Bytes);
        CharBuffer charBuffer = Charsets.UTF_8.decode(byteBuffer);
        if (charBuffer.hasArray()) {
            chars = Arrays.copyOfRange(charBuffer.array(), charBuffer.position(), charBuffer.limit());
            Arrays.fill(charBuffer.array(), '\u0000');
        } else {
            int length = charBuffer.limit() - charBuffer.position();
            chars = new char[length];
            charBuffer.get(chars);
            if (!charBuffer.isReadOnly()) {
                charBuffer.clear();
                for (int i = 0; i < charBuffer.limit(); ++i) {
                    charBuffer.put('\u0000');
                }
            }
        }
        return chars;
    }

    public static byte[] toUtf8Bytes(char[] chars) {
        byte[] bytes;
        CharBuffer charBuffer = CharBuffer.wrap(chars);
        ByteBuffer byteBuffer = Charsets.UTF_8.encode(charBuffer);
        if (byteBuffer.hasArray()) {
            bytes = Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
            Arrays.fill(byteBuffer.array(), (byte)0);
        } else {
            int length = byteBuffer.limit() - byteBuffer.position();
            bytes = new byte[length];
            byteBuffer.get(bytes);
            if (!byteBuffer.isReadOnly()) {
                byteBuffer.clear();
                for (int i = 0; i < byteBuffer.limit(); ++i) {
                    byteBuffer.put((byte)0);
                }
            }
        }
        return bytes;
    }

    public static boolean isBmpCodePoint(int codePoint) {
        return codePoint >>> 16 == 0;
    }
}

