/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util;

import com.jn.langx.annotation.Nullable;
import com.jn.langx.util.Objs;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.function.Function;
import com.jn.langx.util.function.Predicate;
import java.io.Serializable;
import java.util.Iterator;

public abstract class Equivalence<T> {
    protected Equivalence() {
    }

    public final boolean equivalent(@Nullable T a, @Nullable T b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return this.doEquivalent(a, b);
    }

    protected abstract boolean doEquivalent(T var1, T var2);

    public final int hash(@Nullable T t) {
        if (t == null) {
            return 0;
        }
        return this.doHash(t);
    }

    protected abstract int doHash(T var1);

    public final <F> Equivalence<F> onResultOf(Function<F, ? extends T> function) {
        return new FunctionalEquivalence<F, T>(function, this);
    }

    public final <S extends T> Wrapper<S> wrap(@Nullable S reference) {
        return new Wrapper(this, reference);
    }

    public final <S extends T> Equivalence<Iterable<S>> pairwise() {
        return new PairwiseEquivalence(this);
    }

    public final Predicate<T> equivalentTo(@Nullable T target) {
        return new EquivalentToPredicate<T>(this, target);
    }

    public static Equivalence<Object> equals() {
        return Equals.INSTANCE;
    }

    public static Equivalence<Object> identity() {
        return Identity.INSTANCE;
    }

    static final class PairwiseEquivalence<T>
    extends Equivalence<Iterable<T>>
    implements Serializable {
        final transient Equivalence<? super T> elementEquivalence;
        private static final long serialVersionUID = 1L;

        PairwiseEquivalence(Equivalence<? super T> elementEquivalence) {
            this.elementEquivalence = Preconditions.checkNotNull(elementEquivalence);
        }

        @Override
        protected boolean doEquivalent(Iterable<T> iterableA, Iterable<T> iterableB) {
            Iterator<T> iteratorA = iterableA.iterator();
            Iterator<T> iteratorB = iterableB.iterator();
            while (iteratorA.hasNext() && iteratorB.hasNext()) {
                if (this.elementEquivalence.equivalent(iteratorA.next(), iteratorB.next())) continue;
                return false;
            }
            return !iteratorA.hasNext() && !iteratorB.hasNext();
        }

        @Override
        protected int doHash(Iterable<T> iterable) {
            int hash = 78721;
            for (T element : iterable) {
                hash = hash * 24943 + this.elementEquivalence.hash(element);
            }
            return hash;
        }

        public boolean equals(@Nullable Object object) {
            if (object instanceof PairwiseEquivalence) {
                PairwiseEquivalence that = (PairwiseEquivalence)object;
                return this.elementEquivalence.equals(that.elementEquivalence);
            }
            return false;
        }

        public int hashCode() {
            return this.elementEquivalence.hashCode() ^ 0x46A3EB07;
        }

        public String toString() {
            return this.elementEquivalence + ".pairwise()";
        }
    }

    static final class FunctionalEquivalence<F, T>
    extends Equivalence<F>
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final transient Function<F, ? extends T> function;
        private final transient Equivalence<T> resultEquivalence;

        FunctionalEquivalence(Function<F, ? extends T> function, Equivalence<T> resultEquivalence) {
            this.function = Preconditions.checkNotNull(function);
            this.resultEquivalence = Preconditions.checkNotNull(resultEquivalence);
        }

        @Override
        protected boolean doEquivalent(F a, F b) {
            return this.resultEquivalence.equivalent(this.function.apply(a), this.function.apply(b));
        }

        @Override
        protected int doHash(F a) {
            return this.resultEquivalence.hash(this.function.apply(a));
        }

        public boolean equals(@Nullable Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof FunctionalEquivalence) {
                FunctionalEquivalence that = (FunctionalEquivalence)obj;
                return this.function.equals(that.function) && this.resultEquivalence.equals(that.resultEquivalence);
            }
            return false;
        }

        public int hashCode() {
            return Objs.hash(this.function, this.resultEquivalence);
        }

        public String toString() {
            return this.resultEquivalence + ".onResultOf(" + this.function + ")";
        }
    }

    static final class Identity
    extends Equivalence<Object>
    implements Serializable {
        static final Identity INSTANCE = new Identity();
        private static final long serialVersionUID = 1L;

        Identity() {
        }

        @Override
        protected boolean doEquivalent(Object a, Object b) {
            return false;
        }

        @Override
        protected int doHash(Object o) {
            return Objs.id(o);
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    static final class Equals
    extends Equivalence<Object>
    implements Serializable {
        static final Equals INSTANCE = new Equals();
        private static final long serialVersionUID = 1L;

        Equals() {
        }

        @Override
        protected boolean doEquivalent(Object a, Object b) {
            return a.equals(b);
        }

        @Override
        protected int doHash(Object o) {
            return o.hashCode();
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    private static final class EquivalentToPredicate<T>
    implements Predicate<T>,
    Serializable {
        private final transient Equivalence<T> equivalence;
        @Nullable
        private final transient T target;
        private static final long serialVersionUID = 0L;

        EquivalentToPredicate(Equivalence<T> equivalence, @Nullable T target) {
            this.equivalence = Preconditions.checkNotNull(equivalence);
            this.target = target;
        }

        @Override
        public boolean test(@Nullable T input) {
            return this.equivalence.equivalent(input, this.target);
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof EquivalentToPredicate) {
                EquivalentToPredicate that = (EquivalentToPredicate)obj;
                return this.equivalence.equals(that.equivalence) && Objs.equals(this.target, that.target);
            }
            return false;
        }

        public int hashCode() {
            return Objs.hash(this.equivalence, this.target);
        }

        public String toString() {
            return this.equivalence + ".equivalentTo(" + this.target + ")";
        }
    }

    public static final class Wrapper<T>
    implements Serializable {
        private final transient Equivalence<? super T> equivalence;
        @Nullable
        private final transient T reference;
        private static final long serialVersionUID = 0L;

        private Wrapper(Equivalence<? super T> equivalence, @Nullable T reference) {
            this.equivalence = Preconditions.checkNotNull(equivalence);
            this.reference = reference;
        }

        @Nullable
        public T get() {
            return this.reference;
        }

        public boolean equals(@Nullable Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Wrapper) {
                Wrapper that = (Wrapper)obj;
                if (this.equivalence.equals(that.equivalence)) {
                    Equivalence<T> equivalence = this.equivalence;
                    return equivalence.equivalent(this.reference, that.reference);
                }
            }
            return false;
        }

        public int hashCode() {
            return this.equivalence.hash(this.reference);
        }

        public String toString() {
            return this.equivalence + ".wrap(" + this.reference + ")";
        }
    }
}

