/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util;

import com.jn.langx.util.Emptys;
import com.jn.langx.util.Numbers;
import com.jn.langx.util.Strings;
import com.jn.langx.util.regexp.Regexp;
import com.jn.langx.util.regexp.Regexps;
import java.math.BigInteger;

public class Radixs {
    private static Regexp OCTAL_STRING_PATTERN = Regexps.createRegexp("^[0-7]+$");

    private Radixs() {
    }

    public static String toRadix(int b, int radix) {
        if (radix <= 0) {
            radix = 10;
        }
        return Integer.toString(b, radix);
    }

    public static String toBinary(byte b) {
        return Integer.toString(b, 2);
    }

    public static String toBinary(char b) {
        return Radixs.toRadix(b, 2);
    }

    public static String toBinary(short b) {
        return Radixs.toRadix(b, 2);
    }

    public static String toBinary(int b) {
        return Radixs.toRadix(b, 2);
    }

    public static String toBinary(long b) {
        return Radixs.toRadix(Numbers.toInt(b), 2);
    }

    public static boolean isOctal(int b) {
        return b >= 0 && b <= 7;
    }

    public static boolean isOctal(String str) {
        if (Emptys.isEmpty(str)) {
            return false;
        }
        return OCTAL_STRING_PATTERN.matcher(str).matches();
    }

    public static String toOtc(byte b) {
        return Integer.toString(b, 8);
    }

    public static String toOtc(char b) {
        return Radixs.toRadix(b, 8);
    }

    public static String toOtc(short b) {
        return Radixs.toRadix(b, 8);
    }

    public static String toOtc(int b) {
        return Radixs.toRadix(b, 8);
    }

    public static String toOtc(long b) {
        return Radixs.toRadix(Numbers.toInt(b), 8);
    }

    public static String toDecimal(byte b) {
        return Integer.toString(b, 10);
    }

    public static String toDecimal(char b) {
        return Radixs.toRadix(b, 10);
    }

    public static String toDecimal(short b) {
        return Radixs.toRadix(b, 10);
    }

    public static String toDecimal(int b) {
        return Radixs.toRadix(b, 10);
    }

    public static String toDecimal(long b) {
        return Radixs.toRadix(Numbers.toInt(b), 10);
    }

    public static String toHex2(byte[] bytes) {
        return Radixs.toHex(bytes, true);
    }

    public static String toHex(byte[] bytes) {
        return Radixs.toHex(bytes, false);
    }

    private static String toHex(byte[] bytes, boolean twoLength) {
        StringBuilder str = new StringBuilder();
        for (byte b : bytes) {
            str.append(twoLength ? Radixs.toHex2(b) : Radixs.toHex(b));
        }
        return str.toString();
    }

    public static String toHex(byte b) {
        return Radixs.toRadix(b, 16);
    }

    public static String toHex2(byte b) {
        return Strings.completingLength(Radixs.toRadix(b, 16), 2, '0', true);
    }

    public static String toHex(char b) {
        return Radixs.toRadix(b, 16);
    }

    public static String toHex2(char b) {
        return Strings.completingLength(Radixs.toRadix(b, 16), 2, '0', true);
    }

    public static String toHex(short b) {
        return Radixs.toRadix(b, 16);
    }

    public static String toHex2(short b) {
        return Strings.completingLength(Radixs.toRadix(b, 16), 2, '0', true);
    }

    public static String toHex(int b) {
        return Radixs.toRadix(b, 16);
    }

    public static String toHex2(int b) {
        return Strings.completingLength(Radixs.toRadix(b, 16), 2, '0', true);
    }

    public static String toHex(long b) {
        return Radixs.toRadix(Numbers.toInt(b), 16);
    }

    public static String toHex2(long b) {
        return Strings.completingLength(Radixs.toRadix(Numbers.toInt(b), 16), 2, '0', true);
    }

    public static int binaryToDecimal(String binary) {
        return Radixs.binaryToDecimal2(binary).intValue();
    }

    public static String binaryToOctal(String binary) {
        return Radixs.toOtc(Radixs.binaryToDecimal(binary));
    }

    public static BigInteger binaryToDecimal2(String binary) {
        return new BigInteger(binary, 2);
    }
}

