/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util;

import com.jn.langx.Transformer;
import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.exception.IllegalParameterException;
import com.jn.langx.io.stream.UnicodeInputStream;
import com.jn.langx.text.StrTokenizer;
import com.jn.langx.text.StringJoiner;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.text.placeholder.PlaceholderParser;
import com.jn.langx.util.BooleanEvaluator;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Maths;
import com.jn.langx.util.Numbers;
import com.jn.langx.util.Objs;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.SystemPropertys;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Lists;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.collection.PrimitiveArrays;
import com.jn.langx.util.enums.Enums;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.function.Consumer2;
import com.jn.langx.util.function.Function;
import com.jn.langx.util.function.Functions;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.function.Predicate2;
import com.jn.langx.util.io.Charsets;
import com.jn.langx.util.io.IOs;
import com.jn.langx.util.io.unicode.BOM;
import com.jn.langx.util.reflect.Reflects;
import com.jn.langx.util.reflect.type.Primitives;
import com.jn.langx.util.regexp.Regexp;
import com.jn.langx.util.regexp.Regexps;
import com.jn.langx.util.struct.Entry;
import com.jn.langx.util.struct.Holder;
import com.jn.langx.util.struct.Pair;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class Strings {
    public static final int INDEX_NOT_FOUND = -1;
    private static final int PAD_LIMIT = 8192;
    public static final char SP = ' ';
    public static final String SPACE = " ";
    public static final String EMPTY = "";
    public static final String SINGLE_QUOTE = "'";
    public static final char DOUBLE_QUOTE_CHAR = '\"';
    public static final String DOUBLE_QUOTE = "\"";
    public static final char SLASH_CHAR = '/';
    public static final char BACKSLASH_CHAR = '\\';
    public static final char BACKSLASH = '\\';
    public static final char BACKSPACE = '\b';
    public static final char COMMA = ',';
    public static final char LF = '\n';
    public static final char CR = '\r';
    public static final char FF = '\f';
    public static final String CRLF = "\r\n";
    public static final char TAB = '\t';
    public static final char PIPE = '|';
    public static final String CR_STRING = Strings.charToString('\r');
    public static final String LF_STRING = Strings.charToString('\n');
    public static final List<String> WHITESPACE_CHAR = Collects.immutableArrayList(" ", Strings.charToString('\n'), Strings.charToString('\t'), Strings.charToString('\r'), Strings.charToString('\f'));
    public static final String WHITESPACE = Strings.join("", WHITESPACE_CHAR);
    static final List<String> vowelLetters = Collects.asList("a", "e", "i", "o", "u");
    private static final int NOT_FOUND = -1;

    private Strings() {
    }

    public static final boolean isTextLineBreak(char c) {
        return c == '\n' || c == '\r';
    }

    public static final String charToString(char c) {
        return Character.toString(c);
    }

    public static final boolean isWhitespace(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (WHITESPACE.contains(EMPTY + c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return !Strings.isEmpty(str);
    }

    public static boolean isBlank(String str) {
        return str == null || str.trim().isEmpty();
    }

    public static boolean isNotBlank(String str) {
        return !Strings.isBlank(str);
    }

    public static boolean isBlank(CharSequence str) {
        return str == null || str.toString().trim().isEmpty();
    }

    public static boolean isNotBlank(CharSequence str) {
        return !Strings.isBlank(str);
    }

    public static String useValueIfNull(String str, String defaultValue) {
        return str == null ? defaultValue : str;
    }

    public static String useValueIfBlank(String str, String defaultValue) {
        return Strings.isBlank(str) ? defaultValue : str;
    }

    public static String useValueIfEmpty(String str, String defaultValue) {
        return Strings.isEmpty(str) ? defaultValue : str;
    }

    public static String getEmptyIfNull(String str) {
        return Strings.useValueIfNull(str, EMPTY);
    }

    public static String getEmptyIfBlank(String str) {
        return Strings.useValueIfBlank(str, EMPTY);
    }

    public static String getNullIfEmpty(String str) {
        return Strings.useValueIfEmpty(str, null);
    }

    public static String getNullIfBlank(String str) {
        return Strings.useValueIfBlank(str, null);
    }

    public static String trimOrEmpty(String str) {
        return Strings.getEmptyIfNull(str).trim();
    }

    public static String trimOrNull(String str) {
        if (Strings.isBlank(str)) {
            return null;
        }
        return str.trim();
    }

    public static String join(@NonNull String separator, @Nullable Iterator objects) {
        return Strings.join(separator, null, null, false, objects);
    }

    public static String join(@NonNull String separator, @Nullable String prefix, @Nullable String suffix, boolean filterNull, @Nullable Iterator objects) {
        return Strings.join(separator, prefix, suffix, objects, null, filterNull ? Functions.nonNullPredicate2() : Functions.truePredicate2());
    }

    public static String join(@NonNull String separator, @Nullable String prefix, @Nullable String suffix, @Nullable Iterator objects, Function<Object, String> mapper, Predicate2<Integer, String> predicate) {
        if (Emptys.isNull(objects)) {
            return EMPTY;
        }
        mapper = mapper == null ? Functions.toStringFunction() : mapper;
        List<String> strings = Pipeline.of(objects).map(mapper).asList();
        StringJoiner joiner = new StringJoiner(separator, Strings.useValueIfNull(prefix, EMPTY), Strings.useValueIfNull(suffix, EMPTY)).append(strings, predicate);
        return joiner.toString();
    }

    public static String join(@NonNull String separator, @Nullable Iterable objects) {
        return Strings.join(separator, objects == null ? null : objects.iterator());
    }

    public static String join(@NonNull String separator, @Nullable Integer[] objects) {
        return Strings.join(separator, Collects.asIterable(objects));
    }

    public static String join(@NonNull String separator, @Nullable Long[] objects) {
        return Strings.join(separator, Collects.asIterable(objects));
    }

    public static String join(@NonNull String separator, @Nullable Float[] objects) {
        return Strings.join(separator, Collects.asIterable(objects));
    }

    public static String join(@NonNull String separator, @Nullable Double[] objects) {
        return Strings.join(separator, Collects.asIterable(objects));
    }

    public static String join(@NonNull String separator, @Nullable Short[] objects) {
        return Strings.join(separator, Collects.asIterable(objects));
    }

    public static String join(@NonNull String separator, @Nullable Byte[] objects) {
        return Strings.join(separator, Collects.asIterable(objects));
    }

    public static String join(@NonNull String separator, @Nullable Character[] objects) {
        return Strings.join(separator, Collects.asIterable(objects));
    }

    public static String join(@NonNull String separator, @Nullable String[] objects) {
        return Strings.join(separator, Collects.asIterable(objects));
    }

    public static <E> String join(@NonNull String separator, @Nullable E[] objects, int startIndex) {
        return Strings.join(separator, objects, startIndex, objects.length - startIndex);
    }

    public static <E> String join(@NonNull String separator, @Nullable E[] objects, int startIndex, int length) {
        return Strings.join(separator, Collects.limit(Collects.skip(objects, startIndex), length));
    }

    public static String join(@NonNull String separator, @Nullable Object[] objects) {
        if (Emptys.isEmpty(objects)) {
            return EMPTY;
        }
        return Strings.join(separator, Collects.asIterable(objects));
    }

    public static String join(@NonNull String separator, int[] array) {
        return Strings.join(separator, (Integer[])PrimitiveArrays.wrap(array));
    }

    public static String join(@NonNull String separator, float[] array) {
        return Strings.join(separator, (Float[])PrimitiveArrays.wrap(array));
    }

    public static String join(@NonNull String separator, double[] array) {
        return Strings.join(separator, (Double[])PrimitiveArrays.wrap(array));
    }

    public static String join(@NonNull String separator, char[] array) {
        return Strings.join(separator, (Character[])PrimitiveArrays.wrap(array));
    }

    public static String join(@NonNull String separator, boolean[] array) {
        return Strings.join(separator, PrimitiveArrays.wrap(array));
    }

    public static String join(@NonNull String separator, long[] array) {
        return Strings.join(separator, (Long[])PrimitiveArrays.wrap(array));
    }

    public static <E> String iterateJoin(@NonNull String separator, String itemPrefix, String itemSuffix, E ... objs) {
        return Strings.iterateJoin(separator, itemPrefix, itemSuffix, Collects.asList(objs));
    }

    public static <E> String iterateJoin(@NonNull String separator, final String itemPrefix, final String itemSuffix, List<E> objs) {
        List strings = Pipeline.of(objs).clearNulls().map(new Function<E, String>(){

            @Override
            public String apply(E input) {
                return Strings.useValueIfNull(itemPrefix, Strings.EMPTY) + input.toString() + Strings.useValueIfNull(itemSuffix, Strings.EMPTY);
            }
        }).asList();
        return Strings.join(separator, strings);
    }

    public static String join(@NonNull String separator, Object obj) {
        if (obj == null) {
            return EMPTY;
        }
        return Strings.join(separator, Collects.asIterable(obj));
    }

    public static String insert(final @NonNull String string, @Nullable List<Integer> slotIndexes, @NonNull String insertment) {
        Preconditions.checkNotNull(string);
        if (Emptys.isEmpty(slotIndexes)) {
            return string;
        }
        final TreeSet sortedSlotIndexes = Collects.emptyTreeSet();
        final Holder<Boolean> insertFirst = new Holder<Boolean>(false);
        final Holder<Boolean> insertLast = new Holder<Boolean>(false);
        Collects.forEach(slotIndexes, new Consumer<Integer>(){

            @Override
            public void accept(Integer slotIndex) {
                if (slotIndex <= 0) {
                    insertFirst.set(true);
                } else if (slotIndex >= string.length()) {
                    insertLast.set(true);
                } else {
                    sortedSlotIndexes.add(slotIndex);
                }
            }
        });
        final List sortedSlotIndexList = Pipeline.of(sortedSlotIndexes).asList();
        final LinkedList<Entry<Integer, Integer>> segmentOffsetPairs = new LinkedList<Entry<Integer, Integer>>();
        Collects.forEach(sortedSlotIndexList, new Consumer2<Integer, Integer>(){

            @Override
            public void accept(Integer index, Integer slotIndex) {
                if (index == 0) {
                    segmentOffsetPairs.add(new Entry<Integer, Integer>(0, slotIndex));
                } else {
                    segmentOffsetPairs.add(new Entry(sortedSlotIndexList.get(index - 1), slotIndex));
                }
            }
        });
        if (Emptys.isEmpty(sortedSlotIndexList)) {
            segmentOffsetPairs.add(new Entry<Integer, Integer>(0, string.length()));
        } else {
            int stringLength;
            int lastSlotIndex = (Integer)sortedSlotIndexList.get(sortedSlotIndexList.size() - 1);
            if (lastSlotIndex < (stringLength = string.length())) {
                segmentOffsetPairs.add(new Entry<Integer, Integer>(lastSlotIndex, stringLength));
            }
        }
        Collection<String> segments = Collects.map(segmentOffsetPairs, new Function<Pair<Integer, Integer>, String>(){

            @Override
            public String apply(Pair<Integer, Integer> pair) {
                return string.substring(pair.getKey(), pair.getValue());
            }
        });
        StringBuilder newString = new StringBuilder(string.length() + 20);
        if (insertFirst.get().booleanValue()) {
            newString.append(insertment);
        }
        Iterator<String> segmentIter = segments.iterator();
        while (segmentIter.hasNext()) {
            String segment = segmentIter.next();
            newString.append(segment);
            if (!segmentIter.hasNext()) continue;
            newString.append(insertment);
        }
        if (insertLast.get().booleanValue()) {
            newString.append(insertment);
        }
        return newString.toString();
    }

    public static String[] split(@Nullable String string, @Nullable String separator) {
        return Strings.split(string, separator, true);
    }

    public static String[] split(@Nullable String string, @Nullable String separator, boolean doTrim) {
        return Strings.split(string, separator, doTrim, true);
    }

    public static String[] split(@Nullable String string, @Nullable String separator, boolean doTrim, boolean ignoreEmptyTokens) {
        return Strings.split(string, false, separator, doTrim, ignoreEmptyTokens);
    }

    public static String[] splitRegexp(@Nullable String string, @Nullable String separator) {
        return Strings.splitRegexp(string, separator, true);
    }

    public static String[] splitRegexp(@Nullable String string, @Nullable String separator, boolean doTrim) {
        return Strings.splitRegexp(string, separator, doTrim, true);
    }

    public static String[] splitRegexp(@Nullable String string, @Nullable String separator, boolean doTrim, boolean ignoreEmptyTokens) {
        return Strings.split(string, true, separator, doTrim, ignoreEmptyTokens);
    }

    public static String[] split(@Nullable String string, boolean separatorIsRegexp, @Nullable String separator, final boolean doTrim, final boolean ignoreEmptyTokens) {
        if (Emptys.isEmpty(string)) {
            return new String[0];
        }
        Pipeline<String> pipeline = null;
        if (separatorIsRegexp) {
            pipeline = Pipeline.of(string.split(separator));
        } else {
            StrTokenizer tokenizer = new StrTokenizer(string, separator);
            List list = tokenizer.tokenize();
            pipeline = Pipeline.of(list);
        }
        return pipeline.map(new Function<String, String>(){

            @Override
            public String apply(String input) {
                if (doTrim) {
                    return Strings.trim(input);
                }
                return input;
            }
        }).filter(new Predicate<String>(){

            @Override
            public boolean test(String value) {
                if (ignoreEmptyTokens) {
                    return Strings.isNotBlank(value);
                }
                return true;
            }
        }).toArray(String[].class);
    }

    public static String[] slice(String str, int substringLength) {
        if (Strings.isEmpty(str)) {
            return Emptys.EMPTY_STRINGS;
        }
        if (str.length() <= substringLength) {
            return new String[]{str};
        }
        ArrayList<String> substrings = Lists.newArrayList();
        int startOffset = 0;
        while (startOffset < str.length()) {
            int endOffsetExclude = Maths.min(startOffset + substringLength, str.length());
            if (endOffsetExclude > startOffset) {
                substrings.add(str.substring(startOffset, endOffsetExclude));
            }
            startOffset = endOffsetExclude;
        }
        return (String[])Collects.toArray(substrings, String[].class);
    }

    public static int decodeHexNibble(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 55;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 87;
        }
        return -1;
    }

    public static boolean substringMatch(CharSequence str, int index, CharSequence substring) {
        if (index >= str.length()) {
            return false;
        }
        String sub0 = str.subSequence(index, str.length()).toString();
        return Strings.equals(sub0, substring);
    }

    public static byte[] getBytesUtf8(String string) {
        return Strings.getBytes(string, Charsets.UTF_8);
    }

    private static byte[] getBytes(String string, Charset charset) {
        if (string == null) {
            return null;
        }
        return string.getBytes(charset);
    }

    public static String newStringUtf8(byte[] bytes) {
        return Strings.newString(bytes, Charsets.UTF_8);
    }

    public static String newString(byte[] bytes, Charset charset) {
        return bytes == null ? null : new String(bytes, Objs.useValueIfEmpty(charset, Charsets.UTF_8));
    }

    public static String newStringUsAscii(byte[] bytes) {
        return Strings.newString(bytes, Charsets.US_ASCII);
    }

    public static String deleteWhitespace(String str) {
        if (Strings.isEmpty(str)) {
            return str;
        }
        List tokens = new StrTokenizer(str).tokenize();
        return Strings.join(EMPTY, tokens);
    }

    public static String removeDuplicateWhitespace(String s) {
        StringBuilder result = new StringBuilder();
        int length = s.length();
        boolean isPreviousWhiteSpace = false;
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            boolean thisCharWhiteSpace = Character.isWhitespace(c);
            if (!isPreviousWhiteSpace || !thisCharWhiteSpace) {
                result.append(c);
            }
            isPreviousWhiteSpace = thisCharWhiteSpace;
        }
        return result.toString();
    }

    public static String unifyLineSeparators(String s) {
        return Strings.unifyLineSeparators(s, SystemPropertys.getLineSeparator());
    }

    public static String unifyLineSeparators(String s, String lineSeparator) {
        if (s == null) {
            return null;
        }
        if (lineSeparator == null) {
            lineSeparator = SystemPropertys.getLineSeparator();
        }
        if (!(lineSeparator.equals("\n") || lineSeparator.equals("\r") || lineSeparator.equals(CRLF))) {
            throw new IllegalArgumentException("Requested line separator is invalid.");
        }
        int length = s.length();
        StringBuilder buffer = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            if (s.charAt(i) == '\r') {
                if (i + 1 < length && s.charAt(i + 1) == '\n') {
                    ++i;
                }
                buffer.append(lineSeparator);
                continue;
            }
            if (s.charAt(i) == '\n') {
                buffer.append(lineSeparator);
                continue;
            }
            buffer.append(s.charAt(i));
        }
        return buffer.toString();
    }

    public static boolean isNumeric(CharSequence cs) {
        if (Emptys.isEmpty(cs)) {
            return false;
        }
        return Numbers.isNumber(cs.toString().trim());
    }

    public static boolean startsWithIgnoreCase(CharSequence str, CharSequence prefix) {
        return Strings.startsWith(str, prefix, true);
    }

    public static boolean startsWith(CharSequence str, CharSequence prefix) {
        return Strings.startsWith(str, prefix, false);
    }

    public static boolean startsWith(CharSequence str, CharSequence prefix, boolean ignoreCase) {
        if (str == null || prefix == null) {
            return str == null && prefix == null;
        }
        if (prefix.length() > str.length()) {
            return false;
        }
        return Strings.regionMatches(str, ignoreCase, 0, prefix, 0, prefix.length());
    }

    public static boolean endsWith(CharSequence str, CharSequence suffix) {
        return Strings.endsWith(str, suffix, false);
    }

    public static boolean endsWithIgnoreCase(CharSequence str, CharSequence suffix) {
        return Strings.endsWith(str, suffix, true);
    }

    public static boolean endsWith(CharSequence str, CharSequence suffix, boolean ignoreCase) {
        if (str == null || suffix == null) {
            return str == null && suffix == null;
        }
        if (suffix.length() > str.length()) {
            return false;
        }
        int strOffset = str.length() - suffix.length();
        return Strings.regionMatches(str, ignoreCase, strOffset, suffix, 0, suffix.length());
    }

    public static boolean containsAny(CharSequence cs, char ... searchChars) {
        if (Emptys.isEmpty(cs) || Emptys.isEmpty(searchChars)) {
            return false;
        }
        int csLength = cs.length();
        int searchLength = searchChars.length;
        int csLast = csLength - 1;
        int searchLast = searchLength - 1;
        for (int i = 0; i < csLength; ++i) {
            char ch = cs.charAt(i);
            for (int j = 0; j < searchLength; ++j) {
                if (searchChars[j] != ch) continue;
                if (Character.isHighSurrogate(ch)) {
                    if (j == searchLast) {
                        return true;
                    }
                    if (i >= csLast || searchChars[j + 1] != cs.charAt(i + 1)) continue;
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    public static boolean containsAny(CharSequence cs, CharSequence searchChars) {
        if (searchChars == null) {
            return false;
        }
        return Strings.containsAny(cs, Strings.toCharArray(searchChars));
    }

    public static boolean containsNone(CharSequence cs, String invalidChars) {
        if (cs == null || invalidChars == null) {
            return true;
        }
        return Strings.containsNone(cs, invalidChars.toCharArray());
    }

    public static boolean containsNone(CharSequence cs, char ... searchChars) {
        if (cs == null || searchChars == null) {
            return true;
        }
        int csLen = cs.length();
        int csLast = csLen - 1;
        int searchLen = searchChars.length;
        int searchLast = searchLen - 1;
        for (int i = 0; i < csLen; ++i) {
            char ch = cs.charAt(i);
            for (int j = 0; j < searchLen; ++j) {
                if (searchChars[j] != ch) continue;
                if (Character.isHighSurrogate(ch)) {
                    if (j == searchLast) {
                        return false;
                    }
                    if (i >= csLast || searchChars[j + 1] != cs.charAt(i + 1)) continue;
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    public static boolean containsOnly(CharSequence cs, char ... valid) {
        if (valid == null || cs == null) {
            return false;
        }
        if (cs.length() == 0) {
            return true;
        }
        if (valid.length == 0) {
            return false;
        }
        return Strings.indexOfAnyBut(cs, valid) == -1;
    }

    public static boolean containsOnly(CharSequence cs, String validChars) {
        if (cs == null || validChars == null) {
            return false;
        }
        return Strings.containsOnly(cs, validChars.toCharArray());
    }

    public static boolean contains(CharSequence cs, CharSequence searchChars) {
        return Strings.contains(cs, searchChars, false);
    }

    public static boolean contains(CharSequence cs, CharSequence searchChars, boolean ignoreCase) {
        return Strings.indexOf(cs, searchChars, ignoreCase) != -1;
    }

    public static boolean containsRegexp(String text, String regexp) {
        return Regexps.contains(text, Regexps.createRegexp(regexp));
    }

    public static int countOccurrencesOf(String str, String token) {
        int idx;
        if (str == null || token == null || str.length() == 0 || token.length() == 0) {
            return 0;
        }
        int count = 0;
        int pos = 0;
        while ((idx = str.indexOf(token, pos)) != -1) {
            ++count;
            pos = idx + token.length();
        }
        return count;
    }

    public static int countMatches(CharSequence str, CharSequence sub) {
        if (!Strings.isEmpty(str) && !Strings.isEmpty(sub)) {
            int count = 0;
            int idx = 0;
            while ((idx = Strings.indexOf(str, sub, idx)) != -1) {
                ++count;
                idx += sub.length();
            }
            return count;
        }
        return 0;
    }

    public static int countMatches(CharSequence str, char ch) {
        if (Strings.isEmpty(str)) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (ch != str.charAt(i)) continue;
            ++count;
        }
        return count;
    }

    public static String repeat(String str, int repeat) {
        if (str == null) {
            return null;
        }
        if (repeat <= 0) {
            return EMPTY;
        }
        int inputLength = str.length();
        if (repeat == 1 || inputLength == 0) {
            return str;
        }
        if (inputLength == 1 && repeat <= 8192) {
            return Strings.repeat(str.charAt(0), repeat);
        }
        int outputLength = inputLength * repeat;
        switch (inputLength) {
            case 1: {
                return Strings.repeat(str.charAt(0), repeat);
            }
            case 2: {
                char ch0 = str.charAt(0);
                char ch1 = str.charAt(1);
                char[] output2 = new char[outputLength];
                for (int i = repeat * 2 - 2; i >= 0; --i) {
                    output2[i] = ch0;
                    output2[i + 1] = ch1;
                    --i;
                }
                return new String(output2);
            }
        }
        StringBuilder buf = new StringBuilder(outputLength);
        for (int i = 0; i < repeat; ++i) {
            buf.append(str);
        }
        return buf.toString();
    }

    public static String repeat(String str, String separator, int repeat) {
        if (str == null || separator == null) {
            return Strings.repeat(str, repeat);
        }
        String result = Strings.repeat(str + separator, repeat);
        return Strings.removeEnd(result, separator);
    }

    public static String repeat(char ch, int repeat) {
        char[] buf = new char[repeat];
        for (int i = repeat - 1; i >= 0; --i) {
            buf[i] = ch;
        }
        return new String(buf);
    }

    public static String rightPad(String str, int size) {
        return Strings.rightPad(str, size, ' ');
    }

    public static String rightPad(String str, int size, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str;
        }
        if (pads > 8192) {
            return Strings.rightPad(str, size, String.valueOf(padChar));
        }
        return str.concat(Strings.repeat(padChar, pads));
    }

    public static String rightPad(String str, int size, String padStr) {
        if (str == null) {
            return null;
        }
        if (Strings.isEmpty(padStr)) {
            padStr = SPACE;
        }
        int padLen = padStr.length();
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str;
        }
        if (padLen == 1 && pads <= 8192) {
            return Strings.rightPad(str, size, padStr.charAt(0));
        }
        if (pads == padLen) {
            return str.concat(padStr);
        }
        if (pads < padLen) {
            return str.concat(padStr.substring(0, pads));
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        for (int i = 0; i < pads; ++i) {
            padding[i] = padChars[i % padLen];
        }
        return str.concat(new String(padding));
    }

    public static String leftPad(String str, int size) {
        return Strings.leftPad(str, size, ' ');
    }

    public static String leftPad(String str, int size, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str;
        }
        if (pads > 8192) {
            return Strings.leftPad(str, size, String.valueOf(padChar));
        }
        return Strings.repeat(padChar, pads).concat(str);
    }

    public static String leftPad(String str, int size, String padStr) {
        if (str == null) {
            return null;
        }
        if (Strings.isEmpty(padStr)) {
            padStr = SPACE;
        }
        int padLen = padStr.length();
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str;
        }
        if (padLen == 1 && pads <= 8192) {
            return Strings.leftPad(str, size, padStr.charAt(0));
        }
        if (pads == padLen) {
            return padStr.concat(str);
        }
        if (pads < padLen) {
            return padStr.substring(0, pads).concat(str);
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        for (int i = 0; i < pads; ++i) {
            padding[i] = padChars[i % padLen];
        }
        return new String(padding).concat(str);
    }

    public static String removeStart(String str, String remove) {
        if (Strings.isEmpty(str) || Strings.isEmpty(remove)) {
            return str;
        }
        if (str.startsWith(remove)) {
            return str.substring(remove.length());
        }
        return str;
    }

    public static String removeStartIgnoreCase(String str, String remove) {
        if (Strings.isEmpty(str) || Strings.isEmpty(remove)) {
            return str;
        }
        if (Strings.startsWithIgnoreCase(str, remove)) {
            return str.substring(remove.length());
        }
        return str;
    }

    public static String removeEnd(String str, String remove) {
        if (Strings.isEmpty(str) || Strings.isEmpty(remove)) {
            return str;
        }
        if (str.endsWith(remove)) {
            return str.substring(0, str.length() - remove.length());
        }
        return str;
    }

    public static String removeEndIgnoreCase(String str, String remove) {
        if (Strings.isEmpty(str) || Strings.isEmpty(remove)) {
            return str;
        }
        if (Strings.endsWithIgnoreCase(str, remove)) {
            return str.substring(0, str.length() - remove.length());
        }
        return str;
    }

    public static String remove(String str, String remove) {
        if (Strings.isEmpty(str) || Strings.isEmpty(remove)) {
            return str;
        }
        return Strings.replace(str, remove, EMPTY, -1);
    }

    public static String remove(String str, char remove) {
        if (Strings.isEmpty(str) || str.indexOf(remove) == -1) {
            return str;
        }
        char[] chars = str.toCharArray();
        int pos = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == remove) continue;
            chars[pos++] = chars[i];
        }
        return new String(chars, 0, pos);
    }

    public static String replaceOnce(String text, String searchString, String replacement) {
        return Strings.replace(text, searchString, replacement, 1);
    }

    public static String replacePattern(String source, String regex, String replacement) {
        return Pattern.compile(regex, 32).matcher(source).replaceAll(replacement);
    }

    public static String replace(String text, Regexp regexp, final Transformer<String, String> transformer) {
        return StringTemplates.format(text, regexp, new PlaceholderParser(){

            @Override
            public String parse(String searched) {
                return (String)transformer.transform(searched);
            }
        });
    }

    public static String removePattern(String source, String regex) {
        return Strings.replacePattern(source, regex, EMPTY);
    }

    public static String replace(String text, String searchString, String replacement) {
        return Strings.replace(text, searchString, replacement, -1);
    }

    public static String replace(String text, int start, int end, String replacement) {
        Preconditions.checkIndex(start, text.length());
        if (end < start || end > text.length()) {
            throw new IllegalParameterException("end offset is invalid");
        }
        StringBuilder builder = new StringBuilder();
        builder.append(text.substring(0, start));
        builder.append(replacement);
        builder.append(text.substring(end));
        return builder.toString();
    }

    public static String replace(String text, String searchString, String replacement, int max) {
        if (Strings.isEmpty(text) || Strings.isEmpty(searchString) || replacement == null || max == 0) {
            return text;
        }
        StrTokenizer tokenizer = new StrTokenizer(text, true, max, searchString);
        List tokens = tokenizer.tokenize();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < tokens.size(); ++i) {
            String token = (String)tokens.get(i);
            if (Objs.equals(searchString, token)) {
                builder.append(replacement);
                continue;
            }
            builder.append(token);
        }
        return builder.toString();
    }

    public static String replaceEach(String text, String[] searchList, String[] replacementList) {
        final HashMap<String, String> searchAndReplacement = Collects.emptyHashMap(true);
        for (int i = 0; i < searchList.length; ++i) {
            String key = searchList[i];
            String value = i >= replacementList.length ? EMPTY : replacementList[i];
            searchAndReplacement.put(key, value);
        }
        StrTokenizer strTokenizr = new StrTokenizer(text, true, searchList);
        List<Object> tokens = strTokenizr.tokenize();
        tokens = Pipeline.of(tokens).map(new Function<String, String>(){

            @Override
            public String apply(String token) {
                String replacement = (String)searchAndReplacement.get(token);
                if (replacement != null) {
                    return replacement;
                }
                return token;
            }
        }).asList();
        return Strings.join(EMPTY, tokens);
    }

    public static String replaceChars(String str, char searchChar, char replaceChar) {
        if (str == null) {
            return null;
        }
        return str.replace(searchChar, replaceChar);
    }

    public static String replaceChars(String str, String searchChars, String replaceChars) {
        if (Strings.isEmpty(str) || Strings.isEmpty(searchChars)) {
            return str;
        }
        if (replaceChars == null) {
            replaceChars = EMPTY;
        }
        String[] searchmentList = new StrTokenizer(searchChars, EMPTY).tokenize().toArray(new String[searchChars.length()]);
        String[] replacementList = new StrTokenizer(replaceChars, EMPTY).tokenize().toArray(new String[replaceChars.length()]);
        return Strings.replaceEach(str, searchmentList, replacementList);
    }

    public static String upperCase(String str) {
        if (str == null) {
            return null;
        }
        return str.toUpperCase();
    }

    public static String upperCase(String str, Locale locale) {
        if (str == null) {
            return null;
        }
        return str.toUpperCase(locale);
    }

    public static String upperCase(String str, int offset, int limit) {
        Pipeline<String> pipeline = Pipeline.of(Strings.split(str, null));
        final StringBuilder builder = new StringBuilder();
        Consumer<String> appendConsumer = new Consumer<String>(){

            @Override
            public void accept(String str) {
                builder.append(str);
            }
        };
        pipeline.skip(0).limit(offset).forEach(appendConsumer);
        pipeline.skip(offset).limit(limit).map(new Function<String, String>(){

            @Override
            public String apply(String input) {
                return input.toUpperCase();
            }
        }).forEach(appendConsumer);
        pipeline.skip(limit).forEach(appendConsumer);
        return builder.toString();
    }

    public static String upperCaseFirstLetter(String name) {
        int firstLetterIndex;
        int limit = name.length() - 1;
        for (firstLetterIndex = 0; !Character.isLetter(name.charAt(firstLetterIndex)) && firstLetterIndex < limit; ++firstLetterIndex) {
        }
        char firstLetter = name.charAt(firstLetterIndex);
        if (Character.isUpperCase(firstLetter)) {
            return name;
        }
        char uppercased = Character.toUpperCase(firstLetter);
        if (firstLetterIndex == 0) {
            return uppercased + name.substring(1);
        }
        return name.substring(0, firstLetterIndex) + uppercased + name.substring(firstLetterIndex + 1);
    }

    public static String transformFirstChar(String str, Transformer<String, String> transformer) {
        Preconditions.checkNotNull(str, "null");
        char firstChar = str.charAt(0);
        String replacement = transformer.transform(firstChar + EMPTY);
        return replacement + (str.length() > 1 ? Strings.substring(str, 1) : EMPTY);
    }

    public static String lowerCaseFirstChar(String str) {
        return Strings.transformFirstChar(str, new Transformer<String, String>(){

            @Override
            public String transform(String input) {
                return Strings.lowerCase(input);
            }
        });
    }

    public static String upperCaseFirstChar(String str) {
        return Strings.transformFirstChar(str, new Transformer<String, String>(){

            @Override
            public String transform(String input) {
                return Strings.upperCase(input);
            }
        });
    }

    public static String removeFirstChar(String str) {
        return Strings.transformFirstChar(str, new Transformer<String, String>(){

            @Override
            public String transform(String input) {
                return Strings.EMPTY;
            }
        });
    }

    public static String replaceFirstChar(String str, final String replacement) {
        return Strings.transformFirstChar(str, new Transformer<String, String>(){

            @Override
            public String transform(String input) {
                return replacement;
            }
        });
    }

    public static String lowerCase(String str) {
        return Strings.lowerCase(str, Locale.getDefault());
    }

    public static String lowerCase(String str, Locale locale) {
        if (str == null) {
            return null;
        }
        return str.toLowerCase(locale);
    }

    public static String lowerCase(String str, int offset, int limit) {
        Pipeline<String> pipeline = Pipeline.of(Strings.split(str, null));
        final StringBuilder builder = new StringBuilder();
        Consumer<String> appendConsumer = new Consumer<String>(){

            @Override
            public void accept(String str) {
                builder.append(str);
            }
        };
        pipeline.skip(0).limit(offset).forEach(appendConsumer);
        pipeline.skip(offset).limit(limit).map(new Function<String, String>(){

            @Override
            public String apply(String input) {
                return input.toLowerCase();
            }
        }).forEach(appendConsumer);
        pipeline.skip(limit).forEach(appendConsumer);
        return builder.toString();
    }

    public static String capitalize(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        char firstChar = str.charAt(0);
        if (Character.isTitleCase(firstChar)) {
            return str;
        }
        return new StringBuilder(strLen).append(Character.toTitleCase(firstChar)).append(str.substring(1)).toString();
    }

    public static String uncapitalize(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        char firstChar = str.charAt(0);
        if (Character.isLowerCase(firstChar)) {
            return str;
        }
        return new StringBuilder(strLen).append(Character.toLowerCase(firstChar)).append(str.substring(1)).toString();
    }

    public static String swapCase(String str) {
        if (Strings.isEmpty(str)) {
            return str;
        }
        char[] buffer = str.toCharArray();
        for (int i = 0; i < buffer.length; ++i) {
            char ch = buffer[i];
            if (Character.isUpperCase(ch)) {
                buffer[i] = Character.toLowerCase(ch);
                continue;
            }
            if (Character.isTitleCase(ch)) {
                buffer[i] = Character.toLowerCase(ch);
                continue;
            }
            if (!Character.isLowerCase(ch)) continue;
            buffer[i] = Character.toUpperCase(ch);
        }
        return new String(buffer);
    }

    public static String completingLength(String str, int expectedLength, char c, boolean left) {
        if ((str = Strings.getEmptyIfNull(str)).length() < expectedLength) {
            String fillment = Strings.repeat(c, expectedLength - str.length());
            return left ? fillment + str : str + fillment;
        }
        return str;
    }

    public static <T> T convertTo(String str, Class<T> targetClass) {
        Preconditions.checkNotNull(targetClass);
        targetClass = Primitives.wrap(targetClass);
        if (Reflects.isSubClassOrEquals(Number.class, targetClass)) {
            Class<T> xClass = targetClass;
            return Numbers.parseNumber(str, xClass);
        }
        if (Reflects.isSubClassOrEquals(Boolean.class, targetClass)) {
            BooleanEvaluator booleanEvaluator = BooleanEvaluator.createTrueEvaluator(true, Boolean.TRUE, "true");
            return (T)(booleanEvaluator.evalTrue(str) ? Boolean.TRUE : Boolean.FALSE);
        }
        if (String.class == targetClass) {
            return (T)str;
        }
        if (targetClass.isEnum() && Reflects.isSubClassOrEquals(Enum.class, targetClass)) {
            Class<T> vClass = targetClass;
            return Enums.inferEnum(vClass, str);
        }
        if (Reflects.isSubClassOrEquals(Character.class, targetClass)) {
            return (T)Character.valueOf(Preconditions.checkNotEmpty(str).charAt(0));
        }
        return null;
    }

    public static boolean isVowelLetter(final char c) {
        return Collects.anyMatch(vowelLetters, new Predicate<String>(){

            @Override
            public boolean test(String vowelLetter) {
                return vowelLetter.equalsIgnoreCase(Strings.EMPTY + c);
            }
        });
    }

    public static boolean startsWithVowelLetter(String string) {
        if (Strings.isBlank(string)) {
            return false;
        }
        return Strings.isVowelLetter(string.trim().charAt(0));
    }

    public static String trim(String str) {
        return str == null ? null : str.trim();
    }

    public static String trimToNull(String str) {
        String ts = Strings.trim(str);
        return Strings.isEmpty(ts) ? null : ts;
    }

    public static String trimToEmpty(String str) {
        return str == null ? EMPTY : str.trim();
    }

    public static String truncate(String str, int maxWidth) {
        return Strings.truncate(str, 0, maxWidth);
    }

    public static String truncate(String str, int offset, int maxWidth) {
        if (offset < 0) {
            throw new IllegalArgumentException("offset cannot be negative");
        }
        if (maxWidth < 0) {
            throw new IllegalArgumentException("maxWith cannot be negative");
        }
        if (str == null) {
            return null;
        }
        if (offset > str.length()) {
            return EMPTY;
        }
        if (str.length() > maxWidth) {
            int ix = offset + maxWidth > str.length() ? str.length() : offset + maxWidth;
            return str.substring(offset, ix);
        }
        return str.substring(offset);
    }

    public static String substring(String str, int start) {
        if (str == null) {
            return null;
        }
        if (start < 0) {
            start = str.length() + start;
        }
        if (start < 0) {
            start = 0;
        }
        if (start > str.length()) {
            return EMPTY;
        }
        return str.substring(start);
    }

    public static String substring(String str, int start, int end) {
        if (str == null) {
            return null;
        }
        if (end < 0) {
            end = str.length() + end;
        }
        if (start < 0) {
            start = str.length() + start;
        }
        if (end > str.length()) {
            end = str.length();
        }
        if (start > end) {
            return EMPTY;
        }
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = 0;
        }
        return str.substring(start, end);
    }

    public static String strip(String str) {
        return Strings.strip(str, null);
    }

    public static String stripToNull(String str) {
        if (str == null) {
            return null;
        }
        return (str = Strings.strip(str, null)).isEmpty() ? null : str;
    }

    public static String stripToEmpty(String str) {
        return str == null ? EMPTY : Strings.strip(str, null);
    }

    public static String strip(String str, String stripChars) {
        if (Strings.isEmpty(str)) {
            return str;
        }
        str = Strings.stripStart(str, stripChars);
        return Strings.stripEnd(str, stripChars);
    }

    public static String stripStart(String str, String stripChars) {
        int start;
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        if (stripChars == null) {
            for (start = 0; start != strLen && Character.isWhitespace(str.charAt(start)); ++start) {
            }
        } else {
            if (stripChars.isEmpty()) {
                return str;
            }
            while (start != strLen && stripChars.indexOf(str.charAt(start)) != -1) {
                ++start;
            }
        }
        return str.substring(start);
    }

    public static String stripEnd(String str, String stripChars) {
        int end;
        if (str == null || (end = str.length()) == 0) {
            return str;
        }
        if (stripChars == null) {
            while (end != 0 && Character.isWhitespace(str.charAt(end - 1))) {
                --end;
            }
        } else {
            if (stripChars.isEmpty()) {
                return str;
            }
            while (end != 0 && stripChars.indexOf(str.charAt(end - 1)) != -1) {
                --end;
            }
        }
        return str.substring(0, end);
    }

    public static String[] stripAll(String ... strs) {
        return Strings.stripAll(strs, null);
    }

    public static String[] stripAll(String[] strs, String stripChars) {
        int strsLen;
        if (strs == null || (strsLen = strs.length) == 0) {
            return strs;
        }
        String[] newArr = new String[strsLen];
        for (int i = 0; i < strsLen; ++i) {
            newArr[i] = Strings.strip(strs[i], stripChars);
        }
        return newArr;
    }

    private static void convertRemainingAccentCharacters(StringBuilder decomposed) {
        for (int i = 0; i < decomposed.length(); ++i) {
            if (decomposed.charAt(i) == '\u0141') {
                decomposed.deleteCharAt(i);
                decomposed.insert(i, 'L');
                continue;
            }
            if (decomposed.charAt(i) != '\u0142') continue;
            decomposed.deleteCharAt(i);
            decomposed.insert(i, 'l');
        }
    }

    public static boolean equals(CharSequence cs1, CharSequence cs2, boolean ignoreCase) {
        if (!ignoreCase) {
            return Strings.equals(cs1, cs2);
        }
        return Strings.equalsIgnoreCase(cs1, cs2);
    }

    public static boolean equals(CharSequence cs1, CharSequence cs2) {
        if (cs1 == cs2) {
            return true;
        }
        if (cs1 == null || cs2 == null) {
            return false;
        }
        if (cs1.length() != cs2.length()) {
            return false;
        }
        if (cs1 instanceof String && cs2 instanceof String) {
            return cs1.equals(cs2);
        }
        int length = cs1.length();
        for (int i = 0; i < length; ++i) {
            if (cs1.charAt(i) == cs2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsIgnoreCase(CharSequence cs1, CharSequence cs2) {
        if (cs1 == cs2) {
            return true;
        }
        if (cs1 == null || cs2 == null) {
            return false;
        }
        if (cs1.length() != cs2.length()) {
            return false;
        }
        return Strings.regionMatches(cs1, true, 0, cs2, 0, cs1.length());
    }

    public static int compare(String str1, String str2) {
        return Strings.compare(str1, str2, true);
    }

    public static int compare(String str1, String str2, boolean nullIsLess) {
        if (Objs.equals(str1, str2)) {
            return 0;
        }
        if (str1 == null) {
            return nullIsLess ? -1 : 1;
        }
        if (str2 == null) {
            return nullIsLess ? 1 : -1;
        }
        return str1.compareTo(str2);
    }

    public static int compareIgnoreCase(String str1, String str2) {
        return Strings.compareIgnoreCase(str1, str2, true);
    }

    public static int compareIgnoreCase(String str1, String str2, boolean nullIsLess) {
        if (Objs.equals(str1, str2)) {
            return 0;
        }
        if (str1 == null) {
            return nullIsLess ? -1 : 1;
        }
        if (str2 == null) {
            return nullIsLess ? 1 : -1;
        }
        return str1.compareToIgnoreCase(str2);
    }

    public static boolean equalsAny(CharSequence string, CharSequence ... searchStrings) {
        if (Emptys.isNotEmpty(searchStrings)) {
            for (CharSequence next : searchStrings) {
                if (!Strings.equals(string, next)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean equalsAnyIgnoreCase(CharSequence string, CharSequence ... searchStrings) {
        if (Emptys.isNotEmpty(searchStrings)) {
            for (CharSequence next : searchStrings) {
                if (!Strings.equalsIgnoreCase(string, next)) continue;
                return true;
            }
        }
        return false;
    }

    public static int indexOf(CharSequence seq, int searchChar) {
        return Strings.indexOf(seq, searchChar, 0);
    }

    public static int indexOf(CharSequence seq, int searchChar, int startPos) {
        if (Strings.isEmpty(seq)) {
            return -1;
        }
        if (Strings.isEmpty(seq)) {
            return -1;
        }
        if (seq instanceof String) {
            return seq.toString().indexOf(searchChar, 0);
        }
        int sz = seq.length();
        if (startPos < 0) {
            startPos = 0;
        }
        if (searchChar < 65536) {
            for (int i = startPos; i < sz; ++i) {
                if (seq.charAt(i) != searchChar) continue;
                return i;
            }
        }
        if (searchChar <= 0x10FFFF) {
            char[] chars = Character.toChars(searchChar);
            for (int i = startPos; i < sz - 1; ++i) {
                char high = seq.charAt(i);
                char low = seq.charAt(i + 1);
                if (high != chars[0] || low != chars[1]) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOf(CharSequence seq, CharSequence searchSeq) {
        return Strings.indexOf(seq, searchSeq, false);
    }

    public static int indexOf(CharSequence seq, CharSequence searchSeq, boolean ignoreCase) {
        return Strings.indexOf(seq, searchSeq, 0, ignoreCase);
    }

    public static int indexOf(CharSequence seq, CharSequence searchSeq, int startPos) {
        return Strings.indexOf(seq, searchSeq, startPos, false);
    }

    public static int indexOf(CharSequence seq, CharSequence searchSeq, int startPos, boolean ignoreCase) {
        if (seq == null || searchSeq == null) {
            return -1;
        }
        if (ignoreCase) {
            return seq.toString().toLowerCase().indexOf(searchSeq.toString().toLowerCase(), startPos);
        }
        return seq.toString().indexOf(searchSeq.toString(), startPos);
    }

    public static CharSequence subSequence(CharSequence cs, int start) {
        return cs == null ? null : cs.subSequence(start, cs.length());
    }

    public static int lastIndexOf(CharSequence cs, int searchChar, int start) {
        if (cs instanceof String) {
            return ((String)cs).lastIndexOf(searchChar, start);
        }
        int sz = cs.length();
        if (start < 0) {
            return -1;
        }
        if (start >= sz) {
            start = sz - 1;
        }
        if (searchChar < 65536) {
            for (int i = start; i >= 0; --i) {
                if (cs.charAt(i) != searchChar) continue;
                return i;
            }
        }
        if (searchChar <= 0x10FFFF) {
            char[] chars = Character.toChars(searchChar);
            if (start == sz - 1) {
                return -1;
            }
            for (int i = start; i >= 0; --i) {
                char high = cs.charAt(i);
                char low = cs.charAt(i + 1);
                if (chars[0] != high || chars[1] != low) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(CharSequence cs, CharSequence searchChar, int start) {
        return cs.toString().lastIndexOf(searchChar.toString(), start);
    }

    public static int lastIndexOf(CharSequence cs, CharSequence searchChar) {
        return cs.toString().lastIndexOf(searchChar.toString(), cs.length());
    }

    public static int lastIndexOfIgnoreCase(CharSequence str, CharSequence searchStr) {
        if (str == null || searchStr == null) {
            return -1;
        }
        return Strings.lastIndexOfIgnoreCase(str, searchStr, str.length());
    }

    public static int lastIndexOfIgnoreCase(CharSequence str, CharSequence searchStr, int startPos) {
        if (str == null || searchStr == null) {
            return -1;
        }
        int searchStrLength = searchStr.length();
        int strLength = str.length();
        if (startPos > strLength - searchStrLength) {
            startPos = strLength - searchStrLength;
        }
        if (startPos < 0) {
            return -1;
        }
        if (searchStrLength == 0) {
            return startPos;
        }
        for (int i = startPos; i >= 0; --i) {
            if (!Strings.regionMatches(str, true, i, searchStr, 0, searchStrLength)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfAnyBut(CharSequence cs, char ... searchChars) {
        if (Strings.isEmpty(cs) || Objs.isEmpty(searchChars)) {
            return -1;
        }
        int csLen = cs.length();
        int csLast = csLen - 1;
        int searchLen = searchChars.length;
        int searchLast = searchLen - 1;
        block0: for (int i = 0; i < csLen; ++i) {
            char ch = cs.charAt(i);
            for (int j = 0; j < searchLen; ++j) {
                if (searchChars[j] == ch && (i >= csLast || j >= searchLast || !Character.isHighSurrogate(ch) || searchChars[j + 1] == cs.charAt(i + 1))) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static int indexOfAnyBut(CharSequence seq, CharSequence searchChars) {
        if (Strings.isEmpty(seq) || Strings.isEmpty(searchChars)) {
            return -1;
        }
        int strLen = seq.length();
        for (int i = 0; i < strLen; ++i) {
            boolean chFound;
            char ch = seq.charAt(i);
            boolean bl = chFound = Strings.indexOf(searchChars, ch, 0) >= 0;
            if (i + 1 < strLen && Character.isHighSurrogate(ch)) {
                char ch2 = seq.charAt(i + 1);
                if (!chFound || Strings.indexOf(searchChars, ch2, 0) >= 0) continue;
                return i;
            }
            if (chFound) continue;
            return i;
        }
        return -1;
    }

    public static char[] toCharArray(CharSequence cs) {
        if (cs instanceof String) {
            return ((String)cs).toCharArray();
        }
        int sz = cs.length();
        char[] array = new char[cs.length()];
        for (int i = 0; i < sz; ++i) {
            array[i] = cs.charAt(i);
        }
        return array;
    }

    public static boolean regionMatches(CharSequence cs, boolean ignoreCase, int thisStart, CharSequence substring, int start, int length) {
        if (cs instanceof String && substring instanceof String) {
            return ((String)cs).regionMatches(ignoreCase, thisStart, (String)substring, start, length);
        }
        int index1 = thisStart;
        int index2 = start;
        int tmpLen = length;
        int srcLen = cs.length() - thisStart;
        int otherLen = substring.length() - start;
        if (thisStart < 0 || start < 0 || length < 0) {
            return false;
        }
        if (srcLen < length || otherLen < length) {
            return false;
        }
        while (tmpLen-- > 0) {
            char c2;
            char c1;
            if ((c1 = cs.charAt(index1++)) == (c2 = substring.charAt(index2++))) continue;
            if (!ignoreCase) {
                return false;
            }
            if (Character.toUpperCase(c1) == Character.toUpperCase(c2) || Character.toLowerCase(c1) == Character.toLowerCase(c2)) continue;
            return false;
        }
        return true;
    }

    public static String[] toStringArray(Iterable<String> strings) {
        return Pipeline.of(strings).toArray(String[].class);
    }

    public static String underlineToCamel(String string, boolean firstLetterToLower) {
        return Strings.separatorToCamel(string, "_", firstLetterToLower);
    }

    public static String separatorToCamel(String string, String separator, boolean firstLetterToLower) {
        final StringBuilder builder = new StringBuilder();
        Pipeline.of(Strings.split(string, separator)).map(new Function<String, String>(){

            @Override
            public String apply(String input) {
                return input.toLowerCase();
            }
        }).forEach(new Consumer<String>(){

            @Override
            public void accept(String s) {
                builder.append(Strings.upperCase(s, 0, 1));
            }
        });
        if (firstLetterToLower) {
            return Strings.lowerCase(builder.toString(), 0, 1);
        }
        return builder.toString();
    }

    public static String shortenTextWithEllipsis(@NonNull String text, int maxLength, int suffixLength) {
        Preconditions.checkNotNullArgument(text, "text");
        return Strings.shortenTextWithEllipsis(text, maxLength, suffixLength, false);
    }

    public static String shortenTextWithEllipsis(@NonNull String text, int maxLength, int suffixLength, boolean useEllipsisSymbol) {
        Preconditions.checkNotNullArgument(text, "text");
        String symbol = useEllipsisSymbol ? "\u2026" : "...";
        return Strings.shortenTextWithEllipsis(text, maxLength, suffixLength, symbol);
    }

    public static String shortenTextWithEllipsis(@NonNull String text, int maxLength, int suffixLength, @NonNull String symbol) {
        Preconditions.checkNotNullArgument(text, "text");
        Preconditions.checkNotNullArgument(symbol, "symbol");
        int textLength = text.length();
        if (textLength > maxLength) {
            int prefixLength = maxLength - suffixLength - symbol.length();
            assert (prefixLength >= 0);
            if (text.substring(0, prefixLength) + symbol + text.substring(textLength - suffixLength) == null) {
                throw new NullPointerException();
            }
            return text.substring(0, prefixLength) + symbol + text.substring(textLength - suffixLength);
        }
        return text;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BOM findBom(String str) {
        BOM bOM;
        UnicodeInputStream inputStream = null;
        try {
            inputStream = new UnicodeInputStream(new ByteArrayInputStream(str.getBytes()));
            bOM = inputStream.getBom();
        }
        catch (IOException iOException) {
            IOs.close(inputStream);
            return null;
        }
        catch (Throwable throwable) {
            IOs.close(inputStream);
            throw throwable;
        }
        IOs.close(inputStream);
        return bOM;
    }

    public static char[] chars(CharSequence sequence) {
        return Strings.chars(sequence, 0);
    }

    public static char[] chars(CharSequence sequence, int begin) {
        return Strings.chars(sequence, begin, sequence.length());
    }

    public static char[] chars(CharSequence sequence, int begin, int end) {
        CharSequence sub = sequence.subSequence(begin, end);
        int length = sub.length();
        char[] ret = new char[length];
        for (int i = 0; i < sub.length(); ++i) {
            ret[i] = sub.charAt(i);
        }
        return ret;
    }
}

