/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.exception.RuntimeIOException;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.ThrowableFunction;
import com.jn.langx.util.ThrowableFunction2;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.function.Supplier;
import com.jn.langx.util.io.IOs;
import com.jn.langx.util.logging.Level;
import com.jn.langx.util.logging.Loggers;
import com.jn.langx.util.reflect.Reflects;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;

public class Throwables {
    private static final String JAVA_LANG_ACCESS_CLASSNAME = "sun.misc.JavaLangAccess";
    static final String SHARED_SECRETS_CLASSNAME = "sun.misc.SharedSecrets";
    private static final Object jla = Throwables.getJLA();
    @Nullable
    private static final Method getStackTraceElementMethod = jla == null ? null : Throwables.getGetMethod();
    @Nullable
    private static final Method getStackTraceDepthMethod = jla == null ? null : Throwables.getDepthMethod();

    private Throwables() {
    }

    public static String stringify(Throwable t) {
        return Throwables.getStackTraceAsString(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStackTraceAsString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        try {
            throwable.printStackTrace(printWriter);
            printWriter.flush();
            String string = stringWriter.toString();
            return string;
        }
        finally {
            IOs.close(printWriter);
        }
    }

    public static Throwable throwIfError(Throwable ex) {
        if (ex instanceof Error) {
            throw (Error)ex;
        }
        return ex;
    }

    public static Throwable throwIfRuntimeException(Throwable ex) {
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        return ex;
    }

    public static Throwable throwIfIOException(Throwable ex) throws IOException {
        if (ex instanceof IOException) {
            throw (IOException)ex;
        }
        return ex;
    }

    public static RuntimeException wrapAsRuntimeException(Throwable ex) {
        if (ex instanceof RuntimeException) {
            return (RuntimeException)ex;
        }
        return new RuntimeException(ex);
    }

    public static void throwAsRuntimeException(Throwable ex) {
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        throw new RuntimeException(ex);
    }

    public static RuntimeIOException wrapAsRuntimeIOException(IOException ex) {
        return new RuntimeIOException(ex);
    }

    public static Throwable getRootCause(Throwable ex) {
        while (ex.getCause() != null) {
            ex = ex.getCause();
        }
        return ex;
    }

    public static Throwable throwRootCauseIfIOException(Throwable ex) throws IOException {
        return Throwables.throwIfIOException(Throwables.getRootCause(ex));
    }

    public static void log(@NonNull Throwable ex) {
        Preconditions.checkNotNull(ex);
        Loggers.log(1, null, null, ex, (Supplier<Object[], String>)null, new Object[0]);
    }

    public static void log(@Nullable Logger logger, @Nullable Level level, @Nullable String message, @NonNull Throwable ex) {
        Preconditions.checkNotNull(ex);
        Loggers.log(1, logger, level, ex, message, new Object[0]);
    }

    private static Method getJlaMethod(String name, Class<?> ... parameterTypes) throws ThreadDeath {
        try {
            return Class.forName(JAVA_LANG_ACCESS_CLASSNAME, false, null).getMethod(name, parameterTypes);
        }
        catch (ThreadDeath death) {
            throw death;
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Nullable
    private static Object getJLA() {
        try {
            Class<?> sharedSecrets = Class.forName(SHARED_SECRETS_CLASSNAME, false, null);
            Method langAccess = sharedSecrets.getMethod("getJavaLangAccess", new Class[0]);
            return langAccess.invoke(null, new Object[0]);
        }
        catch (ThreadDeath death) {
            throw death;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static List<StackTraceElement> lazyStackTrace(Throwable throwable) {
        return Throwables.lazyStackTraceIsLazy() ? Throwables.jlaStackTrace(throwable) : Collections.unmodifiableList(Arrays.asList(throwable.getStackTrace()));
    }

    public static boolean lazyStackTraceIsLazy() {
        return getStackTraceElementMethod != null && getStackTraceDepthMethod != null;
    }

    private static List<StackTraceElement> jlaStackTrace(final Throwable t) {
        Preconditions.checkNotNull(t);
        return new AbstractList<StackTraceElement>(){

            @Override
            public StackTraceElement get(int n) {
                return (StackTraceElement)Throwables.invokeAccessibleNonThrowingMethod(getStackTraceElementMethod, jla, new Object[]{t, n});
            }

            @Override
            public int size() {
                return (Integer)Throwables.invokeAccessibleNonThrowingMethod(getStackTraceDepthMethod, jla, new Object[]{t});
            }
        };
    }

    @Nullable
    private static Method getGetMethod() {
        return Throwables.getJlaMethod("getStackTraceElement", Throwable.class, Integer.TYPE);
    }

    @Nullable
    private static Method getDepthMethod() {
        return Throwables.getJlaMethod("getStackTraceDepth", Throwable.class);
    }

    private static Object invokeAccessibleNonThrowingMethod(Method method, Object receiver, Object ... params) {
        return Reflects.invoke(method, receiver, params, true, true);
    }

    public static <I, O> O ignoreThrowable(@Nullable Logger logger, @Nullable O valueIfError, @NonNull ThrowableFunction<I, O> func, @Nullable I arg) {
        try {
            return func.apply(arg);
        }
        catch (Throwable ex) {
            logger = logger == null ? Loggers.getLogger(Throwables.class) : logger;
            logger.error(ex.getMessage(), ex);
            return valueIfError;
        }
    }

    public static <I1, I2, O> O ignoreThrowable(@Nullable Logger logger, @Nullable O valueIfError, @NonNull ThrowableFunction2<I1, I2, O> func, @Nullable I1 arg1, @Nullable I2 arg2) {
        try {
            return func.apply(arg1, arg2);
        }
        catch (Throwable ex) {
            logger = logger == null ? Loggers.getLogger(Throwables.class) : logger;
            logger.error(ex.getMessage(), ex);
            return valueIfError;
        }
    }

    public static <I, O> O ignoreExceptions(@Nullable Logger logger, @Nullable O valueIfError, @NonNull List<Class<Throwable>> throwables, @NonNull ThrowableFunction<I, O> func, @Nullable I arg) {
        try {
            return func.apply(arg);
        }
        catch (Throwable ex) {
            final Class<?> exClass = ex.getClass();
            if (Collects.noneMatch(throwables, new Predicate<Class<Throwable>>(){

                @Override
                public boolean test(Class<Throwable> exceptionClass) {
                    return Reflects.isSubClassOrEquals(exceptionClass, exClass);
                }
            })) {
                logger = logger == null ? Loggers.getLogger(Throwables.class) : logger;
                logger.error(ex.getMessage(), ex);
            }
            return valueIfError;
        }
    }

    public static <I1, I2, O> O ignoreExceptions(@Nullable Logger logger, @Nullable O valueIfError, @NonNull List<Class<Throwable>> throwables, @NonNull ThrowableFunction2<I1, I2, O> func, @Nullable I1 arg1, @Nullable I2 arg2) {
        try {
            return func.apply(arg1, arg2);
        }
        catch (Throwable ex) {
            final Class<?> exClass = ex.getClass();
            if (Collects.noneMatch(throwables, new Predicate<Class<Throwable>>(){

                @Override
                public boolean test(Class<Throwable> exceptionClass) {
                    return Reflects.isSubClassOrEquals(exceptionClass, exClass);
                }
            })) {
                logger = logger == null ? Loggers.getLogger(Throwables.class) : logger;
                logger.error(ex.getMessage(), ex);
            }
            return valueIfError;
        }
    }
}

