/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util;

import com.jn.langx.util.Preconditions;

public class Unsigneds {
    private Unsigneds() {
    }

    public static int toUnsignedByte(byte b) {
        return b & 0xFF;
    }

    public static int toUnsignedShort(short b) {
        return b & 0xFFFF;
    }

    public static int toUnsignedChar(char b) {
        return b & 0xFFFF;
    }

    public static long toUnsignedInt(int b) {
        return (long)b & 0xFFFFFFFFL;
    }

    public static byte toSignedByte(int b) {
        Preconditions.checkTrue(b >= 0, "not a signed byte: {}", b);
        int r = b;
        if (b >= 128) {
            r = b - 1 - 255;
        }
        return (byte)r;
    }

    public static short toSignedShort(int b) {
        Preconditions.checkTrue(b >= 0, "not a signed short: {}", b);
        int r = b;
        if (b >= 32768) {
            r = b - 1 - 65535;
        }
        return (short)r;
    }

    public static char toSignedChar(int b) {
        Preconditions.checkTrue(b >= 0, "not a signed short: {}", b);
        int r = b;
        if (b >= 32768) {
            r = b - 1 - 65535;
        }
        return (char)r;
    }

    public static int toSignedInt(long b) {
        Preconditions.checkTrue(b >= 0L, "not a signed int: {}", b);
        long r = b;
        if (b >= 0x80000000L) {
            r = b - 1L - 0xFFFFFFFFL;
        }
        return (int)r;
    }
}

