/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util;

import com.jn.langx.util.Chars;
import com.jn.langx.util.Objs;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.ranges.IntRange;

public class Validations {
    private Validations() {
    }

    public static boolean isValidRFC1123Hostname(String hostname) {
        if (!Validations.lengthInRange(hostname, 1, 256)) {
            return false;
        }
        String[] labels = Strings.split(hostname, ".", false, false);
        return Pipeline.of(labels).allMatch(new Predicate<String>(){

            @Override
            public boolean test(String label) {
                return Validations.isValidRFC1123Label(label);
            }
        });
    }

    private static boolean isValidRFC1123Label(String label) {
        if (!Validations.lengthInRange(label, 1, 64)) {
            return false;
        }
        for (int i = 0; i < label.length(); ++i) {
            char ch = label.charAt(i);
            if (ch != '-' && !Chars.isLowerCase(ch) && !Chars.isNumber(ch)) {
                return false;
            }
            if (i != 0 && i != label.length() - 1 || Chars.isLowerCase(ch) || Chars.isNumber(ch)) continue;
            return false;
        }
        return true;
    }

    public static boolean lengthInRange(Object value, int start, int end) {
        int length = Objs.length(value);
        return Validations.inRange(length, start, end);
    }

    public static boolean isValidPort(int port) {
        return Validations.inRange(port, 0, 65536);
    }

    public static boolean inRange(int num, int start, int end) {
        return new IntRange(start, end).contains(num);
    }
}

