/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.bit;

import com.jn.langx.util.Objs;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.function.Function;
import java.util.Collection;
import java.util.List;

public final class Masks {
    private Masks() {
    }

    public static <T> int createMask(Collection<T> operandHolders, Function<T, Integer> mapper) {
        List<Integer> operands = Pipeline.of(operandHolders).map(mapper).clearNulls().asList();
        return Masks.createMask(operands);
    }

    public static int createMask(int ... operands) {
        return Masks.createMask(Collects.asList(Collects.asIterable(operands)));
    }

    public static int createMask(Collection<Integer> operands) {
        Preconditions.checkNotNull(operands, "operand is required");
        Preconditions.checkArgument(Objs.isNotEmpty(operands), "operands is required");
        int mask = 0;
        for (int operand : operands) {
            mask = Masks.addOperand(mask, operand);
        }
        return mask;
    }

    public static int addOperand(int mask, int operand) {
        return mask | operand;
    }

    public static int removeOperand(int mask, int operand) {
        return mask & ~operand;
    }

    public static boolean containsOperand(int mask, int operand) {
        return (mask & operand) == operand;
    }
}

