/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.collection;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Maths;
import com.jn.langx.util.Objs;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Arrs;
import com.jn.langx.util.collection.Maps;
import com.jn.langx.util.collection.NonAbsentHashMap;
import com.jn.langx.util.collection.NonAbsentTreeMap;
import com.jn.langx.util.collection.NonDistinctTreeSet;
import com.jn.langx.util.collection.PrimitiveArrays;
import com.jn.langx.util.collection.StringMap;
import com.jn.langx.util.collection.WrappedNonAbsentMap;
import com.jn.langx.util.collection.diff.CollectionDiffResult;
import com.jn.langx.util.collection.diff.CollectionDiffer;
import com.jn.langx.util.collection.diff.KeyBuilder;
import com.jn.langx.util.collection.diff.MapDiffResult;
import com.jn.langx.util.collection.diff.MapDiffer;
import com.jn.langx.util.collection.iter.EnumerationIterable;
import com.jn.langx.util.collection.iter.IteratorIterable;
import com.jn.langx.util.collection.iter.WrappedIterable;
import com.jn.langx.util.collection.sequence.IterableSequence;
import com.jn.langx.util.collection.sequence.ListSequence;
import com.jn.langx.util.collection.sequence.SortedSetSequence;
import com.jn.langx.util.collection.sort.TimSort;
import com.jn.langx.util.collection.stack.Stack;
import com.jn.langx.util.comparator.ComparableComparator;
import com.jn.langx.util.comparator.Comparators;
import com.jn.langx.util.concurrent.ConcurrentHashSet;
import com.jn.langx.util.concurrent.threadlocal.GlobalThreadLocalMap;
import com.jn.langx.util.function.Collector;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.function.Consumer2;
import com.jn.langx.util.function.Function;
import com.jn.langx.util.function.Function2;
import com.jn.langx.util.function.Functions;
import com.jn.langx.util.function.Mapper;
import com.jn.langx.util.function.Mapper2;
import com.jn.langx.util.function.Operator2;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.function.Predicate2;
import com.jn.langx.util.function.Supplier;
import com.jn.langx.util.function.Supplier0;
import com.jn.langx.util.random.IRandom;
import com.jn.langx.util.reflect.type.Primitives;
import com.jn.langx.util.struct.Holder;
import com.jn.langx.util.struct.Pair;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Queue;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;

public class Collects {
    public static <T> Enumeration<T> immutableEmptyEnumeration() {
        return ImmutableEmptyEnumeration.EMPTY_ENUMERATION;
    }

    public static <E> List<E> immutableList() {
        return Collects.immutableList((List)null);
    }

    public static <E> List<E> immutableList(E ... elements) {
        return Collects.immutableList(Collects.asList(elements));
    }

    public static <E> List<E> immutableList(Collection<E> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Collects.asList(list));
    }

    public static <E> List<E> immutableList(List<E> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(list);
    }

    public static <E> List<E> immutableArrayList(List<E> list) {
        return Collections.unmodifiableList(Objs.useValueIfNull(list, Collects.<E>emptyArrayList()));
    }

    public static <E> List<E> immutableArrayList(E ... array) {
        return Collects.immutableList(Collects.newArrayList(array));
    }

    public static <E> List<E> emptyArrayList() {
        return new ArrayList();
    }

    public static <E> LinkedList<E> emptyLinkedList() {
        return new LinkedList();
    }

    public static <E> ArrayList<E> newArrayList() {
        return new ArrayList();
    }

    public static <E> ArrayList<E> newArrayList(Iterable<E> elements) {
        return new ArrayList<E>(Collects.asList(elements));
    }

    public static <E> ArrayList<E> newArrayList(Iterator<E> elements) {
        return Collects.newArrayList(Collects.asIterable(elements));
    }

    public static <E> ArrayList<E> newArrayList(E ... elements) {
        return new ArrayList<E>(Collects.asList(elements));
    }

    public static <E> ArrayList<E> newArrayListWithCapacity(int initialArraySize) {
        return new ArrayList(Maths.max(0, initialArraySize));
    }

    public static <E> ArrayList<E> newArrayListWithExpectedSize(int estimatedSize) {
        return new ArrayList(Maths.max(0, estimatedSize));
    }

    public static <E> LinkedList<E> newLinkedList() {
        return new LinkedList();
    }

    public static <E> LinkedList<E> newLinkedList(@Nullable Iterable<E> elements) {
        return new LinkedList<E>(Collects.asList(elements));
    }

    public static <E> LinkedList<E> newLinkedList(@Nullable Iterator<E> elements) {
        return Collects.newLinkedList(Collects.asIterable(elements));
    }

    public static <E> LinkedList<E> newLinkedList(E ... elements) {
        return new LinkedList<E>(Collects.asList(elements));
    }

    public static <E> CopyOnWriteArrayList<E> newCopyOnWriteArrayList() {
        return new CopyOnWriteArrayList();
    }

    public static <E> CopyOnWriteArrayList<E> newCopyOnWriteArrayList(Iterable<E> elements) {
        return new CopyOnWriteArrayList<E>(Collects.asList(elements));
    }

    public static <E> List<E> asList(E ... array) {
        return Collects.asList(array, true, ListType.ArrayList);
    }

    public static <E> List<E> asList(@Nullable E[] array, @Nullable ListType listType) {
        return Collects.asList(array, true, listType);
    }

    public static <E> List<E> asList(@Nullable E[] array, boolean mutable, @Nullable ListType listType) {
        List<Object> list;
        List<Object> immutableList;
        List<Object> list2 = immutableList = Emptys.isEmpty(array) ? Collections.emptyList() : Arrays.asList(array);
        if (listType == null) {
            listType = ListType.ArrayList;
        }
        switch (listType) {
            case LinkedList: {
                list = new LinkedList(immutableList);
                break;
            }
            case ArrayList: {
                list = new ArrayList(immutableList);
                break;
            }
            case STACK: {
                list = new java.util.Stack();
                list.addAll(immutableList);
                break;
            }
            case VECTOR: {
                list = new Vector(immutableList);
                break;
            }
            case CopyOnWrite: {
                list = new CopyOnWriteArrayList(immutableList);
                break;
            }
            default: {
                list = new ArrayList(immutableList);
            }
        }
        if (!mutable) {
            list = Collections.unmodifiableList(list);
        }
        return list;
    }

    public static <E> List<E> asList(@Nullable Iterable<E> iterable) {
        return Collects.asList(iterable, true);
    }

    public static <E> List<E> asList(@Nullable Iterable<E> iterable, boolean mutable) {
        if (Emptys.isNull(iterable)) {
            return Collects.emptyArrayList();
        }
        if (!(iterable instanceof List)) {
            return Collects.asList(Collects.collect(iterable, Collects.<E>toList()), mutable);
        }
        List list = (List)iterable;
        if (!mutable) {
            return Collections.unmodifiableList(list);
        }
        return list;
    }

    public static <E> List<E> getEmptyListIfNull(@Nullable List<E> list) {
        return Collects.getEmptyListIfNull(list, null);
    }

    public static <E> List<E> getEmptyListIfNull(@Nullable List<E> list, @Nullable ListType listType) {
        if (list == null) {
            if (listType == null) {
                return Collects.emptyArrayList();
            }
            switch (listType) {
                case LinkedList: {
                    list = Collects.emptyLinkedList();
                    break;
                }
                case CopyOnWrite: {
                    list = new CopyOnWriteArrayList();
                    break;
                }
                case STACK: {
                    list = new java.util.Stack();
                    break;
                }
                case VECTOR: {
                    list = new Vector();
                    break;
                }
                case ArrayList: {
                    list = Collects.emptyArrayList();
                    break;
                }
                default: {
                    list = Collects.emptyArrayList();
                }
            }
        }
        return list;
    }

    public static <E> Set<E> immutableSet() {
        return Collects.immutableSet((Set)null);
    }

    public static <E> Set<E> immutableSet(Set<E> set) {
        if (set == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(set);
    }

    public static <E> Set<E> immutableSet(Collection<E> collection) {
        return Collections.unmodifiableSet(Collects.asSet(collection));
    }

    public static <E> Set<E> immutableSet(E ... elements) {
        return Collections.unmodifiableSet(Collects.asSet(elements));
    }

    public static <E> HashSet<E> emptyHashSet() {
        return Collects.emptyHashSet(false);
    }

    public static <E> HashSet<E> emptyHashSet(boolean sequential) {
        return sequential ? new LinkedHashSet() : new HashSet();
    }

    public static <E> TreeSet<E> emptyTreeSet() {
        return new TreeSet();
    }

    public static <E> TreeSet<E> emptyTreeSet(@Nullable Comparator<E> comparator) {
        if (comparator == null) {
            return Collects.emptyTreeSet();
        }
        return new TreeSet<E>(comparator);
    }

    public static <E extends Enum<E>> EnumSet<E> newEnumSet(Iterable<E> iterable, Class<E> elementType) {
        EnumSet<E> set = EnumSet.noneOf(elementType);
        Collects.addAll(set, Collects.asList(iterable));
        return set;
    }

    public static <E> HashSet<E> newHashSet() {
        return new HashSet();
    }

    public static <E> HashSet<E> newHashSet(E ... elements) {
        return new HashSet<E>(Collects.asList(elements));
    }

    public static <E> HashSet<E> newHashSet(@Nullable Iterable<E> elements) {
        return new HashSet<E>(Collects.asList(elements));
    }

    public static <E> HashSet<E> newHashSet(Iterator<E> elements) {
        HashSet<E> set = Collects.newHashSet();
        Collects.addAll(set, Collects.asIterable(elements));
        return set;
    }

    public static <E> HashSet<E> newHashSetWithExpectedSize(int expectedSize) {
        return new HashSet(Maths.max(0, expectedSize));
    }

    public static <E> LinkedHashSet<E> newLinkedHashSet() {
        return new LinkedHashSet();
    }

    public static <E> LinkedHashSet<E> newLinkedHashSet(@Nullable Iterable<E> elements) {
        return new LinkedHashSet<E>(Collects.asList(elements));
    }

    public static <E> LinkedHashSet<E> newLinkedHashSet(E ... elements) {
        return new LinkedHashSet<E>(Collects.asList(elements));
    }

    public static <E> LinkedHashSet<E> newLinkedHashSetWithExpectedSize(int expectedSize) {
        return new LinkedHashSet(Maths.max(0, expectedSize));
    }

    public static <E extends Comparable> TreeSet<E> newTreeSet() {
        return new TreeSet();
    }

    public static <E> TreeSet<E> newTreeSet(Comparator<? super E> comparator) {
        return new TreeSet<E>(Preconditions.checkNotNull(comparator));
    }

    public static <E> TreeSet<E> newTreeSet(@Nullable Iterable<E> elements) {
        return new TreeSet<E>(Collects.asList(elements));
    }

    public static <E> TreeSet<E> newTreeSet(E ... elements) {
        return new TreeSet<E>(Collects.asList(elements));
    }

    public static <E> Set<E> newIdentityHashSet() {
        return Collections.newSetFromMap(Maps.newIdentityHashMap());
    }

    public static <E> Set<E> newConcurrentHashSet() {
        return new ConcurrentHashSet();
    }

    public static <E> Set<E> newConcurrentHashSet(Iterable<E> elements) {
        Set<E> set = Collects.newConcurrentHashSet();
        Collects.addAll(set, Collects.asList(elements));
        return set;
    }

    public static <E> CopyOnWriteArraySet<E> newCopyOnWriteArraySet() {
        return new CopyOnWriteArraySet();
    }

    public static <E> CopyOnWriteArraySet<E> newCopyOnWriteArraySet(Iterable<E> elements) {
        CopyOnWriteArraySet set = new CopyOnWriteArraySet();
        Collects.addAll(set, Collects.asList(elements));
        return set;
    }

    public static <E> Set<E> asSet(E ... array) {
        return Collects.asSet(array, true, SetType.HashSet);
    }

    public static <E> Set<E> asSet(@Nullable E[] array, @Nullable SetType setType) {
        return Collects.asSet(array, true, setType);
    }

    public static <E> Set<E> asSet(@Nullable Iterable<E> iterable) {
        return Collects.asSet(iterable, true);
    }

    public static <E> Set<E> asSet(@Nullable Iterable<E> iterable, boolean mutable) {
        if (Emptys.isNull(iterable)) {
            HashSet<E> set = Collects.emptyHashSet();
            return mutable ? set : Collections.unmodifiableSet(set);
        }
        List<E> c = iterable instanceof Collection ? (List<E>)iterable : Collects.asList(iterable);
        HashSet<E> set = new HashSet<E>(c);
        return mutable ? set : Collections.unmodifiableSet(set);
    }

    public static <E> Set<E> asSet(@Nullable E[] array, boolean mutable, @Nullable SetType setType) {
        List<E> immutableList;
        List<E> list = immutableList = Emptys.isEmpty(array) ? Collects.emptyArrayList() : Arrays.asList(array);
        if (setType == null) {
            setType = SetType.HashSet;
        }
        Set<E> set = null;
        switch (setType) {
            case HashSet: {
                set = new HashSet<E>(immutableList);
                if (mutable) break;
                set = Collections.unmodifiableSet(set);
                break;
            }
            case LinkedHashSet: {
                set = new LinkedHashSet<E>(immutableList);
                if (mutable) break;
                set = Collections.unmodifiableSet(set);
                break;
            }
            case TreeSet: {
                TreeSet<E> tset = new TreeSet<E>(immutableList);
                if (mutable) break;
                set = Collections.unmodifiableSortedSet(tset);
                break;
            }
            case NonDistinctTreeSet: {
                NonDistinctTreeSet<E> tset2 = new NonDistinctTreeSet<E>(immutableList);
                if (mutable) break;
                set = Collections.unmodifiableSortedSet(tset2);
                break;
            }
            default: {
                set = new HashSet<E>(immutableList);
                if (mutable) break;
                set = Collections.unmodifiableSet(set);
            }
        }
        return set;
    }

    public static <E> Set<E> getEmptySetIfNull(@Nullable Set<E> set) {
        return Collects.getEmptySetIfNull(set, null);
    }

    public static <E> Set<E> getEmptySetIfNull(@Nullable Set<E> set, @Nullable SetType setType) {
        if (set == null) {
            if (setType == null) {
                return Collects.emptyHashSet();
            }
            switch (setType) {
                case HashSet: {
                    set = Collects.emptyHashSet();
                    break;
                }
                case TreeSet: {
                    set = Collects.emptyTreeSet();
                    break;
                }
                case LinkedHashSet: {
                    set = Collects.emptyHashSet(true);
                    break;
                }
                default: {
                    set = Collects.emptyHashSet();
                }
            }
        }
        return set;
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap() {
        return new ConcurrentHashMap();
    }

    public static <K, V> Hashtable emptyHashtable() {
        return new Hashtable();
    }

    public static <K, V> TreeMap<K, V> emptyTreeMap() {
        return new TreeMap();
    }

    public static <K, V> TreeMap<K, V> emptyTreeMap(@Nullable Comparator<K> comparator) {
        if (comparator == null) {
            return Collects.emptyTreeMap();
        }
        return new TreeMap(comparator);
    }

    public static <K, V> Map<K, V> immutableMap() {
        return Collects.immutableMap(null);
    }

    public static <K, V> Map<K, V> immutableMap(Map<K, V> m) {
        if (m == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(m);
    }

    public static <K, V> HashMap<K, V> emptyHashMap() {
        return new HashMap();
    }

    public static <K, V> HashMap<K, V> emptyHashMap(boolean sequential) {
        return sequential ? new LinkedHashMap() : new HashMap();
    }

    public static <K, V> NonAbsentHashMap<K, V> emptyNonAbsentHashMap(@NonNull Supplier<K, V> supplier) {
        Preconditions.checkNotNull(supplier);
        return new NonAbsentHashMap<K, V>(supplier);
    }

    public static <K, V> WrappedNonAbsentMap<K, V> wrapAsNonAbsentMap(@NonNull Map<K, V> map, @NonNull Supplier<K, V> supplier) {
        Preconditions.checkNotNull(map);
        Preconditions.checkNotNull(supplier);
        return new WrappedNonAbsentMap<K, V>(map, supplier);
    }

    public static HashMap ofMap(Object ... keyValuePairs) {
        int size = keyValuePairs.length % 2 == 0 ? keyValuePairs.length / 2 : keyValuePairs.length / 2 + 1;
        HashMap<Object, Object> map = new HashMap<Object, Object>(size);
        for (int i = 0; i < size; ++i) {
            int j = 2 * i;
            Object key = keyValuePairs[j];
            Object value = j + 1 >= keyValuePairs.length ? null : keyValuePairs[j + 1];
            map.put(key, value);
        }
        return map;
    }

    public static <K, V> Map<K, V> newMap(Pair<K, V> ... pairs) {
        HashMap<K, V> map = new HashMap<K, V>(pairs.length);
        for (int i = 0; i < pairs.length; ++i) {
            Pair<K, V> pair = pairs[i];
            map.put(pair.getKey(), pair.getValue());
        }
        return map;
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return Collects.emptyHashMap();
    }

    public static <K, V> HashMap<K, V> newHashMap(@Nullable Map<K, V> map) {
        if (Emptys.isEmpty(map)) {
            return Collects.emptyHashMap();
        }
        return new HashMap<K, V>(map);
    }

    public static <K, V> HashMap<K, V> newHashMapWithExpectedSize(int expectedSize) {
        return new HashMap(Maths.max(expectedSize, 0));
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(Map<K, V> map) {
        return new LinkedHashMap<K, V>(map);
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMapWithExpectedSize(int expectedSize) {
        return new LinkedHashMap(Maths.max(expectedSize, 0));
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentMap() {
        return new ConcurrentHashMap();
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentMap(Map<K, V> map) {
        if (map == null) {
            return Collects.newConcurrentMap();
        }
        return new ConcurrentHashMap<K, V>(map);
    }

    public static <K, V> TreeMap<K, V> newTreeMap() {
        return Collects.emptyTreeMap();
    }

    public static <K, V> TreeMap<K, V> newTreeMap(SortedMap<K, V> map) {
        return new TreeMap<K, V>(map);
    }

    public static <C, K extends C, V> TreeMap<K, V> newTreeMap(Comparator<C> comparator) {
        return new TreeMap(comparator);
    }

    public static <K, V> TreeMap<K, V> newTreeMap(Map<K, V> map) {
        if (map == null) {
            return new TreeMap();
        }
        Comparator comparator = null;
        if (map instanceof TreeMap) {
            comparator = ((TreeMap)map).comparator();
        }
        TreeMap<K, V> treeMap = new TreeMap<K, V>(comparator);
        treeMap.putAll(map);
        return treeMap;
    }

    public static <K, V> TreeMap<K, V> newTreeMap(Map<K, V> map, Comparator<K> keyComparator) {
        TreeMap<K, V> treeMap = new TreeMap<K, V>(keyComparator);
        if (Emptys.isNotEmpty(map)) {
            treeMap.putAll(map);
        }
        return treeMap;
    }

    public static <K extends Enum<K>, V> EnumMap<K, V> newEnumMap(Class<K> type) {
        return new EnumMap(Preconditions.checkNotNull(type));
    }

    public static <K extends Enum<K>, V> EnumMap<K, V> newEnumMap(Map<K, V> map) {
        return new EnumMap<K, V>(map);
    }

    public static <K, V> IdentityHashMap<K, V> newIdentityHashMap() {
        return new IdentityHashMap();
    }

    public static <K, V> Map<K, V> getEmptyMapIfNull(@Nullable Map<K, V> map) {
        return Collects.getEmptyMapIfNull(map, null);
    }

    public static <K, V> Map<K, V> getEmptyMapIfNull(@Nullable Map<K, V> map, @Nullable MapType mapType) {
        if (map == null) {
            Map<String, String> map1;
            if (mapType == null) {
                return Collects.emptyHashMap();
            }
            switch (mapType) {
                case StringMap: {
                    map1 = new StringMap();
                    break;
                }
                case HashMap: {
                    map1 = Collects.emptyHashMap();
                    break;
                }
                case TreeMap: {
                    map1 = Collects.emptyTreeMap();
                    break;
                }
                case LinkedHashMap: {
                    map1 = Collects.emptyHashMap(true);
                    break;
                }
                case IdentityHashMap: {
                    map1 = new IdentityHashMap();
                    break;
                }
                case Hashtable: {
                    map1 = Collects.emptyHashtable();
                    break;
                }
                case Properties: {
                    map1 = new Properties();
                    break;
                }
                default: {
                    map1 = Collects.emptyHashMap();
                }
            }
            return map1;
        }
        return map;
    }

    private static SetType inferSetType(@NonNull Set set) {
        Preconditions.checkNotNull(set);
        if (set instanceof SortedSet) {
            return SetType.TreeSet;
        }
        if (set instanceof HashSet) {
            if (set instanceof LinkedHashSet) {
                return SetType.LinkedHashSet;
            }
            return SetType.HashSet;
        }
        return SetType.HashSet;
    }

    private static ListType inferListType(@NonNull List list) {
        if (list instanceof CopyOnWriteArrayList) {
            return ListType.CopyOnWrite;
        }
        if (list instanceof LinkedList) {
            return ListType.LinkedList;
        }
        if (list instanceof Stack) {
            return ListType.STACK;
        }
        if (list instanceof Vector) {
            return ListType.VECTOR;
        }
        if (list instanceof ArrayList) {
            return ListType.ArrayList;
        }
        return ListType.ArrayList;
    }

    private static Collection emptyCollectionByInfer(Collection prototype) {
        if (prototype == null) {
            return Collects.emptyArrayList();
        }
        if (prototype instanceof Set) {
            SetType setType = SetType.ofSet((Set)prototype);
            return Collects.getEmptySetIfNull(null, setType);
        }
        if (prototype instanceof Queue) {
            return Collects.emptyArrayList();
        }
        if (prototype instanceof List) {
            ListType listType = ListType.ofList((List)prototype);
            return Collects.getEmptyListIfNull(null, listType);
        }
        return Collects.emptyArrayList();
    }

    private static <E> Collection<E> newEmptyCollection(@Nullable Iterable<E> iterable) {
        if (iterable == null) {
            return Collects.emptyArrayList();
        }
        if (iterable instanceof Collection) {
            return Collects.emptyCollectionByInfer((Collection)iterable);
        }
        return Collects.emptyArrayList();
    }

    public static <E> Collection<E> asCollection(@Nullable Iterable<E> iterable) {
        if (Emptys.isNull(iterable)) {
            return Collects.emptyArrayList();
        }
        if (!(iterable instanceof Collection)) {
            final ArrayList<E> list = Collects.newArrayList();
            Collects.forEach(iterable, new Consumer<E>(){

                @Override
                public void accept(E e) {
                    list.add(e);
                }
            });
            return list;
        }
        return (Collection)iterable;
    }

    public static <E> E[] emptyArray(@Nullable Class<E> componentType) {
        return Arrs.createArray(Primitives.wrap(componentType), 0);
    }

    public static <E, C extends Collection<E>> Object[] toArray(@Nullable C collection) {
        if (Emptys.isEmpty(collection)) {
            List c = Collections.emptyList();
            return c.toArray();
        }
        return collection.toArray();
    }

    public static <E, C extends Collection<E>> E[] asArray(@Nullable C list, @NonNull Class<E> componentClass) {
        Preconditions.checkNotNull(componentClass);
        E[] array = Arrs.createArray(componentClass, Emptys.isEmpty(list) ? 0 : list.size());
        if (Emptys.isNotEmpty(list)) {
            list.toArray(array);
        }
        return array;
    }

    public static <E, C extends Collection<E>> E[] toArray(@Nullable C list, @Nullable Class<E[]> clazz) {
        Preconditions.checkNotNull(clazz);
        if (Emptys.isEmpty(list)) {
            List c = Collections.emptyList();
            return Arrays.copyOf(c.toArray(), list.size(), clazz);
        }
        return Arrays.copyOf(list.toArray(), list.size(), clazz);
    }

    public static <E> Iterable<E> asIterable(@Nullable Object object) {
        return Collects.asIterable(object, false);
    }

    public static <E> Iterable<E> asIterable(@Nullable Object object, boolean mutable) {
        if (Emptys.isNull(object)) {
            return Collects.asList(null, mutable, null);
        }
        if (Arrs.isArray(object)) {
            List a = Collects.asList(PrimitiveArrays.wrap(object));
            if (mutable) {
                return Collects.asList(a);
            }
            return Collections.unmodifiableList(a);
        }
        if (object instanceof Collection) {
            if (!mutable) {
                return Collections.unmodifiableCollection((Collection)object);
            }
            return (Collection)object;
        }
        if (object instanceof Iterable) {
            if (!mutable) {
                return new WrappedIterable((Iterable)object, false);
            }
            return (Iterable)object;
        }
        if (object instanceof Map) {
            return Collects.asList(Arrs.wrapAsArray(object), mutable, null);
        }
        if (object instanceof Iterator) {
            return new IteratorIterable((Iterator)object, mutable);
        }
        if (object instanceof Enumeration) {
            return new EnumerationIterable((Enumeration)object);
        }
        return Collects.asList(Arrs.wrapAsArray(object), mutable, null);
    }

    public static <E> Collection<E> filter(@Nullable Object anyObject, @NonNull Predicate<E> predicate) {
        return Collects.filter(anyObject, predicate, null);
    }

    public static <E> Collection<E> filter(@Nullable Object anyObject, @Nullable Predicate<E> consumePredicate, @Nullable Predicate<E> breakPredicate) {
        Iterable<E> iterable = Collects.asIterable(anyObject);
        final Collection<E> result = Collects.newEmptyCollection(iterable);
        consumePredicate = consumePredicate == null ? Functions.truePredicate() : consumePredicate;
        Collects.forEach(Collects.asCollection(iterable), consumePredicate, new Consumer<E>(){

            @Override
            public void accept(E e) {
                result.add(e);
            }
        }, breakPredicate);
        return result;
    }

    public static <E> Collection<E> filter(@Nullable Object anyObject, @Nullable Predicate2<Integer, E> consumePredicate, @Nullable Predicate2<Integer, E> breakPredicate) {
        Iterable<E> iterable = Collects.asIterable(anyObject);
        final Collection<E> result = Collects.newEmptyCollection(iterable);
        consumePredicate = consumePredicate == null ? Functions.truePredicate2() : consumePredicate;
        Collects.forEach(Collects.asCollection(iterable), consumePredicate, new Consumer2<Integer, E>(){

            @Override
            public void accept(Integer index, E e) {
                result.add(e);
            }
        }, breakPredicate);
        return result;
    }

    public static <K, V> Map<K, V> filter(@Nullable Map<K, V> map, final @NonNull Predicate2<K, V> predicate) {
        Preconditions.checkNotNull(predicate);
        final Map<K, V> result = Collects.getEmptyMapIfNull(null, MapType.ofMap(map));
        if (Emptys.isNotEmpty(map)) {
            Collects.forEach(map, new Consumer2<K, V>(){

                @Override
                public void accept(K key, V value) {
                    if (predicate.test(key, value)) {
                        result.put(key, value);
                    }
                }
            });
        }
        return result;
    }

    public static <E, R> Collection<R> map(@Nullable Object anyObject, final @NonNull Function<E, R> mapper) {
        Preconditions.checkNotNull(mapper);
        Iterable<E> iterable = Collects.asIterable(anyObject);
        final Collection<E> result = Collects.newEmptyCollection(iterable);
        Collects.forEach(iterable, new Consumer<E>(){

            @Override
            public void accept(E e) {
                result.add(mapper.apply(e));
            }
        });
        return result;
    }

    public static <E, K, V, M extends Map<K, V>> M map(@Nullable Object anyObject, final @NonNull Mapper<E, Pair<K, V>> mapper) {
        Preconditions.checkNotNull(mapper);
        final HashMap<K, V> result = Collects.emptyHashMap(true);
        Iterable<E> iterable = Collects.asIterable(anyObject);
        Collects.forEach(iterable, new Consumer<E>(){

            @Override
            public void accept(E e) {
                Pair pair = (Pair)mapper.apply(e);
                result.put(pair.getKey(), pair.getValue());
            }
        });
        return (M)result;
    }

    public static <K, V, R, M extends Map<K, V>> List<R> map(@Nullable M map, final @NonNull Function2<K, V, R> mapper) {
        Preconditions.checkNotNull(mapper);
        final List result = Collects.emptyArrayList();
        Collects.forEach(map, new Consumer2<K, V>(){

            @Override
            public void accept(K key, V value) {
                result.add(mapper.apply(key, value));
            }
        });
        return result;
    }

    public static <K, V, K1, V1, M extends Map<K, V>> Map<K1, V1> map(@Nullable M map, final @NonNull Mapper2<K, V, Pair<K1, V1>> mapper) {
        Preconditions.checkNotNull(mapper);
        final Map<K, V> result = Collects.getEmptyMapIfNull(null, MapType.ofMap(map));
        if (Emptys.isNotEmpty(map)) {
            Collects.forEach(map.entrySet(), new Consumer<Map.Entry<K, V>>(){

                @Override
                public void accept(Map.Entry<K, V> entry) {
                    Pair e = (Pair)mapper.apply(entry.getKey(), entry.getValue());
                    result.put(e.getKey(), e.getValue());
                }
            });
        }
        return result;
    }

    public static <E> Collection<E> flat(Collection<Collection<E>> collections) {
        return Collects.flatMap(collections, Functions.noopFunction());
    }

    public static <E, R> Collection<R> flatMap(final @NonNull Function<E, R> mapper, @Nullable Collection<E[]> collection) {
        if (Emptys.isEmpty(collection)) {
            return Collects.emptyArrayList();
        }
        Preconditions.checkNotNull(mapper);
        final Collection list = Collects.emptyCollectionByInfer(collection);
        Collects.forEach(collection, new Consumer<E[]>(){

            @Override
            public void accept(E[] c) {
                Collection rs = Collects.map(c, mapper);
                list.addAll(rs);
            }
        });
        return list;
    }

    public static <E, R, C extends Collection<? extends Iterable<E>>> Collection<R> flatMap(@Nullable C collection, final @NonNull Function<E, R> mapper) {
        if (Emptys.isEmpty(collection)) {
            return Collects.emptyArrayList();
        }
        Preconditions.checkNotNull(mapper);
        final Collection list = Collects.emptyCollectionByInfer(collection);
        Collects.forEach(collection, new Consumer<Collection<E>>(){

            @Override
            public void accept(Collection<E> c) {
                Collection rs = Collects.map(c, mapper);
                list.addAll(rs);
            }
        });
        return list;
    }

    public static <E> void forEach(Object obj, @NonNull Consumer<E> consumer) {
        Iterable<E> iterable = Collects.asIterable(obj);
        Collects.forEach(iterable, null, consumer, null);
    }

    public static <E, C extends Iterable<E>> void forEach(@Nullable C collection, @NonNull Consumer<E> consumer) {
        Collects.forEach(collection, null, consumer, null);
    }

    public static <E, C extends Iterable<E>> void forEach(@Nullable C collection, @Nullable Predicate<E> consumePredicate, @NonNull Consumer<E> consumer) {
        Collects.forEach(collection, consumePredicate, consumer, null);
    }

    public static <E, C extends Iterable<E>> void forEach(@Nullable C collection, @NonNull Consumer<E> consumer, @Nullable Predicate<E> breakPredicate) {
        Collects.forEach(collection, null, consumer, breakPredicate);
    }

    public static <E, C extends Iterable<E>> void forEach(@Nullable C collection, @Nullable Predicate<E> consumePredicate, @NonNull Consumer<E> consumer, @Nullable Predicate<E> breakPredicate) {
        if (Emptys.isNotEmpty(collection)) {
            consumePredicate = consumePredicate == null ? Functions.truePredicate() : consumePredicate;
            for (E element : collection) {
                if (consumePredicate.test(element)) {
                    consumer.accept(element);
                }
                if (breakPredicate == null || !breakPredicate.test(element)) continue;
                break;
            }
        }
    }

    public static <E> void forEach(Object obj, @NonNull Consumer2<Integer, E> consumer) {
        Iterable<E> iterable = Collects.asIterable(obj);
        Collects.forEach(iterable, null, consumer, null);
    }

    public static <E, C extends Collection<E>> void forEach(@Nullable C collection, @NonNull Consumer2<Integer, E> consumer) {
        Collects.forEach(collection, null, consumer, null);
    }

    public static <E, C extends Iterable<E>> void forEach(@Nullable C collection, @NonNull Consumer2<Integer, E> consumer) {
        Collects.forEach(collection, null, consumer, null);
    }

    public static <E, C extends Iterable<E>> void forEach(@Nullable C collection, @NonNull Consumer2<Integer, E> consumer, @Nullable Predicate2<Integer, E> breakPredicate) {
        Collects.forEach(collection, null, consumer, breakPredicate);
    }

    public static <E, C extends Iterable<E>> void forEach(@Nullable C collection, @Nullable Predicate2<Integer, E> consumePredicate, @NonNull Consumer2<Integer, E> consumer) {
        Collects.forEach(collection, consumePredicate, consumer, null);
    }

    public static <E, C extends Iterable<E>> void forEach(@Nullable C collection, @Nullable Predicate2<Integer, E> consumePredicate, @NonNull Consumer2<Integer, E> consumer, @Nullable Predicate2<Integer, E> breakPredicate) {
        Predicate2<Object, Object> predicate2 = consumePredicate = consumePredicate == null ? Functions.truePredicate2() : consumePredicate;
        if (Emptys.isNotEmpty(collection)) {
            Iterator<E> iterator = collection.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                E element = iterator.next();
                if (consumePredicate.test(i, element)) {
                    consumer.accept(i, element);
                }
                if (breakPredicate != null && breakPredicate.test(i, element)) break;
                ++i;
            }
        }
    }

    public static <E> void forEach(@Nullable E[] array, final @NonNull Consumer<E> consumer) {
        Collects.forEach(array, new Consumer2<Integer, E>(){

            @Override
            public void accept(Integer key, E value) {
                consumer.accept(value);
            }
        }, null);
    }

    public static <E> void forEach(@Nullable E[] array, @NonNull Consumer2<Integer, E> consumer) {
        Collects.forEach(array, consumer, null);
    }

    public static <E> void forEach(@Nullable E[] array, @NonNull Consumer2<Integer, E> consumer, @Nullable Predicate2<Integer, E> breakPredicate) {
        Collects.forEach(array, null, consumer, breakPredicate);
    }

    public static <E> void forEach(@Nullable E[] array, @Nullable Predicate2<Integer, E> consumePredicate, @NonNull Consumer2<Integer, E> consumer) {
        Collects.forEach(array, consumePredicate, consumer, null);
    }

    public static <E> void forEach(@Nullable E[] array, @Nullable Predicate<E> consumePredicate, @NonNull Consumer<E> consumer, @Nullable Predicate<E> breakPredicate) {
        Predicate predicate = consumePredicate = consumePredicate == null ? Functions.truePredicate() : consumePredicate;
        if (Emptys.isNotEmpty(array)) {
            for (int i = 0; i < array.length; ++i) {
                E element = array[i];
                if (consumePredicate.test(element)) {
                    consumer.accept(element);
                }
                if (breakPredicate != null && breakPredicate.test(element)) break;
            }
        }
    }

    public static <E> void forEach(@Nullable E[] array, @Nullable Predicate2<Integer, E> consumePredicate, @NonNull Consumer2<Integer, E> consumer, @Nullable Predicate2<Integer, E> breakPredicate) {
        Predicate2<Object, Object> predicate2 = consumePredicate = consumePredicate == null ? Functions.truePredicate2() : consumePredicate;
        if (Emptys.isNotEmpty(array)) {
            for (int i = 0; i < array.length; ++i) {
                E element = array[i];
                if (consumePredicate.test(i, element)) {
                    consumer.accept(i, element);
                }
                if (breakPredicate != null && breakPredicate.test(i, element)) break;
            }
        }
    }

    public static <K, V, M extends Map<? extends K, ? extends V>> void forEach(@Nullable M map, @NonNull Consumer2<K, V> consumer) {
        Collects.forEach(map, null, consumer, null);
    }

    public static <K, V, M extends Map<? extends K, ? extends V>> void forEach(@Nullable M map, @NonNull Consumer2<K, V> consumer, @Nullable Predicate2<K, V> breakPredicate) {
        Collects.forEach(map, null, consumer, breakPredicate);
    }

    public static <K, V, M extends Map<? extends K, ? extends V>> void forEach(@Nullable M map, @Nullable Predicate2<K, V> consumePredicate, @NonNull Consumer2<K, V> consumer) {
        Collects.forEach(map, consumePredicate, consumer, null);
    }

    public static <K, V, M extends Map<? extends K, ? extends V>> void forEach(@Nullable M map, @Nullable Predicate2<K, V> consumePredicate, @NonNull Consumer2<K, V> consumer, @Nullable Predicate2<K, V> breakPredicate) {
        Preconditions.checkNotNull(consumer);
        Predicate2<Object, Object> predicate2 = consumePredicate = consumePredicate == null ? Functions.truePredicate2() : consumePredicate;
        if (Emptys.isNotEmpty(map)) {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                if (consumePredicate.test(entry.getKey(), entry.getValue())) {
                    consumer.accept(entry.getKey(), entry.getValue());
                }
                if (breakPredicate == null || !breakPredicate.test(entry.getKey(), entry.getValue())) continue;
                break;
            }
        }
    }

    public static <E, C extends Collection<E>> Integer firstOccurrence(C c, final E item) {
        return Collects.firstOccurrence(c, new Predicate2<Integer, E>(){

            @Override
            public boolean test(Integer key, E value) {
                return Objs.equals(value, item);
            }
        });
    }

    public static <E, C extends Collection<E>> int firstOccurrence(C c, Predicate2<Integer, E> predicate) {
        List<Pair<Integer, E>> pairs = Collects.findNPairs(c, predicate, 1);
        if (Emptys.isEmpty(pairs)) {
            return -1;
        }
        Pair<Integer, E> pair = pairs.get(0);
        return pair.getKey();
    }

    public static <E, C extends Iterable<E>, O> O firstMap(@Nullable C collection, @NonNull Function2<Integer, E, O> mapper) {
        return Collects.firstMap(collection, mapper, (Predicate)null);
    }

    public static <E, C extends Iterable<E>, O> O firstMap(@Nullable C collection, final @NonNull Function2<Integer, E, O> mapper, final Predicate<O> breakPredicate) {
        final Holder holder = new Holder();
        Collects.forEach(collection, new Consumer2<Integer, E>(){

            @Override
            public void accept(Integer index, E value) {
                holder.set(mapper.apply(index, value));
            }
        }, new Predicate2<Integer, E>(){

            @Override
            public boolean test(Integer index, E value) {
                return breakPredicate == null ? !holder.isNull() : breakPredicate.test(holder.get());
            }
        });
        return (O)holder.get();
    }

    public static <E, C extends Iterable<E>, O> O firstMap(@Nullable C collection, final @NonNull Function2<Integer, E, O> mapper, final Predicate2<E, O> breakPredicate) {
        final Holder holder = new Holder();
        Collects.forEach(collection, new Consumer2<Integer, E>(){

            @Override
            public void accept(Integer index, E element) {
                holder.set(mapper.apply(index, element));
            }
        }, new Predicate2<Integer, E>(){

            @Override
            public boolean test(Integer index, E element) {
                return breakPredicate == null ? !holder.isNull() : breakPredicate.test(element, holder.get());
            }
        });
        return (O)holder.get();
    }

    public static <K, V, O> O firstMap(@Nullable Map<K, V> map, @NonNull Function2<K, V, O> mapper) {
        return Collects.firstMap(map, mapper, null);
    }

    public static <K, V, O> O firstMap(@Nullable Map<K, V> map, final @NonNull Function2<K, V, O> mapper, final Predicate<O> breakPredicate) {
        final Holder holder = new Holder();
        Collects.forEach(map, new Consumer2<K, V>(){

            @Override
            public void accept(K index, V value) {
                holder.set(mapper.apply(index, value));
            }
        }, new Predicate2<K, V>(){

            @Override
            public boolean test(K key, V value) {
                return breakPredicate == null ? !holder.isNull() : breakPredicate.test(holder.get());
            }
        });
        return (O)holder.get();
    }

    public static <E, C extends Collection<E>> E findFirst(@Nullable C collection) {
        return Collects.findFirst(collection, Functions.nonNullPredicate());
    }

    public static <E, C extends Collection<E>> E findFirst(@Nullable C collection, @Nullable Predicate<E> predicate) {
        List<E> list = Collects.findN(collection, predicate, 1);
        if (Emptys.isNotEmpty(list)) {
            return list.get(0);
        }
        return null;
    }

    public static <K, V> Map.Entry<? extends K, ? extends V> findFirst(@Nullable Map<? extends K, ? extends V> map, @Nullable Predicate2<K, V> predicate) {
        if (map == null) {
            return null;
        }
        if (Emptys.isNotEmpty(map)) {
            if (predicate != null) {
                for (Map.Entry<K, V> entry : map.entrySet()) {
                    if (!predicate.test(entry.getKey(), entry.getValue())) continue;
                    return entry;
                }
            } else {
                Set<Map.Entry<? extends K, ? extends V>> set = map.entrySet();
                ArrayList<Map.Entry<K, V>> list = new ArrayList<Map.Entry<K, V>>(set);
                return (Map.Entry)list.get(0);
            }
        }
        return null;
    }

    public static <E, C extends Collection<E>> List<E> findN(@Nullable C collection, @Nullable Predicate<E> predicate, final int n) {
        final List<E> ret = Collects.emptyArrayList();
        if (n <= 0 || Emptys.isEmpty(collection)) {
            return ret;
        }
        Collects.forEach(collection, predicate, new Consumer<E>(){

            @Override
            public void accept(E e) {
                ret.add(e);
            }
        }, new Predicate<E>(){

            @Override
            public boolean test(E value) {
                return ret.size() == n;
            }
        });
        return ret;
    }

    public static <E, C extends Collection<E>> List<Pair<Integer, E>> findNPairs(@Nullable C collection, @Nullable Predicate2<Integer, E> predicate, final int n) {
        final List<Pair<Integer, E>> ret = Collects.emptyArrayList();
        if (n <= 0 || Emptys.isEmpty(collection)) {
            return ret;
        }
        Collects.forEach(collection, predicate, new Consumer2<Integer, E>(){

            @Override
            public void accept(Integer index, E e) {
                ret.add(new Pair(index, e));
            }
        }, new Predicate2<Integer, E>(){

            @Override
            public boolean test(Integer index, E value) {
                return ret.size() == n;
            }
        });
        return ret;
    }

    public static <K, V> Map<? extends K, ? extends V> findN(@Nullable Map<? extends K, ? extends V> map, @Nullable Predicate2<K, V> predicate, final int n) {
        final HashMap<K, V> ret = Collects.emptyHashMap(true);
        if (n <= 0 || map == null || map.isEmpty()) {
            return ret;
        }
        Collects.forEach(map, predicate, new Consumer2<K, V>(){

            @Override
            public void accept(K key, V value) {
                ret.put(key, value);
            }
        }, new Predicate2<K, V>(){

            @Override
            public boolean test(K key, V value) {
                return n == ret.size();
            }
        });
        return ret;
    }

    public static <E, C extends Collection<E>> boolean removeIf(@Nullable C collection, @NonNull Predicate<E> predicate) {
        boolean hasRemoved = false;
        if (Emptys.isNotEmpty(collection)) {
            hasRemoved = Collects.removeIf(collection.iterator(), predicate);
        }
        return hasRemoved;
    }

    public static <E, C extends Collection<E>> void removeAll(C collection, final C removed) {
        Collects.removeIf(collection, new Predicate<E>(){

            @Override
            public boolean test(E element) {
                return removed.contains(element);
            }
        });
    }

    public static <E> boolean removeIf(@Nullable Iterator<E> iterator, @NonNull Predicate<E> predicate) {
        Preconditions.checkNotNull(iterator);
        Preconditions.checkNotNull(predicate);
        boolean hasRemoved = false;
        while (iterator.hasNext()) {
            E e = iterator.next();
            if (!predicate.test(e)) continue;
            try {
                iterator.remove();
            }
            catch (UnsupportedOperationException ex) {
                break;
            }
            hasRemoved = true;
        }
        return hasRemoved;
    }

    public static <K, V> boolean removeIf(@Nullable Map<K, V> map, @NonNull Predicate2<K, V> predicate) {
        Preconditions.checkNotNull(predicate);
        boolean hasRemoved = false;
        if (Emptys.isNotEmpty(map)) {
            Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<K, V> e = iterator.next();
                if (!predicate.test(e.getKey(), e.getValue())) continue;
                iterator.remove();
                hasRemoved = true;
            }
        }
        return hasRemoved;
    }

    public static boolean anyMatch(@NonNull Predicate predicate, Object ... array) {
        return Collects.anyMatch(Collects.asList(array), predicate);
    }

    public static <E, C extends Collection<E>> boolean anyMatch(@Nullable C collection, @NonNull Predicate<E> predicate) {
        Preconditions.checkNotNull(predicate);
        if (Emptys.isNotEmpty(collection)) {
            final Holder<Boolean> found = new Holder<Boolean>(false);
            Collects.forEach(collection, predicate, new Consumer<E>(){

                @Override
                public void accept(E e) {
                    found.set(true);
                }
            }, new Predicate<E>(){

                @Override
                public boolean test(E value) {
                    return (Boolean)found.get();
                }
            });
            return found.get();
        }
        return false;
    }

    public static <K, V, M extends Map<? extends K, ? extends V>> boolean anyMatch(@Nullable M map, @NonNull Predicate2<K, V> predicate) {
        Preconditions.checkNotNull(predicate);
        if (Emptys.isNotEmpty(map)) {
            Map.Entry<K, V> entry = Collects.findFirst(map, predicate);
            return entry != null;
        }
        return false;
    }

    public static boolean allMatch(@NonNull Predicate predicate, Object ... collection) {
        return Collects.allMatch(Collects.asList(collection), predicate);
    }

    public static <E, C extends Collection<E>> boolean allMatch(@Nullable C collection, @NonNull Predicate<E> predicate) {
        Preconditions.checkNotNull(predicate);
        if (Emptys.isNotEmpty(collection)) {
            for (E e : collection) {
                if (predicate.test(e)) continue;
                return false;
            }
        }
        return true;
    }

    public static <K, V, M extends Map<? extends K, ? extends V>> boolean allMatch(@Nullable M map, @NonNull Predicate2<K, V> predicate) {
        Preconditions.checkNotNull(predicate);
        if (Emptys.isNotEmpty(map)) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                if (predicate.test(e.getKey(), e.getValue())) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean noneMatch(@NonNull Predicate predicate, Object ... collection) {
        return Collects.noneMatch(Collects.asList(collection), predicate);
    }

    public static <E, C extends Collection<E>> boolean noneMatch(@Nullable C collection, @NonNull Predicate<E> predicate) {
        Preconditions.checkNotNull(predicate);
        if (Emptys.isNotEmpty(collection)) {
            for (E e : collection) {
                if (!predicate.test(e)) continue;
                return false;
            }
        }
        return true;
    }

    public static <K, V, M extends Map<? extends K, ? extends V>> boolean noneMatch(@Nullable M map, @NonNull Predicate2<K, V> predicate) {
        Preconditions.checkNotNull(predicate);
        if (Emptys.isNotEmpty(map)) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                if (!predicate.test(e.getKey(), e.getValue())) continue;
                return false;
            }
        }
        return true;
    }

    public static <E, C extends Collection<E>> Set<E> distinct(@Nullable C collection) {
        return new LinkedHashSet(Emptys.isEmpty(collection) ? Collections.EMPTY_LIST : collection);
    }

    public static <E> E[] limit(E[] array, int maxSize) {
        return Collects.toArray(Collects.limit(Collects.asList(array), maxSize));
    }

    public static <E, C extends Collection<E>> List<E> limit(@Nullable C collection, int maxSize) {
        List list;
        if (Emptys.isEmpty(collection)) {
            return Collects.emptyArrayList();
        }
        Preconditions.checkTrue(maxSize >= 0);
        List list2 = list = collection instanceof List ? (List)collection : new LinkedList(collection);
        if (list.size() <= maxSize) {
            return list;
        }
        return list.subList(0, maxSize);
    }

    public static <E> E[] skip(@Nullable E[] array, int n) {
        return Collects.toArray(Collects.skip(Collects.asList(array), n));
    }

    public static <E, C extends Collection<E>> List<E> skip(@Nullable C collection, int n) {
        List list;
        if (Emptys.isEmpty(collection)) {
            return Collects.emptyArrayList();
        }
        Preconditions.checkTrue(n >= 0);
        List list2 = list = collection instanceof List ? (List)collection : new LinkedList(collection);
        if (list.size() <= n) {
            return Collects.emptyArrayList();
        }
        return list.subList(n, list.size());
    }

    public static <E, K> List<List<E>> partitionBy(Iterator<E> c, Function<E, K> classifier) {
        return Collects.asList(Collects.collect(c, Collects.partitioningBy(classifier)).values());
    }

    public static <E, K> List<List<E>> partitionBy(Iterator<E> c, Function2<Integer, E, K> classifier) {
        return Collects.asList(Collects.collect(c, Collects.partitioningBy(classifier)).values());
    }

    public static <E, K> List<List<E>> partitionBy(E[] c, Function<E, K> classifier) {
        return Collects.asList(Collects.collect(c, Collects.partitioningBy(classifier)).values());
    }

    public static <E, K> List<List<E>> partitionBy(E[] c, Function2<Integer, E, K> classifier) {
        return Collects.asList(Collects.collect(c, Collects.partitioningBy(classifier)).values());
    }

    public static <E, K> List<List<E>> partitionBy(Iterable<E> c, Function<E, K> classifier) {
        return Collects.asList(Collects.collect(c, Collects.partitioningBy(classifier)).values());
    }

    public static <E, K> List<List<E>> partitionBy(Iterable<E> c, Function2<Integer, E, K> classifier) {
        return Collects.asList(Collects.collect(c, Collects.partitioningBy(classifier)).values());
    }

    public static <E> List<List<E>> partitionByCount(Iterable<E> c, final int partitionCount) {
        Preconditions.checkArgument(partitionCount > 0);
        return Collects.partitionBy(c, new Function2<Integer, E, Integer>(){

            @Override
            public Integer apply(Integer index, E element) {
                return index % partitionCount;
            }
        });
    }

    public static <E> List<List<E>> partitionBySize(Iterable<E> c, final int partitionSize) {
        Preconditions.checkArgument(partitionSize > 0);
        return Collects.partitionBy(c, new Function2<Integer, E, Integer>(){

            @Override
            public Integer apply(Integer index, E element) {
                return index / partitionSize;
            }
        });
    }

    public static <E extends Comparable<E>, C extends Collection<E>> List<E> sort(@Nullable C collection, boolean reverse) {
        return Collects.sort(collection, new ComparableComparator(), reverse);
    }

    public static <E, C extends Collection<E>> List<E> sort(@Nullable C collection, @NonNull Comparator<E> comparator) {
        return Collects.sort(collection, comparator, false);
    }

    public static <E, C extends Collection<E>> List<E> sort(@Nullable C collection, @NonNull Comparator<E> comparator, boolean reverse) {
        Preconditions.checkNotNull(comparator);
        if (Emptys.isEmpty(collection)) {
            return Collects.emptyArrayList();
        }
        comparator = comparator == null ? new ComparableComparator() : comparator;
        Comparator c = reverse ? Collections.reverseOrder(comparator) : comparator;
        Object[] a = Collects.toArray(collection);
        TimSort.sort(a, c);
        return Collects.asList(a);
    }

    public static <K, V, M extends Map<K, V>> M sort(@Nullable M map, @NonNull Comparator<K> comparator) {
        Preconditions.checkNotNull(comparator);
        TreeMap<K, V> result = Collects.emptyTreeMap(comparator);
        if (Emptys.isNotEmpty(map)) {
            result.putAll(map);
        }
        return (M)result;
    }

    public static <E> List<E> reverse(@Nullable List<E> list) {
        return Collects.reverse(list, false);
    }

    public static <E> List<E> reverse(@Nullable List<E> list, boolean newOne) {
        if (Emptys.isEmpty(list)) {
            return list == null || newOne ? Collects.emptyArrayList() : list;
        }
        if (!newOne) {
            Collections.reverse(list);
            return list;
        }
        ArrayList<E> newList = new ArrayList<E>();
        for (int i = list.size() - 1; i >= 0; --i) {
            newList.add(list.get(i));
        }
        return newList;
    }

    public static <K, V> int count(@Nullable Map<K, V> map) {
        return Emptys.isEmpty(map) ? 0 : map.size();
    }

    public static <E, C extends Collection<E>> int count(@Nullable C collection) {
        return Emptys.isEmpty(collection) ? 0 : collection.size();
    }

    public static int count(@Nullable Object anyObject) {
        final Holder<Integer> count = new Holder<Integer>(0);
        Collects.forEach(Collects.asCollection(Collects.asIterable(anyObject)), null, new Consumer<Object>(){

            @Override
            public void accept(Object object) {
                count.set((Integer)count.get() + 1);
            }
        }, null);
        return count.get();
    }

    public static <E> E max(@NonNull Object object, final @NonNull Comparator<E> comparator) {
        Preconditions.checkNotNull(comparator);
        Iterable<E> iterable = Collects.asIterable(object);
        return Collects.reduce(iterable, new Operator2<E>(){

            @Override
            public E apply(E input1, E input2) {
                return comparator.compare(input1, input2) >= 0 ? input1 : input2;
            }
        });
    }

    public static <E> E min(@Nullable Object object, final @NonNull Comparator<E> comparator) {
        Preconditions.checkNotNull(comparator);
        Iterable<E> iterable = Collects.asIterable(object);
        return Collects.reduce(iterable, new Operator2<E>(){

            @Override
            public E apply(E input1, E input2) {
                return comparator.compare(input1, input2) <= 0 ? input1 : input2;
            }
        });
    }

    public static <E, R> R collect(@Nullable Object anyObject, @NonNull Collector<E, R> collector) {
        Preconditions.checkNotNull(collector);
        return Collects.collect(anyObject, collector.supplier(), collector.accumulator());
    }

    public static <E, R> R collect(@Nullable Object anyObject, @NonNull Supplier0<R> containerFactory, final @NonNull Consumer2<R, E> consumer) {
        Preconditions.checkNotNull(containerFactory);
        Preconditions.checkNotNull(consumer);
        final R container = containerFactory.get();
        Collects.forEach(Collects.asCollection(Collects.asIterable(anyObject)), new Consumer<E>(){

            @Override
            public void accept(E e) {
                consumer.accept(container, e);
            }
        });
        return container;
    }

    public static <E> Collection<E> collect(@Nullable Object anyObject, final @NonNull Collection<E> container) {
        Preconditions.checkNotNull(container);
        Supplier0 containerFactory = new Supplier0<Collection<E>>(){

            @Override
            public Collection<E> get() {
                return container;
            }
        };
        Consumer2 consumer = new Consumer2<Collection<E>, E>(){

            @Override
            public void accept(Collection<E> list, E value) {
                list.add(value);
            }
        };
        return (Collection)Collects.collect(anyObject, containerFactory, consumer);
    }

    public static <X, Y, E, C extends Collection<E>> CollectionDiffResult<E> diff(@Nullable X oldObject, @NonNull Function<X, E> oldMapper, @Nullable Y newObject, @NonNull Function<Y, E> newMapper) {
        return Collects.diff(oldObject, oldMapper, newObject, newMapper, null);
    }

    public static <X, Y, E, C extends Collection<E>> CollectionDiffResult<E> diff(@Nullable X oldObject, @NonNull Function<X, E> oldMapper, @Nullable Y newObject, @NonNull Function<Y, E> newMapper, @Nullable Comparator<E> elementComparator) {
        return Collects.diff(oldObject, oldMapper, newObject, newMapper, elementComparator, null);
    }

    public static <X, Y, E, C extends Collection<E>> CollectionDiffResult<E> diff(@Nullable X oldObject, @NonNull Function<X, E> oldMapper, @Nullable Y newObject, @NonNull Function<Y, E> newMapper, @Nullable Comparator<E> elementComparator, @Nullable KeyBuilder<String, E> keyBuilder) {
        Collection<E> oldCollection = Collects.map(oldObject, oldMapper);
        Collection<E> newCollection = Collects.map(oldObject, oldMapper);
        return Collects.diff(oldCollection, newCollection, elementComparator, keyBuilder);
    }

    public static <E, C extends Collection<E>> CollectionDiffResult<E> diff(@Nullable C oldCollection, @Nullable C newCollection) {
        return Collects.diff(oldCollection, newCollection, null);
    }

    public static <E, C extends Collection<E>> CollectionDiffResult<E> diff(@Nullable C oldCollection, @Nullable C newCollection, @Nullable Comparator<E> elementComparator) {
        return Collects.diff(oldCollection, newCollection, elementComparator, null);
    }

    public static <E, C extends Collection<E>> CollectionDiffResult<E> diff(@Nullable C oldCollection, @Nullable C newCollection, @Nullable Comparator<E> elementComparator, @Nullable KeyBuilder<String, E> keyBuilder) {
        CollectionDiffer<E> differ = new CollectionDiffer<E>();
        differ.setComparator(elementComparator);
        if (keyBuilder != null) {
            differ.diffUsingMap(keyBuilder);
        }
        return differ.diff(oldCollection, newCollection);
    }

    public static <K, V, M extends Map<K, V>> MapDiffResult<K, V> diff(@Nullable M oldMap, @Nullable M newMap) {
        return Collects.diff(oldMap, newMap, null);
    }

    public static <K, V, M extends Map<K, V>> MapDiffResult<K, V> diff(@Nullable M oldMap, @Nullable M newMap, @Nullable Comparator<V> valueComparator) {
        return Collects.diff(oldMap, newMap, valueComparator, null);
    }

    public static <K, V, M extends Map<K, V>> MapDiffResult<K, V> diff(@Nullable M oldMap, @Nullable M newMap, @Nullable Comparator<V> valueComparator, @Nullable Comparator<K> keyComparator) {
        MapDiffer<K, V> differ = new MapDiffer<K, V>();
        differ.setValueComparator(valueComparator);
        differ.setKeyComparator(keyComparator);
        return differ.diff(oldMap, newMap);
    }

    public static Map<String, String> propertiesToStringMap(@Nullable Properties properties) {
        return Collects.propertiesToStringMap(properties, false);
    }

    public static Map<String, String> propertiesToStringMap(@Nullable Properties properties, boolean sort) {
        return Collects.propertiesToStringMap(properties, Comparators.STRING_COMPARATOR_IGNORE_CASE);
    }

    public static Map<String, String> propertiesToStringMap(@Nullable Properties properties, @Nullable Comparator<String> keyComparator) {
        TreeMap<String, String> map;
        AbstractMap abstractMap = map = keyComparator != null ? new TreeMap(keyComparator) : new StringMap();
        if (Emptys.isNotEmpty(properties)) {
            Collects.forEach(properties, new Consumer2<Object, Object>(){

                @Override
                public void accept(Object key, Object value) {
                    map.put(key.toString(), value.toString());
                }
            });
        }
        return map;
    }

    public static <E, C extends Collection<E>> void addAll(final @NonNull C dest, @Nullable Iterable<E> iterable) {
        Preconditions.checkNotNull(dest);
        if (Emptys.isNotEmpty(iterable)) {
            Collects.forEach(iterable, new Consumer<E>(){

                @Override
                public void accept(E e) {
                    dest.add(e);
                }
            });
        }
    }

    public static <E, C extends Collection<E>> void addAll(@NonNull C dest, E ... iterator) {
        Collects.addAll(dest, Collects.asIterable(iterator));
    }

    public static <E, C extends Collection<E>> void addAll(@NonNull C dest, @Nullable Iterator<E> iterator) {
        Collects.addAll(dest, Collects.asIterable(iterator));
    }

    public static <E, C extends Collection<E>> void addTo(@NonNull C srcCollection, @Nullable C targetCollection) {
        Collects.addAll(targetCollection, srcCollection);
    }

    public static <E1, C1 extends Collection<E1>, E2, C2 extends Collection<E2>> void addTo(C1 srcCollection, C2 targetCollection, Function<E1, E2> mapper) {
        Collection<E2> mapped = Collects.map(srcCollection, mapper);
        Collects.addTo(mapped, targetCollection);
    }

    public static <E, C extends Collection<E>> C concat(@Nullable C c1, @Nullable C c2) {
        return Collects.concat(c1, c2, true);
    }

    public static <E, C extends Collection<E>> C concat(@Nullable C c1, @Nullable C c2, boolean newOne) {
        if (newOne) {
            List<E> l = Collects.emptyArrayList();
            if (Emptys.isNotEmpty(c1)) {
                l.addAll(c1);
            }
            if (Emptys.isNotEmpty(c2)) {
                l.addAll(c2);
            }
            return (C)l;
        }
        Preconditions.checkNotNull(c1);
        if (Emptys.isNotEmpty(c2)) {
            c1.addAll(c2);
        }
        return c1;
    }

    public static <K, V> Map<K, V> copy(Map<K, V> source) {
        if (source == null) {
            return null;
        }
        HashMap<K, V> result = new HashMap<K, V>();
        result.putAll(source);
        return result;
    }

    public static <E, C extends Collection<E>> C merge(@Nullable C c1, @Nullable C c2) {
        return Collects.merge(c1, c2, true);
    }

    public static <E, C extends Collection<E>> C merge(final @Nullable C c1, @Nullable C c2, boolean newOne) {
        if (newOne) {
            HashSet<E> set = Collects.emptyHashSet(true);
            if (Emptys.isNotEmpty(c1)) {
                set.addAll(c1);
            }
            if (Emptys.isNotEmpty(c2)) {
                set.addAll(c2);
            }
            return (C)set;
        }
        Preconditions.checkNotNull(c1);
        if (Emptys.isNotEmpty(c2)) {
            HashSet<E> set = Collects.emptyHashSet(true);
            set.addAll(c2);
            Collects.forEach(c2, new Consumer<E>(){

                @Override
                public void accept(E e) {
                    if (!c1.contains(e)) {
                        c1.add(e);
                    }
                }
            });
        }
        return c1;
    }

    public static <K, V, M extends Map<K, V>> M merge(@Nullable M map1, @Nullable M map2) {
        return Collects.merge(map1, map2, true);
    }

    public static <K, V, M extends Map<K, V>> M merge(@Nullable M map1, @Nullable M map2, boolean newOne) {
        if (newOne) {
            HashMap<K, V> map = Collects.emptyHashMap();
            if (Emptys.isNotEmpty(map1)) {
                map.putAll(map1);
            }
            if (Emptys.isNotEmpty(map2)) {
                map.putAll(map2);
            }
            return (M)map;
        }
        Preconditions.checkNotNull(map1);
        if (Emptys.isNotEmpty(map2)) {
            map1.putAll(map2);
        }
        return map1;
    }

    public static <E, C1 extends Collection<E>, C2 extends Collection<E>> boolean containsAny(final C1 c1, C2 c2) {
        if (Emptys.isEmpty(c1)) {
            return false;
        }
        return Collects.anyMatch(c2, new Predicate<E>(){

            @Override
            public boolean test(E value) {
                return c1.contains(value);
            }
        });
    }

    public static <E> boolean contains(E[] collection, E obj) {
        return Collects.contains(collection, obj, null);
    }

    public static <E> boolean contains(Collection<E> collection, E obj) {
        return Collects.contains(collection, obj, null);
    }

    public static <E> boolean contains(E[] collection, @Nullable E obj, @Nullable Predicate<E> predicate) {
        return Collects.contains(Collects.asCollection(Collects.asIterable(collection)), obj, predicate);
    }

    public static <E> boolean contains(Collection<E> collection, @Nullable E obj, @Nullable Predicate<E> predicate) {
        Predicate<E> p = predicate == null ? Functions.equalsPredicate(obj) : predicate;
        return Collects.anyMatch(collection, p);
    }

    public static <E, C1 extends Collection<E>, C2 extends Collection<E>> boolean containsAll(final C1 c1, C2 c2) {
        if (Emptys.isEmpty(c1)) {
            return false;
        }
        return Collects.allMatch(c2, new Predicate<E>(){

            @Override
            public boolean test(E value) {
                return c1.contains(value);
            }
        });
    }

    public static <E, C1 extends Collection<E>, C2 extends Collection<E>> boolean containsNone(final C1 c1, C2 c2) {
        if (Emptys.isEmpty(c1)) {
            return true;
        }
        return Collects.noneMatch(c2, new Predicate<E>(){

            @Override
            public boolean test(E value) {
                return c1.contains(value);
            }
        });
    }

    public static <E, C1 extends Collection<E>, C2 extends Collection<E>> Set<E> intersection(final C1 c1, final C2 c2) {
        final HashSet<E> set = Collects.emptyHashSet(true);
        if (Emptys.isEmpty(c1) || Emptys.isEmpty(c2)) {
            return set;
        }
        List<E> allElements = Collects.emptyArrayList();
        allElements.addAll(c1);
        allElements.addAll(c2);
        Collects.forEach(allElements, new Predicate<E>(){

            @Override
            public boolean test(E element) {
                return set.contains(element) || c1.contains(element) && c2.contains(element);
            }
        }, new Consumer<E>(){

            @Override
            public void accept(E e) {
                set.add(e);
            }
        }, null);
        return set;
    }

    public static <E, C1 extends Collection<E>, C2 extends Collection<E>> Set<E> union(C1 c1, C2 c2) {
        HashSet<E> allElements = Collects.emptyHashSet(true);
        allElements.addAll(Emptys.isEmpty(c1) ? Collects.emptyArrayList() : c1);
        allElements.addAll(Emptys.isEmpty(c2) ? Collects.emptyArrayList() : c2);
        return allElements;
    }

    public static <E> E reduce(@Nullable E[] iterable, Operator2<E> operator) {
        return Collects.reduce(Collects.asIterable(iterable), operator);
    }

    public static <E, C extends Iterable<E>> E reduce(@Nullable Iterable<E> iterable, Operator2<E> operator) {
        if (Emptys.isEmpty(iterable)) {
            return null;
        }
        Preconditions.checkNotNull(operator);
        List<E> list = Collects.asList(iterable);
        Object result = list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            result = operator.apply(result, list.get(i));
        }
        return result;
    }

    public static <K, E> Map<K, List<E>> groupBy(@Nullable E[] iterable, @NonNull Function<E, K> classifier) {
        return Collects.groupBy(Collects.asIterable(iterable), classifier, null);
    }

    public static <K, E> Map<K, List<E>> groupBy(@Nullable E[] iterable, @NonNull Function<E, K> classifier, @Nullable Supplier0<Map<K, List<E>>> mapFactory) {
        return Collects.groupBy(Collects.asIterable(iterable), classifier, mapFactory);
    }

    public static <K, E, C extends Collection<E>> Map<K, List<E>> groupBy(@Nullable C iterable, @NonNull Function<E, K> classifier) {
        return Collects.groupBy(iterable, classifier, null);
    }

    public static <K, E, C extends Collection<E>> Map<K, List<E>> groupBy(@Nullable Iterable<E> iterable, final @NonNull Function<E, K> classifier, @Nullable Supplier0<Map<K, List<E>>> mapFactory) {
        Preconditions.checkNotNull(classifier);
        iterable = Collects.asIterable(iterable);
        if (mapFactory == null) {
            mapFactory = new Supplier0<Map<K, List<E>>>(){

                @Override
                public Map<K, List<E>> get() {
                    return new HashMap();
                }
            };
        }
        Map<K, List<E>> map = mapFactory.get();
        Preconditions.checkNotNull(map);
        final WrappedNonAbsentMap<K, List<E>> wrappedNonAbsentMap = WrappedNonAbsentMap.wrap(map, new Supplier<K, List<E>>(){

            @Override
            public List<E> get(K key) {
                return new ArrayList();
            }
        });
        Collects.forEach(Collects.asCollection(Collects.asIterable(iterable)), new Consumer<E>(){

            @Override
            public void accept(E e) {
                Object group = classifier.apply(e);
                ((List)wrappedNonAbsentMap.get(group)).add(e);
            }
        });
        return map;
    }

    public static <E> Collector<E, TreeSet<E>> toTreeSet(final @Nullable Comparator<E> comparator) {
        return new Collector<E, TreeSet<E>>(){

            @Override
            public Supplier0<TreeSet<E>> supplier() {
                return Functions.emptyTreeSetSupplier0(comparator);
            }

            @Override
            public Consumer2<TreeSet<E>, E> accumulator() {
                return new Consumer2<TreeSet<E>, E>(){

                    @Override
                    public void accept(TreeSet<E> set, E value) {
                        set.add(value);
                    }
                };
            }
        };
    }

    public static <E> Collector<E, HashSet<E>> toHashSet(boolean sequential) {
        return new Collector<E, HashSet<E>>(){

            @Override
            public Supplier0<HashSet<E>> supplier() {
                return Functions.emptyHashSetSupplier0();
            }

            @Override
            public Consumer2<HashSet<E>, E> accumulator() {
                return new Consumer2<HashSet<E>, E>(){

                    @Override
                    public void accept(HashSet<E> set, E value) {
                        set.add(value);
                    }
                };
            }
        };
    }

    public static <E> Collector<E, List<E>> toList() {
        return new Collector<E, List<E>>(){

            @Override
            public Supplier0<List<E>> supplier() {
                return new Supplier0<List<E>>(){

                    @Override
                    public List<E> get() {
                        return Collects.emptyArrayList();
                    }
                };
            }

            @Override
            public Consumer2<List<E>, E> accumulator() {
                return new Consumer2<List<E>, E>(){

                    @Override
                    public void accept(List<E> list, E value) {
                        list.add(value);
                    }
                };
            }
        };
    }

    public static <E, K, V> Collector<E, Map<K, V>> toHashMap(@NonNull Function<E, K> keyMapper, @NonNull Function<E, V> valueMapper, final boolean sequential) {
        Preconditions.checkNotNull(keyMapper);
        Preconditions.checkNotNull(valueMapper);
        return Collects.toMap(new Supplier0<Map<K, V>>(){

            @Override
            public Map<K, V> get() {
                return Collects.emptyHashMap(sequential);
            }
        }, keyMapper, valueMapper);
    }

    public static <E, K, V> Collector<E, Map<K, V>> toTreeMap(@NonNull Function<E, K> keyMapper, @NonNull Function<E, V> valueMapper, final @Nullable Comparator<K> comparator) {
        Preconditions.checkNotNull(keyMapper);
        Preconditions.checkNotNull(valueMapper);
        return Collects.toMap(new Supplier0<Map<K, V>>(){

            @Override
            public Map<K, V> get() {
                return Collects.emptyTreeMap(comparator);
            }
        }, keyMapper, valueMapper);
    }

    public static <E, K, V> Collector<E, Map<K, V>> toMap(final @NonNull Supplier0<Map<K, V>> mapFactory, final @NonNull Function<E, K> keyMapper, final @NonNull Function<E, V> valueMapper) {
        Preconditions.checkNotNull(keyMapper);
        Preconditions.checkNotNull(valueMapper);
        return new Collector<E, Map<K, V>>(){

            @Override
            public Supplier0<Map<K, V>> supplier() {
                return mapFactory;
            }

            @Override
            public Consumer2<Map<K, V>, E> accumulator() {
                return new Consumer2<Map<K, V>, E>(){

                    @Override
                    public void accept(Map<K, V> map, E e) {
                        Object key = keyMapper.apply(e);
                        Object value = valueMapper.apply(e);
                        map.put(key, value);
                    }
                };
            }
        };
    }

    public static <E, K> Collector<E, Map<K, List<E>>> groupingBy(final @NonNull Function<E, K> classifier, final @NonNull Supplier0<Map<K, List<E>>> mapFactory) {
        Preconditions.checkNotNull(classifier);
        Preconditions.checkNotNull(mapFactory);
        return new Collector<E, Map<K, List<E>>>(){

            @Override
            public Supplier0<Map<K, List<E>>> supplier() {
                return mapFactory;
            }

            @Override
            public Consumer2<Map<K, List<E>>, E> accumulator() {
                return new Consumer2<Map<K, List<E>>, E>(){

                    @Override
                    public void accept(Map<K, List<E>> map, E e) {
                        Object group = classifier.apply(e);
                        List list = map.get(group);
                        if (list == null) {
                            list = new ArrayList();
                            map.put(group, list);
                        }
                        list.add(e);
                    }
                };
            }
        };
    }

    public static <E, K> Collector<E, Map<K, List<E>>> groupingBy(final @NonNull Function2<Integer, E, K> classifier, final @NonNull Supplier0<Map<K, List<E>>> mapFactory) {
        Preconditions.checkNotNull(classifier);
        Preconditions.checkNotNull(mapFactory);
        return new Collector<E, Map<K, List<E>>>(){

            @Override
            public Supplier0<Map<K, List<E>>> supplier() {
                return mapFactory;
            }

            @Override
            public Consumer2<Map<K, List<E>>, E> accumulator() {
                return new Consumer2<Map<K, List<E>>, E>(){
                    private int index = 0;

                    @Override
                    public void accept(Map<K, List<E>> map, E e) {
                        Object group = classifier.apply(this.index, e);
                        List list = map.get(group);
                        if (list == null) {
                            list = new ArrayList();
                            map.put(group, list);
                        }
                        list.add(e);
                        ++this.index;
                    }
                };
            }
        };
    }

    public static <E, K> Collector<E, Map<K, List<E>>> partitioningBy(@NonNull Function<E, K> classifier) {
        return Collects.groupingBy(classifier, new Supplier0<Map<K, List<E>>>(){

            @Override
            public Map<K, List<E>> get() {
                return new NonAbsentTreeMap(new Supplier<K, List<E>>(){

                    @Override
                    public List<E> get(K input) {
                        return new ArrayList();
                    }
                });
            }
        });
    }

    public static <E, K> Collector<E, Map<K, List<E>>> partitioningBy(@NonNull Function2<Integer, E, K> classifier) {
        return Collects.groupingBy(classifier, new Supplier0<Map<K, List<E>>>(){

            @Override
            public Map<K, List<E>> get() {
                return new NonAbsentTreeMap(new Supplier<K, List<E>>(){

                    @Override
                    public List<E> get(K input) {
                        return new ArrayList();
                    }
                });
            }
        });
    }

    public static <E, C extends Collection<E>> C clearNulls(@Nullable C collection) {
        return (C)Collects.filter(collection, Functions.nonNullPredicate());
    }

    public static <E, C extends Collection<E>> C clearEmptys(@Nullable C collection) {
        return (C)Collects.filter(collection, Functions.notEmptyPredicate());
    }

    public static <E> void shuffle(@NonNull List<E> list) {
        Collects.shuffle(list, GlobalThreadLocalMap.getRandom());
    }

    public static <E> void shuffle(@NonNull List<E> list, @NonNull IRandom rnd) {
        int size = list.size();
        if (size < 5 || list instanceof RandomAccess) {
            for (int i = size; i > 1; --i) {
                Collects.swap(list, i - 1, rnd.nextInt(i));
            }
        } else {
            Object[] arr = list.toArray();
            for (int i = size; i > 1; --i) {
                Collects.swap(arr, i - 1, rnd.nextInt(i));
            }
            ListIterator<Object> it = list.listIterator();
            for (int i = 0; i < arr.length; ++i) {
                it.next();
                it.set(arr[i]);
            }
        }
    }

    public static <E> void swap(@NonNull List<E> list, int i, int j) {
        Preconditions.checkArgument(i > 0, StringTemplates.indexStyleSupplier("index i is illegal : {}"), i);
        Preconditions.checkArgument(j > 0, StringTemplates.indexStyleSupplier("index j is illegal : {}"), j);
        List<E> l = list;
        l.set(i, l.set(j, l.get(i)));
    }

    public static <E> void swap(@NonNull E[] arr, int i, int j) {
        Arrs.swap(arr, i, j);
    }

    public static <E> int indexOf(List<E> list, E e) {
        return Collects.indexOf(list, e, 0);
    }

    public static <E> int indexOf(List<E> list, E e, int startIndex) {
        return Collects.indexOf(list, e, startIndex, Emptys.isEmpty(list) ? 0 : list.size());
    }

    public static <E> int indexOf(List<E> list, E e, int startIndex, int endIndex) {
        if (list == null || list.isEmpty()) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (startIndex >= list.size()) {
            return -1;
        }
        if (endIndex <= 0) {
            return -1;
        }
        if (endIndex > list.size()) {
            endIndex = list.size();
        }
        if (startIndex >= endIndex) {
            return -1;
        }
        ArrayList<E> arrayList = list instanceof ArrayList ? (ArrayList<E>)list : Collects.newArrayList(list);
        for (int i = startIndex; i < endIndex; ++i) {
            if (!Objs.equals(arrayList.get(i), e)) continue;
            return i;
        }
        return -1;
    }

    public static <E> int lastIndexOf(List<E> list, E e) {
        return Collects.lastIndexOf(list, e, 0);
    }

    public static <E> int lastIndexOf(List<E> list, E e, int startIndex) {
        return Collects.lastIndexOf(list, e, startIndex, Emptys.isEmpty(list) ? 0 : list.size());
    }

    public static <E> int lastIndexOf(List<E> list, E e, int startIndex, int endIndex) {
        if (list == null || list.isEmpty()) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (startIndex >= list.size()) {
            return -1;
        }
        if (endIndex <= 0) {
            return -1;
        }
        if (endIndex > list.size()) {
            endIndex = list.size();
        }
        if (startIndex >= endIndex) {
            return -1;
        }
        ArrayList<E> arrayList = list instanceof ArrayList ? (ArrayList<E>)list : Collects.newArrayList(list);
        for (int i = endIndex - 1; i >= startIndex; --i) {
            if (!Objs.equals(arrayList.get(i), e)) continue;
            return i;
        }
        return -1;
    }

    public static <E> int indexOf(E[] list, E e) {
        return Collects.indexOf(Collects.asList(list), e);
    }

    public static <E> int indexOf(E[] list, E e, int startIndex) {
        return Collects.indexOf(Collects.asList(list), e, startIndex);
    }

    public static <E> int indexOf(E[] list, E e, int startIndex, int endIndex) {
        return Collects.indexOf(Collects.asList(list), e, startIndex, endIndex);
    }

    public static <E> int lastIndexOf(E[] list, E e) {
        return Collects.lastIndexOf(Collects.asList(list), e);
    }

    public static <E> int lastIndexOf(E[] list, E e, int startIndex) {
        return Collects.lastIndexOf(Collects.asList(list), e, startIndex);
    }

    public static <E> int lastIndexOf(E[] list, E e, int startIndex, int endIndex) {
        return Collects.lastIndexOf(Collects.asList(list), e, startIndex, endIndex);
    }

    public static <E> E apply(E input, Function<E, E> ... mappers) {
        for (int i = 0; i < mappers.length; ++i) {
            input = mappers[i].apply(input);
        }
        return input;
    }

    public static <E> boolean isFirst(@Nullable E obj, @Nullable List<E> list) {
        if (Objs.isEmpty(list)) {
            return false;
        }
        return Objs.equals(new ListSequence<E>(list).first(), obj);
    }

    public static <E> boolean isLast(@Nullable E obj, @Nullable List<E> list) {
        if (Objs.isEmpty(list)) {
            return false;
        }
        return Objs.equals(new ListSequence<E>(list).last(), obj);
    }

    public static <E> boolean isFirst(@Nullable E obj, @Nullable Iterable<E> list) {
        if (Objs.isEmpty(list)) {
            return false;
        }
        return Objs.equals(new IterableSequence<E>(list).first(), obj);
    }

    public static <E> boolean isLast(@Nullable E obj, @Nullable Iterable<E> list) {
        if (Objs.isEmpty(list)) {
            return false;
        }
        return Objs.equals(new IterableSequence<E>(list).last(), obj);
    }

    public static <E> boolean isFirst(@Nullable E obj, @Nullable SortedSet<E> set) {
        if (Objs.isEmpty(set)) {
            return false;
        }
        return Objs.equals(new SortedSetSequence<E>(set).first(), obj);
    }

    public static <E> boolean isLast(@Nullable E obj, @Nullable SortedSet<E> set) {
        if (Objs.isEmpty(set)) {
            return false;
        }
        return Objs.equals(new SortedSetSequence<E>(set).last(), obj);
    }

    public static enum ListType {
        ArrayList,
        LinkedList,
        CopyOnWrite,
        VECTOR,
        STACK;


        public static ListType ofList(@Nullable List list) {
            if (list == null) {
                return ArrayList;
            }
            return Collects.inferListType(list);
        }
    }

    public static enum SetType {
        HashSet,
        LinkedHashSet,
        TreeSet,
        NonDistinctTreeSet;


        public static SetType ofSet(@Nullable Set set) {
            if (set == null) {
                return HashSet;
            }
            return Collects.inferSetType(set);
        }
    }

    public static enum MapType {
        StringMap,
        HashMap,
        TreeMap,
        LinkedHashMap,
        IdentityHashMap,
        Hashtable,
        Properties;


        public static MapType ofMap(@Nullable Map map) {
            if (map == null) {
                return HashMap;
            }
            if (map instanceof StringMap) {
                return StringMap;
            }
            if (map instanceof Properties) {
                return Properties;
            }
            if (map instanceof Hashtable) {
                return Hashtable;
            }
            if (map instanceof IdentityHashMap) {
                return IdentityHashMap;
            }
            if (map instanceof LinkedHashMap) {
                return LinkedHashMap;
            }
            if (map instanceof TreeMap) {
                return TreeMap;
            }
            return HashMap;
        }
    }

    private static class ImmutableEmptyEnumeration<E>
    implements Enumeration<E> {
        static final ImmutableEmptyEnumeration<Object> EMPTY_ENUMERATION = new ImmutableEmptyEnumeration();

        private ImmutableEmptyEnumeration() {
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public E nextElement() {
            throw new NoSuchElementException();
        }
    }
}

