/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.collection;

import com.jn.langx.util.collection.Collects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class Lists {
    private Lists() {
    }

    public static <E> ArrayList<E> newArrayList() {
        return Collects.newArrayList();
    }

    public static <E> ArrayList<E> newArrayList(E ... elements) {
        return Collects.newArrayList(elements);
    }

    public static <E> ArrayList<E> newArrayList(Iterable<E> elements) {
        return Collects.newArrayList(elements);
    }

    public static <E> ArrayList<E> newArrayList(Iterator<E> elements) {
        return Collects.newArrayList(elements);
    }

    public static <E> ArrayList<E> newArrayListWithCapacity(int initialArraySize) {
        return Collects.newArrayListWithCapacity(initialArraySize);
    }

    public static <E> ArrayList<E> newArrayListWithExpectedSize(int estimatedSize) {
        return Collects.newArrayListWithExpectedSize(estimatedSize);
    }

    public static <E> LinkedList<E> newLinkedList() {
        return Collects.newLinkedList();
    }

    public static <E> LinkedList<E> newLinkedList(Iterable<E> elements) {
        return Collects.newLinkedList(elements);
    }

    public static <E> CopyOnWriteArrayList<E> newCopyOnWriteArrayList() {
        return Collects.newCopyOnWriteArrayList();
    }

    public static <E> CopyOnWriteArrayList<E> newCopyOnWriteArrayList(Iterable<E> elements) {
        return Collects.newCopyOnWriteArrayList(elements);
    }

    public static <E> List<E> asList(E first, E[] rest) {
        ArrayList<E> list = new ArrayList<E>();
        list.add(first);
        Collects.addAll(list, rest);
        return list;
    }

    public static <E> List<E> asList(E first, E second, E[] rest) {
        ArrayList<E> list = new ArrayList<E>();
        list.add(first);
        list.add(second);
        Collects.addAll(list, rest);
        return list;
    }

    public static <E> List<E> immutableList() {
        return Collects.immutableList();
    }

    public static <E> List<E> immutableList(Collection<E> elements) {
        return Collects.immutableList(elements);
    }

    public static <E> List<E> immutableList(E ... elements) {
        return Collects.immutableList(elements);
    }
}

