/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.collection;

import com.jn.langx.util.Objs;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.iter.UnmodifiableIterator;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.function.Consumer2;
import com.jn.langx.util.function.Functions;
import com.jn.langx.util.hash.Hashs;
import com.jn.langx.util.io.bytes.Bytes;
import com.jn.langx.util.reflect.Reflects;
import com.jn.langx.util.reflect.type.Primitives;
import java.lang.reflect.Array;
import java.util.BitSet;
import java.util.Iterator;

public class OpenHashSet<T> {
    private static final int MAX_CAPACITY = 0x40000000;
    private static final int INVALID_POS = -1;
    private static final int NONEXISTENCE_MASK = Integer.MIN_VALUE;
    private static final int POSITION_MASK = Integer.MAX_VALUE;
    private int initialCapacity;
    private float loadFactor;
    private int capacity;
    private int mask;
    private int size;
    private int growThreshold;
    private BitSet bitset;
    private Class elementClass;
    private Hasher<T> hasher;
    private Object data;

    public OpenHashSet(int initialCapacity, float loadFactor, Class<T> elementClass) {
        Preconditions.checkArgument(initialCapacity <= 0x40000000, "Can't make capacity bigger than {} elements", 0x40000000);
        Preconditions.checkArgument(initialCapacity >= 0, "Invalid initial capacity");
        Preconditions.checkArgument((double)loadFactor < 1.0, "Load factor must be less than 1.0");
        Preconditions.checkArgument((double)loadFactor > 0.0, "Load factor must be greater than 0.0");
        this.initialCapacity = initialCapacity;
        this.loadFactor = loadFactor;
        Hasher<Long> hasher = null;
        this.elementClass = elementClass;
        if (Primitives.isLong(elementClass)) {
            hasher = new LongHasher();
        } else if (Primitives.isFloat(elementClass)) {
            hasher = new FloatHasher();
        } else if (Primitives.isInteger(elementClass)) {
            hasher = new IntHasher();
        } else if (Primitives.isDouble(elementClass)) {
            hasher = new DoubleHasher();
        } else {
            throw new IllegalArgumentException("illegal generic type argument: " + Reflects.getFQNClassName(this.elementClass));
        }
        this.hasher = hasher;
        this.capacity = this.nextPowerOf2(initialCapacity);
        this.mask = this.capacity - 1;
        this.size = 0;
        this.bitset = new BitSet(this.capacity);
        this.data = Array.newInstance(this.elementClass, this.capacity);
    }

    public BitSet getBitset() {
        return this.bitset;
    }

    public int getSize() {
        return this.size;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public boolean contains(T e) {
        return this.getPos(e) != -1;
    }

    public int getPos(T k) {
        int pos = this.hashcode(this.hasher.hash(k)) & this.mask;
        int delta = 1;
        while (this.bitset.get(pos)) {
            if (this.keyExistsAtPos(k, pos)) {
                return pos;
            }
            pos = pos + delta & this.mask;
            ++delta;
        }
        return -1;
    }

    private boolean keyExistsAtPos(T k, int pos) {
        return Objs.equals(Array.get(this.data, pos), k);
    }

    private int hashcode(int h) {
        return (int)Hashs.getHasher("murmur3_32", null).hash(Bytes.toBytes(h));
    }

    public void add(T k) {
        this.addWithoutResize(k);
        this.rehashIfNeeded(k, Functions.<Integer>noopConsumer(), Functions.<Integer, Integer>noopConsumer2());
    }

    public OpenHashSet<T> union(OpenHashSet<T> other) {
        Iterator<T> iter = other.iterator();
        while (iter.hasNext()) {
            this.add(iter.next());
        }
        return this;
    }

    public Iterator<T> iterator() {
        return new UnmodifiableIterator<T>(){
            int pos;
            {
                this.pos = OpenHashSet.this.nextPos(0);
            }

            @Override
            public boolean hasNext() {
                return this.pos != -1;
            }

            @Override
            public T next() {
                Object tmp = OpenHashSet.this.getValue(this.pos);
                this.pos = OpenHashSet.this.nextPos(this.pos + 1);
                return tmp;
            }
        };
    }

    public int nextPos(int fromPos) {
        return this.bitset.nextSetBit(fromPos);
    }

    public T getValue(int pos) {
        return (T)Array.get(this.data, pos);
    }

    public T getValueSafe(int pos) {
        assert (this.bitset.get(pos));
        return (T)Array.get(this.data, pos);
    }

    private int nextPowerOf2(int n) {
        if (n == 0) {
            return 1;
        }
        int highBit = Integer.highestOneBit(n);
        if (highBit == n) {
            return n;
        }
        return highBit << 1;
    }

    public int addWithoutResize(T k) {
        int pos = this.hashcode(this.hasher.hash(k)) & this.mask;
        int delta = 1;
        while (true) {
            if (!this.bitset.get(pos)) {
                Array.set(this.data, pos, k);
                this.bitset.set(pos);
                ++this.size;
                return pos | Integer.MIN_VALUE;
            }
            if (this.keyExistsAtPos(k, pos)) {
                return pos;
            }
            pos = pos + delta & this.mask;
            ++delta;
        }
    }

    public void rehashIfNeeded(T k, Consumer<Integer> allocateFunc, Consumer2<Integer, Integer> moveFunc) {
        if (this.size > this.growThreshold) {
            this.rehash(k, allocateFunc, moveFunc);
        }
    }

    private void rehash(T k, Consumer<Integer> allocateFunc, Consumer2<Integer, Integer> moveFunc) {
        int newCapacity = this.capacity * 2;
        Preconditions.checkArgument(newCapacity > 0 && newCapacity <= 0x40000000, "Can't contain more than ${(loadFactor * OpenHashSet.MAX_CAPACITY).toInt} elements");
        allocateFunc.accept(newCapacity);
        BitSet newBitset = new BitSet(newCapacity);
        Object newData = Array.newInstance(this.elementClass, newCapacity);
        int newMask = newCapacity - 1;
        for (int oldPos = 0; oldPos < this.capacity; ++oldPos) {
            if (!this.bitset.get(oldPos)) continue;
            T key = this.getValue(oldPos);
            int newPos = this.hashcode(this.hasher.hash(key)) & newMask;
            int i = 1;
            boolean keepGoing = true;
            while (keepGoing) {
                if (!newBitset.get(newPos)) {
                    Array.set(newData, newPos, key);
                    newBitset.set(newPos);
                    moveFunc.accept(oldPos, newPos);
                    keepGoing = false;
                    continue;
                }
                int delta = i++;
                newPos = newPos + delta & newMask;
            }
        }
        this.bitset = newBitset;
        this.data = newData;
        this.capacity = newCapacity;
        this.mask = newMask;
        this.growThreshold = (int)(this.loadFactor * (float)newCapacity);
    }

    public OpenHashSet(int initialCapacity, Class<T> elementClass) {
        this(initialCapacity, 0.7f, elementClass);
    }

    public OpenHashSet(Class<T> elementClass) {
        this(64, elementClass);
    }

    public static class DefaultHasher<T>
    implements Hasher<T> {
        @Override
        public int hash(T o) {
            return o.hashCode();
        }
    }

    public static class LongHasher
    implements Hasher<Long> {
        @Override
        public int hash(Long o) {
            return (int)(o ^ o >>> 32);
        }
    }

    public static class DoubleHasher
    implements Hasher<Double> {
        @Override
        public int hash(Double o) {
            long bits = Double.doubleToLongBits(o);
            return (int)(bits ^ bits >>> 32);
        }
    }

    public static class FloatHasher
    implements Hasher<Float> {
        @Override
        public int hash(Float o) {
            return Float.floatToIntBits(o.floatValue());
        }
    }

    public static class IntHasher
    implements Hasher<Integer> {
        @Override
        public int hash(Integer o) {
            return o;
        }
    }

    public static interface Hasher<T> {
        public int hash(T var1);
    }
}

