/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.collection;

import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer2;
import java.util.HashMap;
import java.util.Map;

public class PrefixHashMap<V>
extends HashMap<String, V>
implements Cloneable {
    private String prefix;
    private boolean readUsingPrefix;

    public PrefixHashMap(String prefix) {
        this(prefix, true);
    }

    public PrefixHashMap(String prefix, boolean readUsingPrefix) {
        Preconditions.checkNotNull(prefix);
        this.prefix = prefix;
        this.readUsingPrefix = readUsingPrefix;
    }

    public PrefixHashMap(String prefix, Map<String, V> map) {
        this(prefix, true, map);
    }

    public PrefixHashMap(String prefix, boolean readUsingPrefix, Map<String, V> map) {
        this(prefix, readUsingPrefix);
        this.putAll(map);
    }

    private String getInnerKey(Object key) {
        if (this.readUsingPrefix) {
            return this.prefix + key;
        }
        String key0 = key.toString();
        if (key0.startsWith(this.prefix)) {
            if (key0.length() > this.prefix.length()) {
                return key0.substring(this.prefix.length());
            }
            return "";
        }
        return key0;
    }

    @Override
    public V put(String key, V value) {
        if (key == null) {
            return null;
        }
        return super.put(this.getInnerKey(key), value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> m) {
        Consumer2 consumer2 = new Consumer2<String, V>(){

            @Override
            public void accept(String key, V value) {
                PrefixHashMap.this.put(key, value);
            }
        };
        Collects.forEach(m, consumer2);
    }

    @Override
    public Object clone() {
        return new PrefixHashMap<V>(this.prefix, this.readUsingPrefix, this);
    }
}

