/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.collection;

import com.jn.langx.annotation.Nullable;
import com.jn.langx.util.Objs;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Arrs;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.sort.DualPivotQuicksort;
import com.jn.langx.util.function.Supplier;
import com.jn.langx.util.io.bytes.Bytes;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;

public class PrimitiveArrays {
    public static final Class BYTE_ARRAY_CLASS = byte[].class;
    public static final Class SHORT_ARRAY_CLASS = short[].class;
    public static final Class INT_ARRAY_CLASS = int[].class;
    public static final Class LONG_ARRAY_CLASS = long[].class;
    public static final Class FLOAT_ARRAY_CLASS = float[].class;
    public static final Class DOUBLE_ARRAY_CLASS = double[].class;
    public static final Class CHAR_ARRAY_CLASS = char[].class;
    public static final Class BOOLEAN_ARRAY_CLASS = boolean[].class;
    public static final int INDEX_NOT_FOUND = -1;
    protected static final List<Class> PRIMITIVE_ARRAY_CLASSES = Collects.asList(Collects.asList(BYTE_ARRAY_CLASS, SHORT_ARRAY_CLASS, INT_ARRAY_CLASS, LONG_ARRAY_CLASS, FLOAT_ARRAY_CLASS, DOUBLE_ARRAY_CLASS, CHAR_ARRAY_CLASS, BOOLEAN_ARRAY_CLASS), false);

    protected PrimitiveArrays() {
    }

    public static boolean isPrimitiveArray(Class clazz) {
        return clazz != null && PRIMITIVE_ARRAY_CLASSES.contains(clazz);
    }

    public static <E> E[] wrap(Object o) {
        Preconditions.checkArgument(Arrs.isArray(o));
        if (PrimitiveArrays.isPrimitiveArray(o.getClass())) {
            int length = Arrs.getLength(o);
            Class<?> componentType = o.getClass().getComponentType();
            ?[] array = Arrs.createArray(componentType, length);
            for (int i = 0; i < length; ++i) {
                Array.set(array, i, Array.get(o, i));
            }
            return array;
        }
        return (Object[])o;
    }

    public static Boolean[] wrap(final @Nullable boolean[] values, boolean resultNullable) {
        if (values == null) {
            return resultNullable ? null : new Boolean[]{};
        }
        return Arrs.createArray(Boolean.class, values.length, new Supplier<Integer, Boolean>(){

            @Override
            public Boolean get(Integer index) {
                return values[index];
            }
        });
    }

    public static boolean[] unwrap(final @Nullable Boolean[] values, boolean resultNullable) {
        if (values == null) {
            return resultNullable ? null : new boolean[]{};
        }
        return PrimitiveArrays.createBooleanArray(values.length, new Supplier<Integer, Boolean>(){

            @Override
            public Boolean get(Integer index) {
                return values[index];
            }
        });
    }

    public static Character[] wrap(final @Nullable char[] values, boolean resultNullable) {
        if (values == null) {
            return resultNullable ? null : new Character[]{};
        }
        return Arrs.createArray(Character.class, values.length, new Supplier<Integer, Character>(){

            @Override
            public Character get(Integer index) {
                return Character.valueOf(values[index]);
            }
        });
    }

    public static char[] unwrap(final @Nullable Character[] values, boolean resultNullable) {
        if (values == null) {
            return resultNullable ? null : new char[]{};
        }
        return PrimitiveArrays.createCharArray(values.length, new Supplier<Integer, Character>(){

            @Override
            public Character get(Integer index) {
                return values[index];
            }
        });
    }

    public static Byte[] wrap(final @Nullable byte[] values, boolean resultNullable) {
        if (values == null) {
            return resultNullable ? null : new Byte[]{};
        }
        return Arrs.createArray(Byte.class, values.length, new Supplier<Integer, Byte>(){

            @Override
            public Byte get(Integer index) {
                return values[index];
            }
        });
    }

    public static byte[] unwrap(final @Nullable Byte[] values, boolean resultNullable) {
        if (values == null) {
            return resultNullable ? null : new byte[]{};
        }
        return PrimitiveArrays.createByteArray(values.length, new Supplier<Integer, Byte>(){

            @Override
            public Byte get(Integer index) {
                return values[index];
            }
        });
    }

    public static Short[] wrap(final @Nullable short[] values, boolean resultNullable) {
        if (values == null) {
            return resultNullable ? null : new Short[]{};
        }
        return Arrs.createArray(Short.class, values.length, new Supplier<Integer, Short>(){

            @Override
            public Short get(Integer index) {
                return values[index];
            }
        });
    }

    public static short[] unwrap(final @Nullable Short[] values, boolean resultNullable) {
        if (values == null) {
            return resultNullable ? null : new short[]{};
        }
        return PrimitiveArrays.createShortArray(values.length, new Supplier<Integer, Short>(){

            @Override
            public Short get(Integer i) {
                return values[i];
            }
        });
    }

    public static Integer[] wrap(final @Nullable int[] values, boolean resultNullable) {
        if (values == null) {
            return resultNullable ? null : new Integer[]{};
        }
        return Arrs.createArray(Integer.class, values.length, new Supplier<Integer, Integer>(){

            @Override
            public Integer get(Integer index) {
                return values[index];
            }
        });
    }

    public static int[] unwrap(final @Nullable Integer[] values, boolean resultNullable) {
        if (values == null) {
            return resultNullable ? null : new int[]{};
        }
        return PrimitiveArrays.createIntArray(values.length, new Supplier<Integer, Integer>(){

            @Override
            public Integer get(Integer index) {
                return values[index];
            }
        });
    }

    public static Float[] wrap(final @Nullable float[] values, boolean resultNullable) {
        if (values == null) {
            return resultNullable ? null : new Float[]{};
        }
        return Arrs.createArray(Float.class, values.length, new Supplier<Integer, Float>(){

            @Override
            public Float get(Integer index) {
                return Float.valueOf(values[index]);
            }
        });
    }

    public static float[] unwrap(final @Nullable Float[] values, boolean resultNullable) {
        if (values == null) {
            return resultNullable ? null : new float[]{};
        }
        return PrimitiveArrays.createFloatArray(values.length, new Supplier<Integer, Float>(){

            @Override
            public Float get(Integer index) {
                return values[index];
            }
        });
    }

    public static Long[] wrap(final @Nullable long[] values, boolean resultNullable) {
        if (values == null) {
            return resultNullable ? null : new Long[]{};
        }
        return Arrs.createArray(Long.class, values.length, new Supplier<Integer, Long>(){

            @Override
            public Long get(Integer index) {
                return values[index];
            }
        });
    }

    public static long[] unwrap(final @Nullable Long[] values, boolean resultNullable) {
        if (values == null) {
            return resultNullable ? null : new long[]{};
        }
        return PrimitiveArrays.createLongArray(values.length, new Supplier<Integer, Long>(){

            @Override
            public Long get(Integer index) {
                return values[index];
            }
        });
    }

    public static Double[] wrap(final @Nullable double[] values, boolean resultNullable) {
        if (values == null) {
            return resultNullable ? null : new Double[]{};
        }
        return Arrs.createArray(Double.class, values.length, new Supplier<Integer, Double>(){

            @Override
            public Double get(Integer index) {
                return values[index];
            }
        });
    }

    public static double[] unwrap(final @Nullable Double[] values, boolean resultNullable) {
        if (values == null) {
            return resultNullable ? null : new double[]{};
        }
        return PrimitiveArrays.createDoubleArray(values.length, new Supplier<Integer, Double>(){

            @Override
            public Double get(Integer index) {
                return values[index];
            }
        });
    }

    public static boolean equals(long[] a, long[] a2) {
        return Arrays.equals(a, a2);
    }

    public static boolean equals(long[] a, Long[] a2) {
        return Arrays.equals(a, PrimitiveArrays.unwrap(a2, true));
    }

    public static boolean equals(int[] a, int[] a2) {
        return Arrays.equals(a, a2);
    }

    public static boolean equals(int[] a, Integer[] a2) {
        return Arrays.equals(a, PrimitiveArrays.unwrap(a2, true));
    }

    public static boolean equals(short[] a, short[] a2) {
        return Arrays.equals(a, a2);
    }

    public static boolean equals(short[] a, Short[] a2) {
        return Arrays.equals(a, PrimitiveArrays.unwrap(a2, true));
    }

    public static boolean equals(char[] a, char[] a2) {
        return Arrays.equals(a, a2);
    }

    public static boolean equals(char[] a, Character[] a2) {
        return Arrays.equals(a, PrimitiveArrays.unwrap(a2, true));
    }

    public static boolean equals(byte[] a, byte[] a2) {
        return Bytes.arrayEquals(a, a2);
    }

    public static boolean equals(byte[] a, Byte[] a2) {
        return Arrays.equals(a, PrimitiveArrays.unwrap(a2, true));
    }

    public static boolean equals(boolean[] a, boolean[] a2) {
        return Arrays.equals(a, a2);
    }

    public static boolean equals(boolean[] a, Boolean[] a2) {
        return Arrays.equals(a, PrimitiveArrays.unwrap(a2, true));
    }

    public static boolean equals(double[] a, double[] a2) {
        return Arrays.equals(a, a2);
    }

    public static boolean equals(double[] a, Double[] a2) {
        return Arrays.equals(a, PrimitiveArrays.unwrap(a2, true));
    }

    public static boolean equals(float[] a, float[] a2) {
        return Arrays.equals(a, a2);
    }

    public static boolean equals(float[] a, Float[] a2) {
        return Arrays.equals(a, PrimitiveArrays.unwrap(a2, true));
    }

    public static boolean equals(Object[] a, Object[] a2) {
        return Arrays.equals(a, a2);
    }

    public static byte[] createByteArray(int length, final byte initValue) {
        return PrimitiveArrays.createByteArray(length, new Supplier<Integer, Byte>(){

            @Override
            public Byte get(Integer index) {
                return initValue;
            }
        });
    }

    public static byte[] createByteArray(int length, Supplier<Integer, Byte> initValueSupplier) {
        byte[] array = new byte[length];
        if (initValueSupplier != null) {
            for (int i = 0; i < length; ++i) {
                array[i] = initValueSupplier.get(i);
            }
        }
        return array;
    }

    public static short[] createShortArray(int length, final short initValue) {
        return PrimitiveArrays.createShortArray(length, new Supplier<Integer, Short>(){

            @Override
            public Short get(Integer index) {
                return initValue;
            }
        });
    }

    public static short[] createShortArray(int length, Supplier<Integer, Short> initValueSupplier) {
        short[] array = new short[length];
        if (initValueSupplier != null) {
            for (int i = 0; i < length; ++i) {
                array[i] = initValueSupplier.get(i);
            }
        }
        return array;
    }

    public static char[] createCharArray(int length, final char initValue) {
        return PrimitiveArrays.createCharArray(length, new Supplier<Integer, Character>(){

            @Override
            public Character get(Integer index) {
                return Character.valueOf(initValue);
            }
        });
    }

    public static char[] createCharArray(int length, Supplier<Integer, Character> initValueSupplier) {
        char[] array = new char[length];
        if (initValueSupplier != null) {
            for (int i = 0; i < length; ++i) {
                array[i] = initValueSupplier.get(i).charValue();
            }
        }
        return array;
    }

    public static int[] createIntArray(int length, final int initValue) {
        return PrimitiveArrays.createIntArray(length, new Supplier<Integer, Integer>(){

            @Override
            public Integer get(Integer index) {
                return initValue;
            }
        });
    }

    public static int[] createIntArray(int length, Supplier<Integer, Integer> initValueSupplier) {
        int[] array = new int[length];
        if (initValueSupplier != null) {
            for (int i = 0; i < length; ++i) {
                array[i] = initValueSupplier.get(i);
            }
        }
        return array;
    }

    public static long[] createLongArray(int length, final long initValue) {
        return PrimitiveArrays.createLongArray(length, new Supplier<Integer, Long>(){

            @Override
            public Long get(Integer index) {
                return initValue;
            }
        });
    }

    public static long[] createLongArray(int length, Supplier<Integer, Long> initValueSupplier) {
        long[] array = new long[length];
        if (initValueSupplier != null) {
            for (int i = 0; i < length; ++i) {
                array[i] = initValueSupplier.get(i);
            }
        }
        return array;
    }

    public static float[] createFloatArray(int length, final float initValue) {
        return PrimitiveArrays.createFloatArray(length, new Supplier<Integer, Float>(){

            @Override
            public Float get(Integer index) {
                return Float.valueOf(initValue);
            }
        });
    }

    public static float[] createFloatArray(int length, Supplier<Integer, Float> initValueSupplier) {
        float[] array = new float[length];
        if (initValueSupplier != null) {
            for (int i = 0; i < length; ++i) {
                array[i] = initValueSupplier.get(i).floatValue();
            }
        }
        return array;
    }

    public static double[] createDoubleArray(int length, final Double initValue) {
        return PrimitiveArrays.createDoubleArray(length, new Supplier<Integer, Double>(){

            @Override
            public Double get(Integer index) {
                return initValue;
            }
        });
    }

    public static double[] createDoubleArray(int length, Supplier<Integer, Double> initValueSupplier) {
        double[] array = new double[length];
        if (initValueSupplier != null) {
            for (int i = 0; i < length; ++i) {
                array[i] = initValueSupplier.get(i);
            }
        }
        return array;
    }

    public static boolean[] createBooleanArray(int length, final boolean initValue) {
        return PrimitiveArrays.createBooleanArray(length, new Supplier<Integer, Boolean>(){

            @Override
            public Boolean get(Integer index) {
                return initValue;
            }
        });
    }

    public static boolean[] createBooleanArray(int length, Supplier<Integer, Boolean> initValueSupplier) {
        boolean[] array = new boolean[length];
        if (initValueSupplier != null) {
            for (int i = 0; i < length; ++i) {
                array[i] = initValueSupplier.get(i);
            }
        }
        return array;
    }

    public static byte[] copy(final byte[] values) {
        return PrimitiveArrays.createByteArray(values.length, new Supplier<Integer, Byte>(){

            @Override
            public Byte get(Integer index) {
                return values[index];
            }
        });
    }

    public static short[] copy(final short[] values) {
        return PrimitiveArrays.createShortArray(values.length, new Supplier<Integer, Short>(){

            @Override
            public Short get(Integer input) {
                return values[input];
            }
        });
    }

    public static int[] copy(final int[] values) {
        return PrimitiveArrays.createIntArray(values.length, new Supplier<Integer, Integer>(){

            @Override
            public Integer get(Integer input) {
                return values[input];
            }
        });
    }

    public static boolean[] copy(final boolean[] values) {
        return PrimitiveArrays.createBooleanArray(values.length, new Supplier<Integer, Boolean>(){

            @Override
            public Boolean get(Integer input) {
                return values[input];
            }
        });
    }

    public static char[] copy(final char[] values) {
        return PrimitiveArrays.createCharArray(values.length, new Supplier<Integer, Character>(){

            @Override
            public Character get(Integer input) {
                return Character.valueOf(values[input]);
            }
        });
    }

    public static float[] copy(final float[] values) {
        return PrimitiveArrays.createFloatArray(values.length, new Supplier<Integer, Float>(){

            @Override
            public Float get(Integer input) {
                return Float.valueOf(values[input]);
            }
        });
    }

    public static double[] copy(final double[] values) {
        return PrimitiveArrays.createDoubleArray(values.length, new Supplier<Integer, Double>(){

            @Override
            public Double get(Integer input) {
                return values[input];
            }
        });
    }

    public static long[] copy(final long[] values) {
        return PrimitiveArrays.createLongArray(values.length, new Supplier<Integer, Long>(){

            @Override
            public Long get(Integer input) {
                return values[input];
            }
        });
    }

    public static int indexOf(boolean[] array, boolean valueToFind) {
        return PrimitiveArrays.indexOf(array, valueToFind, 0);
    }

    public static int indexOf(boolean[] array, boolean valueToFind, int startIndex) {
        if (Objs.isEmpty(array)) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(byte[] array, byte valueToFind) {
        return PrimitiveArrays.indexOf(array, valueToFind, 0);
    }

    public static int indexOf(byte[] array, byte valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(char[] array, char valueToFind) {
        return PrimitiveArrays.indexOf(array, valueToFind, 0);
    }

    public static int indexOf(char[] array, char valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(double[] array, double valueToFind) {
        return PrimitiveArrays.indexOf(array, valueToFind, 0);
    }

    public static int indexOf(double[] array, double valueToFind, double tolerance) {
        return PrimitiveArrays.indexOf(array, valueToFind, 0, tolerance);
    }

    public static int indexOf(double[] array, double valueToFind, int startIndex) {
        if (Objs.isEmpty(array)) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        boolean searchNaN = Double.isNaN(valueToFind);
        for (int i = startIndex; i < array.length; ++i) {
            double element = array[i];
            if (valueToFind != element && (!searchNaN || !Double.isNaN(element))) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(double[] array, double valueToFind, int startIndex, double tolerance) {
        if (Objs.isEmpty(array)) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        double min = valueToFind - tolerance;
        double max = valueToFind + tolerance;
        for (int i = startIndex; i < array.length; ++i) {
            if (!(array[i] >= min) || !(array[i] <= max)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(float[] array, float valueToFind) {
        return PrimitiveArrays.indexOf(array, valueToFind, 0);
    }

    public static int indexOf(float[] array, float valueToFind, int startIndex) {
        if (Objs.isEmpty(array)) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        boolean searchNaN = Float.isNaN(valueToFind);
        for (int i = startIndex; i < array.length; ++i) {
            float element = array[i];
            if (valueToFind != element && (!searchNaN || !Float.isNaN(element))) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(int[] array, int valueToFind) {
        return PrimitiveArrays.indexOf(array, valueToFind, 0);
    }

    public static int indexOf(int[] array, int valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(long[] array, long valueToFind) {
        return PrimitiveArrays.indexOf(array, valueToFind, 0);
    }

    public static int indexOf(long[] array, long valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(short[] array, short valueToFind) {
        return PrimitiveArrays.indexOf(array, valueToFind, 0);
    }

    public static int indexOf(short[] array, short valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static boolean[] insert(int index, boolean[] array, boolean ... values) {
        if (array == null) {
            return array;
        }
        if (Objs.isEmpty(values)) {
            return PrimitiveArrays.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        boolean[] result = new boolean[array.length + values.length];
        System.arraycopy(values, 0, result, index, values.length);
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        if (index < array.length) {
            System.arraycopy(array, index, result, index + values.length, array.length - index);
        }
        return result;
    }

    public static byte[] insert(int index, byte[] array, byte ... values) {
        if (array == null) {
            return array;
        }
        if (Objs.isEmpty(values)) {
            return PrimitiveArrays.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        byte[] result = new byte[array.length + values.length];
        System.arraycopy(values, 0, result, index, values.length);
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        if (index < array.length) {
            System.arraycopy(array, index, result, index + values.length, array.length - index);
        }
        return result;
    }

    public static char[] insert(int index, char[] array, char ... values) {
        if (array == null) {
            return array;
        }
        if (Objs.isEmpty(values)) {
            return PrimitiveArrays.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        char[] result = new char[array.length + values.length];
        System.arraycopy(values, 0, result, index, values.length);
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        if (index < array.length) {
            System.arraycopy(array, index, result, index + values.length, array.length - index);
        }
        return result;
    }

    public static double[] insert(int index, double[] array, double ... values) {
        if (array == null) {
            return array;
        }
        if (Objs.isEmpty(values)) {
            return PrimitiveArrays.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        double[] result = new double[array.length + values.length];
        System.arraycopy(values, 0, result, index, values.length);
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        if (index < array.length) {
            System.arraycopy(array, index, result, index + values.length, array.length - index);
        }
        return result;
    }

    public static float[] insert(int index, float[] array, float ... values) {
        if (array == null) {
            return array;
        }
        if (Objs.isEmpty(values)) {
            return PrimitiveArrays.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        float[] result = new float[array.length + values.length];
        System.arraycopy(values, 0, result, index, values.length);
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        if (index < array.length) {
            System.arraycopy(array, index, result, index + values.length, array.length - index);
        }
        return result;
    }

    public static int[] insert(int index, int[] array, int ... values) {
        if (array == null) {
            return array;
        }
        if (Objs.isEmpty(values)) {
            return PrimitiveArrays.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        int[] result = new int[array.length + values.length];
        System.arraycopy(values, 0, result, index, values.length);
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        if (index < array.length) {
            System.arraycopy(array, index, result, index + values.length, array.length - index);
        }
        return result;
    }

    public static long[] insert(int index, long[] array, long ... values) {
        if (array == null) {
            return array;
        }
        if (Objs.isEmpty(values)) {
            return PrimitiveArrays.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        long[] result = new long[array.length + values.length];
        System.arraycopy(values, 0, result, index, values.length);
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        if (index < array.length) {
            System.arraycopy(array, index, result, index + values.length, array.length - index);
        }
        return result;
    }

    public static short[] insert(int index, short[] array, short ... values) {
        if (array == null) {
            return array;
        }
        if (Objs.isEmpty(values)) {
            return PrimitiveArrays.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        short[] result = new short[array.length + values.length];
        System.arraycopy(values, 0, result, index, values.length);
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        if (index < array.length) {
            System.arraycopy(array, index, result, index + values.length, array.length - index);
        }
        return result;
    }

    public static <T> T[] insert(int index, T[] array, T ... values) {
        if (array == null) {
            return array;
        }
        if (Objs.isEmpty(values)) {
            return PrimitiveArrays.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        Class<?> type = array.getClass().getComponentType();
        Object[] result = (Object[])Array.newInstance(type, array.length + values.length);
        System.arraycopy(values, 0, result, index, values.length);
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        if (index < array.length) {
            System.arraycopy(array, index, result, index + values.length, array.length - index);
        }
        return result;
    }

    public static boolean[] clone(boolean[] array) {
        if (array == null) {
            return array;
        }
        return (boolean[])array.clone();
    }

    public static byte[] clone(byte[] array) {
        if (array == null) {
            return array;
        }
        return (byte[])array.clone();
    }

    public static char[] clone(char[] array) {
        if (array == null) {
            return array;
        }
        return (char[])array.clone();
    }

    public static double[] clone(double[] array) {
        if (array == null) {
            return array;
        }
        return (double[])array.clone();
    }

    public static float[] clone(float[] array) {
        if (array == null) {
            return array;
        }
        return (float[])array.clone();
    }

    public static int[] clone(int[] array) {
        if (array == null) {
            return array;
        }
        return (int[])array.clone();
    }

    public static long[] clone(long[] array) {
        if (array == null) {
            return array;
        }
        return (long[])array.clone();
    }

    public static short[] clone(short[] array) {
        if (array == null) {
            return array;
        }
        return (short[])array.clone();
    }

    public static <T> T[] clone(T[] array) {
        if (array == null) {
            return array;
        }
        return (Object[])array.clone();
    }

    public static void sort(int[] a) {
        DualPivotQuicksort.sort(a, 0, a.length - 1, null, 0, 0);
    }

    public static void sort(int[] a, int fromIndex, int toIndex) {
        Preconditions.checkFromToIndex(fromIndex, toIndex, a.length);
        DualPivotQuicksort.sort(a, fromIndex, toIndex - 1, null, 0, 0);
    }

    public static void sort(long[] a) {
        DualPivotQuicksort.sort(a, 0, a.length - 1, null, 0, 0);
    }

    public static void sort(long[] a, int fromIndex, int toIndex) {
        Preconditions.checkFromToIndex(fromIndex, toIndex, a.length);
        DualPivotQuicksort.sort(a, fromIndex, toIndex - 1, null, 0, 0);
    }

    public static void sort(short[] a) {
        DualPivotQuicksort.sort(a, 0, a.length - 1, null, 0, 0);
    }

    public static void sort(short[] a, int fromIndex, int toIndex) {
        Preconditions.checkFromToIndex(fromIndex, toIndex, a.length);
        DualPivotQuicksort.sort(a, fromIndex, toIndex - 1, null, 0, 0);
    }

    public static void sort(char[] a) {
        DualPivotQuicksort.sort(a, 0, a.length - 1, null, 0, 0);
    }

    public static void sort(char[] a, int fromIndex, int toIndex) {
        Preconditions.checkFromToIndex(fromIndex, toIndex, a.length);
        DualPivotQuicksort.sort(a, fromIndex, toIndex - 1, null, 0, 0);
    }

    public static void sort(byte[] a) {
        DualPivotQuicksort.sort(a, 0, a.length - 1);
    }

    public static void sort(byte[] a, int fromIndex, int toIndex) {
        Preconditions.checkFromToIndex(fromIndex, toIndex, a.length);
        DualPivotQuicksort.sort(a, fromIndex, toIndex - 1);
    }

    public static void sort(float[] a) {
        DualPivotQuicksort.sort(a, 0, a.length - 1, null, 0, 0);
    }

    public static void sort(float[] a, int fromIndex, int toIndex) {
        Preconditions.checkFromToIndex(fromIndex, toIndex, a.length);
        DualPivotQuicksort.sort(a, fromIndex, toIndex - 1, null, 0, 0);
    }

    public static void sort(double[] a) {
        DualPivotQuicksort.sort(a, 0, a.length - 1, null, 0, 0);
    }

    public static void sort(double[] a, int fromIndex, int toIndex) {
        Preconditions.checkFromToIndex(fromIndex, toIndex, a.length);
        DualPivotQuicksort.sort(a, fromIndex, toIndex - 1, null, 0, 0);
    }
}

