/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.collection;

import com.jn.langx.util.BasedStringAccessor;
import com.jn.langx.util.Maths;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.struct.Holder;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class Tuple
extends BasedStringAccessor<Integer, Collection>
implements Iterable,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient List<Object> elements = Collects.emptyArrayList();
    private int maxSize = 0;

    public Tuple(Object value0, Object ... values) {
        this.setTarget(Pipeline.of(new Object[]{value0}).addAll(Collects.asList(values)).getAll());
    }

    public Tuple(Collection<Object> values) {
        this.setTarget(values);
    }

    public Tuple(int expectedLength, Collection<Object> values) {
        this.setTarget0(expectedLength, values);
    }

    public static Tuple of(Object ... objects) {
        if (objects == null) {
            return new Tuple(Collects.<Object>emptyArrayList());
        }
        return new Tuple(Collects.asList(objects));
    }

    private void setTarget0(int expectedLength, Collection values) {
        Preconditions.checkTrue(expectedLength >= 0);
        Preconditions.checkNotNull(values);
        this.maxSize = Maths.max(values.size(), expectedLength);
        this.elements.clear();
        List list = Collects.limit(values, this.maxSize);
        while (list.size() < this.maxSize) {
            list.add(null);
        }
        this.elements.addAll(list);
    }

    @Override
    public List getTarget() {
        return this.elements;
    }

    @Override
    public void setTarget(Collection target) {
        Preconditions.checkNotNull(target);
        this.setTarget0(target.size(), target);
    }

    @Override
    public boolean has(Integer index) {
        return index >= 0 && index < this.elements.size();
    }

    public boolean contains(Object element) {
        return this.elements.contains(element);
    }

    @Override
    public Object get(Integer index) {
        return this.elements.get(index);
    }

    @Override
    public String getString(Integer index, String defaultValue) {
        Object o = this.get(index);
        return o == null ? defaultValue : o.toString();
    }

    @Override
    public void remove(Integer index) {
        this.set(index, (Object)null);
    }

    @Override
    public void set(Integer index, Object value) {
        Preconditions.checkTrue(index < this.maxSize && index >= 0);
        this.elements.set(index, value);
    }

    public Iterator iterator() {
        return this.elements.iterator();
    }

    public int capacity() {
        return this.maxSize;
    }

    public int size() {
        return this.elements.size();
    }

    public int hashCode() {
        final Holder<Integer> hashcode = new Holder<Integer>(this.size() << 4);
        Collects.forEach(this, new Consumer<Object>(){

            @Override
            public void accept(Object element) {
                hashcode.set((Integer)hashcode.get() + element.hashCode());
            }
        });
        return hashcode.get();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Tuple)) {
            return false;
        }
        Tuple t = (Tuple)obj;
        if (this.size() != t.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            Object element2;
            Object element = this.get(i);
            if (element.equals(element2 = t.get(i))) continue;
            return false;
        }
        return true;
    }

    public Object[] toArray() {
        return this.elements.toArray();
    }

    public <T> T[] toArray(T[] a) {
        return this.elements.toArray(a);
    }

    public String toString() {
        return Strings.join(", ", "(", ")", false, this.elements.iterator());
    }
}

