/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.collection.diff;

import com.jn.langx.annotation.Nullable;
import com.jn.langx.util.Objs;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Differ;
import com.jn.langx.util.collection.diff.CollectionDiffResult;
import com.jn.langx.util.collection.diff.JudgeType;
import com.jn.langx.util.collection.diff.KeyBuilder;
import com.jn.langx.util.collection.diff.MapDiffResult;
import com.jn.langx.util.collection.diff.MapDiffer;
import com.jn.langx.util.comparator.EqualsComparator;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.function.Mapper;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.struct.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;

public class CollectionDiffer<E>
implements Differ<Collection<E>, CollectionDiffResult<E>> {
    private Comparator<E> comparator;
    private KeyBuilder<String, E> keyBuilder;
    private List<JudgeType> judgeTypes = Collects.asList(EnumSet.allOf(JudgeType.class));

    public List<JudgeType> getJudgeTypes() {
        return this.judgeTypes;
    }

    public void setJudgeTypes(List<JudgeType> judgeTypes) {
        if (judgeTypes != null) {
            this.judgeTypes = judgeTypes;
        }
    }

    public void diffUsingMap(@Nullable KeyBuilder<String, E> keyBuilder) {
        this.keyBuilder = keyBuilder;
    }

    public void setComparator(@Nullable Comparator<E> comparator) {
        this.comparator = comparator;
    }

    @Override
    public CollectionDiffResult<E> diff(@Nullable Collection<E> oldCollection, @Nullable Collection<E> newCollection) {
        CollectionDiffResult<Object> result = new CollectionDiffResult<Object>();
        if (Objs.isEmpty(oldCollection) && Objs.isEmpty(newCollection)) {
            return result;
        }
        if (oldCollection == null) {
            result.setAdds(newCollection);
            return result;
        }
        if (newCollection == null) {
            result.setRemoves(oldCollection);
            return result;
        }
        if (this.isDiffUsingMapDiffer()) {
            Object oldMap = Collects.map(oldCollection, new Mapper<E, Pair<String, E>>(){

                @Override
                public Pair<String, E> apply(E element) {
                    return new Pair(CollectionDiffer.this.keyBuilder.getKey(element), element);
                }
            });
            Object newMap = Collects.map(newCollection, new Mapper<E, Pair<String, E>>(){

                @Override
                public Pair<String, E> apply(E element) {
                    return new Pair(CollectionDiffer.this.keyBuilder.getKey(element), element);
                }
            });
            MapDiffer mapDiffer = new MapDiffer();
            mapDiffer.setValueComparator(this.comparator);
            mapDiffer.setKeyComparator(new EqualsComparator());
            mapDiffer.setJudgeTypes(this.judgeTypes);
            MapDiffResult dr = mapDiffer.diff(oldMap, newMap);
            result.setAdds(dr.getAdds().values());
            result.setRemoves(dr.getRemoves().values());
            result.setEquals(dr.getEquals().values());
            result.setUpdates(dr.getUpdates().values());
        } else {
            this.doDiff(oldCollection, newCollection, result);
        }
        return result;
    }

    private boolean isDiffUsingMapDiffer() {
        return this.keyBuilder != null;
    }

    private void doDiff(final Collection<E> oldCollection, final Collection<E> newCollection, CollectionDiffResult<E> result) {
        Comparator<Object> comp;
        final ArrayList adds = new ArrayList();
        final ArrayList removes = new ArrayList();
        final ArrayList equals = new ArrayList();
        Comparator<Object> comparator = comp = this.comparator == null ? new EqualsComparator() : this.comparator;
        if (this.judgeTypes.contains(JudgeType.ADDED) || this.judgeTypes.contains(JudgeType.EQUALED)) {
            Collects.forEach(newCollection, new Consumer<E>(){

                @Override
                public void accept(final E newValue) {
                    if (Collects.anyMatch(oldCollection, new Predicate<E>(){

                        @Override
                        public boolean test(E oldValue) {
                            return comp.compare(oldValue, newValue) == 0;
                        }
                    })) {
                        equals.add(newValue);
                    } else {
                        adds.add(newValue);
                    }
                }
            });
        }
        if (this.judgeTypes.contains(JudgeType.REMOVED)) {
            Collects.forEach(oldCollection, new Consumer<E>(){

                @Override
                public void accept(final E oldValue) {
                    if (Collects.noneMatch(newCollection, new Predicate<E>(){

                        @Override
                        public boolean test(E newValue) {
                            return comp.compare(oldValue, newValue) == 0;
                        }
                    })) {
                        removes.add(oldValue);
                    }
                }
            });
        }
        result.setAdds(adds);
        result.setRemoves(removes);
        result.setEquals(equals);
    }
}

