/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.collection.diff;

import com.jn.langx.annotation.Nullable;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Differ;
import com.jn.langx.util.collection.diff.CollectionDiffResult;
import com.jn.langx.util.collection.diff.CollectionDiffer;
import com.jn.langx.util.collection.diff.JudgeType;
import com.jn.langx.util.collection.diff.MapDiffResult;
import com.jn.langx.util.function.Consumer;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MapDiffer<K, V>
implements Differ<Map<K, V>, MapDiffResult<K, V>> {
    @Nullable
    private Comparator<K> keyComparator;
    @Nullable
    private Comparator<V> valueComparator;
    private List<JudgeType> judgeTypes = Collects.asList(EnumSet.allOf(JudgeType.class));

    public List<JudgeType> getJudgeTypes() {
        return this.judgeTypes;
    }

    public void setJudgeTypes(List<JudgeType> judgeTypes) {
        if (judgeTypes != null) {
            this.judgeTypes = judgeTypes;
        }
    }

    public void setKeyComparator(@Nullable Comparator<K> comparator) {
        this.keyComparator = comparator;
    }

    public void setValueComparator(@Nullable Comparator<V> comparator) {
        this.valueComparator = comparator;
    }

    @Override
    public MapDiffResult<K, V> diff(final @Nullable Map<K, V> oldMap, final @Nullable Map<K, V> newMap) {
        MapDiffResult result = new MapDiffResult();
        if (oldMap == null && newMap == null) {
            return result;
        }
        if (newMap == null) {
            result.setRemoves(oldMap);
            return result;
        }
        if (oldMap == null) {
            result.setAdds(newMap);
            return result;
        }
        Set<K> oldKeys = oldMap.keySet();
        Set<K> newKeys = newMap.keySet();
        CollectionDiffer<K> keyDiffer = new CollectionDiffer<K>();
        keyDiffer.setComparator(this.keyComparator);
        keyDiffer.setJudgeTypes(this.getJudgeTypes());
        CollectionDiffResult keyDiffResult = keyDiffer.diff((Collection<K>)oldKeys, (Collection<K>)newKeys);
        Object addsKeys = keyDiffResult.getAdds();
        final HashMap addsMap = new HashMap();
        Collects.forEach(addsKeys, new Consumer<K>(){

            @Override
            public void accept(K key) {
                addsMap.put(key, newMap.get(key));
            }
        });
        final HashMap removesMap = new HashMap();
        Object removesKeys = keyDiffResult.getRemoves();
        Collects.forEach(removesKeys, new Consumer<K>(){

            @Override
            public void accept(K key) {
                removesMap.put(key, oldMap.get(key));
            }
        });
        Object keyEquals = keyDiffResult.getEquals();
        final HashMap equalsMap = new HashMap();
        final HashMap updatesMap = new HashMap();
        if (this.judgeTypes.contains(JudgeType.EQUALED) || this.judgeTypes.contains(JudgeType.UPDATED)) {
            Collects.forEach(keyEquals, new Consumer<K>(){

                @Override
                public void accept(K key) {
                    Object oldValue = oldMap.get(key);
                    Object newValue = newMap.get(key);
                    if (MapDiffer.this.valueComparator == null) {
                        if (oldValue.equals(newValue)) {
                            equalsMap.put(key, newValue);
                        } else {
                            updatesMap.put(key, newValue);
                        }
                    } else if (MapDiffer.this.valueComparator.compare(oldValue, newValue) == 0) {
                        equalsMap.put(key, newValue);
                    } else {
                        updatesMap.put(key, newValue);
                    }
                }
            });
        }
        result.setAdds(addsMap);
        result.setRemoves(removesMap);
        result.setEquals(equalsMap);
        result.setUpdates(updatesMap);
        return result;
    }
}

