/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.collection.exclusion;

import com.jn.langx.util.Objs;
import com.jn.langx.util.function.Predicate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class IncludeExcludeSet<T, P>
implements Predicate<P> {
    private final Set<T> inclusions;
    private final Predicate<P> includePredicate;
    private final Set<T> exclusions;
    private final Predicate<P> excludePredicate;

    public IncludeExcludeSet() {
        this(HashSet.class);
    }

    public <SET extends Set<T>> IncludeExcludeSet(Class<SET> setClass) {
        try {
            this.inclusions = (Set)setClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.exclusions = (Set)setClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.includePredicate = this.inclusions instanceof Predicate ? (Predicate<Object>)((Object)this.inclusions) : new SetContainsPredicate<P>(this.inclusions);
            this.excludePredicate = this.exclusions instanceof Predicate ? (Predicate<Object>)((Object)this.exclusions) : new SetContainsPredicate<P>(this.exclusions);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <SET extends Set<T>> IncludeExcludeSet(Set<T> includeSet, Predicate<P> includePredicate, Set<T> excludeSet, Predicate<P> excludePredicate) {
        Objs.requireNonNull(includeSet, "Include Set");
        Objs.requireNonNull(includePredicate, "Include Predicate");
        Objs.requireNonNull(excludeSet, "Exclude Set");
        Objs.requireNonNull(excludePredicate, "Exclude Predicate");
        this.inclusions = includeSet;
        this.includePredicate = includePredicate;
        this.exclusions = excludeSet;
        this.excludePredicate = excludePredicate;
    }

    public void addInclusion(T element) {
        this.inclusions.add(element);
    }

    public void addInclusions(T ... element) {
        this.inclusions.addAll(Arrays.asList(element));
    }

    public void addExclusion(T element) {
        this.exclusions.add(element);
    }

    public void addExclusions(T ... element) {
        this.exclusions.addAll(Arrays.asList(element));
    }

    @Override
    public boolean test(P t) {
        if (!this.inclusions.isEmpty() && !this.includePredicate.test(t)) {
            return false;
        }
        return !this.excludePredicate.test(t);
    }

    public Boolean isIncludedAndNotExcluded(P item) {
        if (this.excludePredicate.test(item)) {
            return Boolean.FALSE;
        }
        if (this.includePredicate.test(item)) {
            return Boolean.TRUE;
        }
        return null;
    }

    public boolean hasInclusions() {
        return !this.inclusions.isEmpty();
    }

    public boolean hasExclusions() {
        return !this.exclusions.isEmpty();
    }

    public int size() {
        return this.inclusions.size() + this.exclusions.size();
    }

    public Set<T> getInclusions() {
        return this.inclusions;
    }

    public Set<T> getExclusions() {
        return this.exclusions;
    }

    public void clear() {
        this.inclusions.clear();
        this.exclusions.clear();
    }

    public String toString() {
        return String.format("%s@%x{i=%s,ip=%s,e=%s,ep=%s}", this.getClass().getSimpleName(), this.hashCode(), this.inclusions, this.includePredicate == null ? "SELF" : this.includePredicate, this.exclusions, this.excludePredicate == null ? "SELF" : this.excludePredicate);
    }

    public boolean isEmpty() {
        return this.inclusions.isEmpty() && this.exclusions.isEmpty();
    }

    private static class SetContainsPredicate<T>
    implements Predicate<T> {
        private final Set<T> set;

        public SetContainsPredicate(Set<T> set) {
            this.set = set;
        }

        @Override
        public boolean test(T item) {
            return this.set.contains(item);
        }

        public String toString() {
            return "CONTAINS";
        }
    }
}

