/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.collection.graph;

import com.jn.langx.util.collection.graph.CycleDetectedException;
import com.jn.langx.util.collection.graph.Edge;
import com.jn.langx.util.collection.graph.Graph;
import com.jn.langx.util.collection.graph.Graphs;
import com.jn.langx.util.collection.graph.Vertex;
import java.util.List;

public class DAG<T>
extends Graph<T> {
    @Override
    public boolean addEdge(Vertex<T> from, Vertex<T> to, int weight) {
        if (!this.hasVertex(from.getName())) {
            this.addVertex(from);
        }
        if (!this.hasVertex(to.getName())) {
            this.addVertex(to);
        }
        Edge<T> e = new Edge<T>(from, to, weight);
        if (from.findEdge(to) != null) {
            return false;
        }
        from.addEdge(e);
        to.addEdge(e);
        List<String> cycle = Graphs.detectCycle(to);
        if (cycle != null) {
            this.removeEdge(from, to);
            String msg = "Edge between '" + from + "' and '" + to + "' introduces to cycle in the graph";
            throw new CycleDetectedException(msg, cycle);
        }
        this.edges.add(e);
        return true;
    }
}

