/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.collection.graph.traverser;

import com.jn.langx.util.collection.graph.Edge;
import com.jn.langx.util.collection.graph.Graph;
import com.jn.langx.util.collection.graph.GraphTraverser;
import com.jn.langx.util.collection.graph.Graphs;
import com.jn.langx.util.collection.graph.Vertex;
import com.jn.langx.util.collection.graph.VertexConsumer;
import com.jn.langx.util.collection.graph.VisitStatus;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractGraphTraverser<T>
implements GraphTraverser<T> {
    @Override
    public void traverse(Graph<T> graph, String vertexName, VertexConsumer<T> consumer) {
        HashMap<String, VisitStatus> visitStatusMap = new HashMap<String, VisitStatus>();
        this.traverse(visitStatusMap, graph, vertexName, consumer);
    }

    @Override
    public void traverse(Map<String, VisitStatus> visitStatusMap, Graph<T> graph, String vertexName, VertexConsumer<T> consumer) {
        Vertex<T> vertex = graph.getVertex(vertexName);
        if (vertex == null) {
            throw new IllegalArgumentException("the vertex (" + vertexName + ") is not exists");
        }
        this.traverse(visitStatusMap, graph, vertex, null, consumer);
    }

    protected final void doVisit(Map<String, VisitStatus> visitStatusMap, Graph<T> graph, Vertex<T> vertex, Edge<T> edge, VertexConsumer<T> consumer) {
        if (Graphs.isNotVisited(visitStatusMap, vertex.getName())) {
            if (consumer != null) {
                consumer.accept(graph, vertex, edge);
            }
            Graphs.finishVisit(visitStatusMap, vertex.getName());
        }
    }

    protected abstract void traverse(Map<String, VisitStatus> var1, Graph<T> var2, Vertex<T> var3, Edge<T> var4, VertexConsumer<T> var5);
}

