/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.collection.iter;

import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Arrs;
import com.jn.langx.util.collection.PrimitiveArrays;
import com.jn.langx.util.collection.iter.UnmodifiableIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayIterator<E>
extends UnmodifiableIterator<E>
implements Iterable<E> {
    private final E[] array;
    private int index;
    private final int length;
    private boolean reversed;

    public ArrayIterator(Object array) {
        this(array, false);
    }

    public ArrayIterator(Object array, boolean reversed) {
        if (array != null) {
            Preconditions.checkArgument(Arrs.isArray(array));
            this.array = PrimitiveArrays.isPrimitiveArray(array.getClass()) ? PrimitiveArrays.wrap(array) : Arrs.copy((Object[])array);
        } else {
            this.array = null;
        }
        this.length = this.array == null ? 0 : this.array.length;
        this.reversed = reversed;
        this.index = reversed ? this.length - 1 : 0;
    }

    public ArrayIterator(E[] array) {
        this(array, false);
    }

    public ArrayIterator(E[] array, boolean reversed) {
        this.array = Arrs.copy(array);
        this.length = array == null ? 0 : array.length;
        this.reversed = reversed;
        this.index = reversed ? this.length - 1 : 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new ArrayIterator<E>(this.array, this.reversed);
    }

    @Override
    public boolean hasNext() {
        return this.reversed ? this.index >= 0 : this.index < this.length;
    }

    @Override
    public E next() {
        if (this.hasNext()) {
            int n;
            if (this.reversed) {
                int n2 = this.index;
                n = n2;
                this.index = n2 - 1;
            } else {
                int n3 = this.index;
                n = n3;
                this.index = n3 + 1;
            }
            return this.array[n];
        }
        throw new NoSuchElementException();
    }
}

