/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.collection.iter;

import com.jn.langx.util.Objs;
import java.util.Iterator;
import java.util.List;

public class CircularIterator<T>
implements Iterator<T> {
    int i = 0;
    private List<T> list;

    public CircularIterator(List<T> list) {
        this.list = list;
    }

    @Override
    public boolean hasNext() {
        return Objs.isNotEmpty(this.list);
    }

    @Override
    public T next() {
        T next = this.list.get(this.i);
        this.i = (this.i + 1) % this.list.size();
        return next;
    }

    public T peek() {
        return this.list.get(this.i);
    }

    @Override
    public void remove() {
        if (this.i >= 0 && this.i < this.list.size()) {
            this.list.remove(this.i);
            --this.i;
            if (this.i < 0) {
                this.i = 0;
            }
        }
    }
}

