/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.collection.sort;

import com.jn.langx.util.Preconditions;
import com.jn.langx.util.comparator.ComparableComparator;
import java.util.Comparator;

public class BinarySearch {
    private BinarySearch() {
    }

    public static <T> int binarySearch(T[] a, int fromIndex, int toIndex, T key, Comparator<? super T> c) {
        Preconditions.checkFromToIndex(fromIndex, toIndex, a.length);
        return BinarySearch.binarySearch0(a, fromIndex, toIndex, key, c);
    }

    private static <T> int binarySearch0(T[] a, int fromIndex, int toIndex, T key, Comparator<? super T> c) {
        if (c == null) {
            c = new ComparableComparator<T>();
        }
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            T midVal = a[mid];
            int cmp = c.compare(midVal, key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }
}

