/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.collection.tree;

import com.jn.langx.util.collection.tree.Tree;
import com.jn.langx.util.collection.tree.TreeNode;
import com.jn.langx.util.collection.tree.TreeNodeNotFoundException;
import com.jn.langx.util.function.Consumer2;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CommonTree
implements Tree {
    private static final long serialVersionUID = 1L;
    private transient Map<String, TreeNode> nodeMap = new HashMap<String, TreeNode>();
    private List<TreeNode> nodes = new LinkedList<TreeNode>();

    public CommonTree() {
        this(null);
    }

    public CommonTree(Collection<TreeNode> nodes) {
        if (nodes != null) {
            this.nodes.addAll(nodes);
        }
    }

    @Override
    public void addNode(TreeNode node) {
        String pid = node.getPid();
        this.addNode(pid, node);
    }

    @Override
    public void addNode(String pid, TreeNode node) {
        if (pid == null) {
            pid = node.getPid();
        }
        node.setPid(pid);
        TreeNode parentNode = this.nodeMap.get(pid);
        if (parentNode != null) {
            parentNode.addChildNode(node);
        } else {
            boolean isParent;
            List<TreeNode> rootNodes = this.nodes;
            TreeNode pnode = null;
            boolean isChild = false;
            for (TreeNode rootNode : rootNodes) {
                if (!rootNode.getId().equals(node.getPid())) continue;
                pnode = rootNode;
                break;
            }
            if (pnode != null) {
                isChild = true;
                pnode.addChildNode(node);
            }
            if (!(isParent = node.getIsParent())) {
                Iterator<TreeNode> iter = rootNodes.iterator();
                while (iter.hasNext()) {
                    TreeNode rootNode = iter.next();
                    if (!node.getId().equals(rootNode.getPid())) continue;
                    node.setIsParent(true);
                    node.addChildNode(rootNode);
                    iter.remove();
                }
            }
            if (!isChild) {
                this.nodes.add(node);
            }
        }
        this.nodeMap.put(node.getId(), node);
    }

    @Override
    public void addNodes(List<TreeNode> nodes) {
        for (TreeNode node : nodes) {
            this.addNode(node);
        }
    }

    @Override
    public void addNodes(String pid, List<TreeNode> nodes) {
        TreeNode parentNode = this.nodeMap.get(pid);
        if (parentNode != null) {
            for (TreeNode node : nodes) {
                node.setPid(pid);
            }
            parentNode.addChildNodes(nodes);
        } else {
            nodes.addAll(nodes);
        }
    }

    @Override
    public void removeNode(TreeNode node) {
        this.removeNode(node, false);
    }

    @Override
    public void removeNode(TreeNode node, boolean recursion) {
        Collection children;
        String pid = node.getPid();
        TreeNode parentNode = this.nodeMap.get(pid);
        if (parentNode == null) {
            this.nodes.remove(node);
        } else {
            parentNode.removeChildNode(node);
        }
        this.nodeMap.remove(node.getId());
        if (recursion && (children = node.getChildren()) != null && !children.isEmpty()) {
            for (TreeNode n : children) {
                this.removeNode(n, recursion);
            }
        }
    }

    @Override
    public Collection<TreeNode> removeChildNodes(String pid) {
        TreeNode parentNode = this.nodeMap.get(pid);
        if (parentNode == null) {
            return Collections.emptyList();
        }
        List<TreeNode> children = parentNode.removeChildNodes();
        if (children != null && !children.isEmpty()) {
            for (TreeNode n : children) {
                this.removeNode(n, true);
            }
        }
        return children;
    }

    @Override
    public TreeNode getNodeById(String id) {
        return this.nodeMap.get(id);
    }

    @Override
    public Collection<TreeNode> getNodes() {
        return this.nodes;
    }

    @Override
    public List<TreeNode> getNodesAsArray() {
        LinkedList<TreeNode> descendants = new LinkedList<TreeNode>();
        for (TreeNode node : this.nodes) {
            node.extractDescendants(descendants, true);
        }
        return descendants;
    }

    @Override
    public void forEach(Consumer2<Tree, TreeNode> cb) throws Throwable {
        this.forEachCollection(this.nodes, cb);
    }

    private void forEachCollection(Collection<TreeNode> collection, Consumer2<Tree, TreeNode> cb) throws Throwable {
        for (TreeNode node : collection) {
            cb.accept(this, node);
            Collection<TreeNode> children = node.getChildren();
            if (children == null || children.isEmpty()) continue;
            this.forEachCollection(children, cb);
        }
    }

    @Override
    public TreeNode getParentNode(String treeNodeId) {
        TreeNode node = this.getNodeById(treeNodeId);
        if (node == null) {
            throw new TreeNodeNotFoundException(treeNodeId);
        }
        return this.getParentNode(node);
    }

    @Override
    public TreeNode getParentNode(TreeNode treeNode) {
        return this.getNodeById(treeNode.getPid());
    }

    @Override
    public void sort(final Comparator<TreeNode> comparator) {
        try {
            this.forEachCollection(this.nodes, new Consumer2<Tree, TreeNode>(){
                private List<TreeNode> nodes;

                @Override
                public void accept(Tree tree, TreeNode node) {
                    Collections.sort(this.nodes, comparator);
                    this.setNodes(node.getChildren());
                }

                public void setNodes(Collection<TreeNode> nodes) {
                    this.nodes = new LinkedList<TreeNode>();
                    if (nodes != null && !nodes.isEmpty()) {
                        this.nodes.addAll(nodes);
                    }
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public List<TreeNode> getRootNodes() {
        return this.nodes;
    }

    @Override
    public Collection<TreeNode> getChildren(String id) {
        TreeNode node = this.nodeMap.get(id);
        if (node != null) {
            return node.getChildren();
        }
        return null;
    }

    @Override
    public void clear() {
        this.nodes.clear();
        this.nodeMap.clear();
    }
}

