/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.comparator;

import com.jn.langx.util.Objs;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.comparator.CharComparator;
import com.jn.langx.util.comparator.ReverseComparator;
import com.jn.langx.util.comparator.StringComparator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class Comparators {
    public static final Comparator<String> STRING_COMPARATOR = new StringComparator();
    public static final Comparator<String> STRING_COMPARATOR_IGNORE_CASE = new StringComparator(true);
    public static final Comparator<Character> CHAR_COMPARATOR = new CharComparator();

    private Comparators() {
    }

    public static <T> Comparator<T> chain(final Comparator<T> c1, final Comparator<T> c2) {
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                int x = c1.compare(o1, o2);
                return x == 0 ? c2.compare(o1, o2) : x;
            }
        };
    }

    public static <T> Comparator<T> chain(final List<Comparator<T>> c) {
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                int x = 0;
                Iterator it = c.iterator();
                while (x == 0 && it.hasNext()) {
                    x = ((Comparator)it.next()).compare(o1, o2);
                }
                return x;
            }
        };
    }

    public static <T> Comparator<T> chain(Comparator<T> ... c) {
        return Comparators.chain(Pipeline.of(c).asList());
    }

    public static <T> Comparator<T> reverse(Comparator<T> c) {
        return new ReverseComparator<T>(c);
    }

    public static <T extends Comparable<? super T>> Comparator<T> nullSafeNaturalComparator() {
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return Comparators.nullSafeCompare(o1, o2);
            }
        };
    }

    public static <T extends Comparable<? super T>> int nullSafeCompare(T one, T two) {
        if (one == null) {
            if (two == null) {
                return 0;
            }
            return -1;
        }
        if (two == null) {
            return 1;
        }
        return one.compareTo(two);
    }

    public static <C extends Comparable> Comparator<List<C>> getListComparator() {
        return new Comparator<List<C>>(){

            @Override
            public int compare(List<C> o1, List<C> o2) {
                return Comparators.compareLists(o1, o2);
            }
        };
    }

    public static Comparator getStringRepresentationComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                return new StringComparator().compare(Objs.toString(o1), Objs.toString(o2));
            }
        };
    }

    public static Comparator<boolean[]> getBooleanArrayComparator() {
        return new Comparator<boolean[]>(){

            @Override
            public int compare(boolean[] o1, boolean[] o2) {
                return Comparators.compareBooleanArrays(o1, o2);
            }
        };
    }

    public static <C extends Comparable> Comparator<C[]> getArrayComparator() {
        return new Comparator<C[]>(){

            @Override
            public int compare(C[] o1, C[] o2) {
                return Comparators.compareArrays(o1, o2);
            }
        };
    }

    public static <T extends Comparable<T>> int compareArrays(T[] first, T[] second) {
        List<T> firstAsList = Arrays.asList(first);
        List<T> secondAsList = Arrays.asList(second);
        return Comparators.compareLists(firstAsList, secondAsList);
    }

    public static <T extends Comparable<T>> int compareLists(List<T> list1, List<T> list2) {
        if (list1 == null && list2 == null) {
            return 0;
        }
        if (list1 == null || list2 == null) {
            throw new IllegalArgumentException();
        }
        int size1 = list1.size();
        int size2 = list2.size();
        int size = Math.min(size1, size2);
        for (int i = 0; i < size; ++i) {
            int c = ((Comparable)list1.get(i)).compareTo(list2.get(i));
            if (c == 0) continue;
            return c;
        }
        if (size1 < size2) {
            return -1;
        }
        if (size1 > size2) {
            return 1;
        }
        return 0;
    }

    public static int compareBooleanArrays(boolean[] a1, boolean[] a2) {
        int len = Math.min(a1.length, a2.length);
        for (int i = 0; i < len; ++i) {
            if (!a1[i] && a2[i]) {
                return -1;
            }
            if (!a1[i] || a2[i]) continue;
            return 1;
        }
        if (a1.length < a2.length) {
            return -1;
        }
        if (a1.length > a2.length) {
            return 1;
        }
        return 0;
    }
}

