/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.comparator;

import com.jn.langx.annotation.Nullable;
import com.jn.langx.util.comparator.Orders;
import com.jn.langx.util.function.Supplier;
import java.util.Comparator;

public class OrderedComparator<T>
implements Comparator<T> {
    @Nullable
    private Supplier<T, Integer> defaultOrderSupplier;

    public OrderedComparator() {
    }

    public OrderedComparator(Supplier<T, Integer> defaultOrderSupplier) {
        this.defaultOrderSupplier = defaultOrderSupplier;
    }

    public Supplier<T, Integer> getDefaultOrderSupplier() {
        return this.defaultOrderSupplier;
    }

    public void setDefaultOrderSupplier(Supplier<T, Integer> defaultOrderSupplier) {
        this.defaultOrderSupplier = defaultOrderSupplier;
    }

    @Override
    public int compare(T o1, T o2) {
        if (o1 == o2) {
            return 0;
        }
        Supplier<Object, Integer> defaultOrderSupplier = this.defaultOrderSupplier;
        int order1 = Orders.getOrder(o1, defaultOrderSupplier);
        int order2 = Orders.getOrder(o2, defaultOrderSupplier);
        return order1 - order2;
    }
}

