/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.concurrent;

import com.jn.langx.Factory;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.Strings;
import com.jn.langx.util.concurrent.WrappedThread;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class CommonThreadFactory
implements ThreadFactory,
Factory<Runnable, Thread> {
    private static final ConcurrentHashMap<String, AtomicInteger> PREFIX_TO_FACTORY = new ConcurrentHashMap();
    private static final Map<Integer, AtomicInteger> FACTORY_TO_THREAD = new ConcurrentHashMap<Integer, AtomicInteger>();
    private boolean daemon;
    private String prefix;
    private int factoryNo;

    public CommonThreadFactory() {
        this("COMMON", false);
    }

    public CommonThreadFactory(String prefix, boolean daemon) {
        if (Strings.isBlank(prefix)) {
            prefix = "COMMON";
        }
        this.daemon = daemon;
        this.prefix = prefix;
        PREFIX_TO_FACTORY.putIfAbsent(prefix, new AtomicInteger(0));
        this.factoryNo = PREFIX_TO_FACTORY.get(prefix).getAndIncrement();
        FACTORY_TO_THREAD.put(this.factoryNo, new AtomicInteger(0));
    }

    private String nextThreadName() {
        return StringTemplates.formatWithPlaceholder("{}({}-{})", this.prefix, this.factoryNo, FACTORY_TO_THREAD.get(this.factoryNo).getAndIncrement());
    }

    @Override
    public Thread newThread(Runnable r) {
        WrappedThread thread = new WrappedThread(r, this.nextThreadName());
        thread.setDaemon(this.daemon);
        return thread;
    }

    public Thread execute(Runnable r) {
        Thread thread = this.newThread(r);
        thread.start();
        return thread;
    }

    @Override
    public Thread get(Runnable runnable) {
        return this.newThread(runnable);
    }

    public static ThreadFactory create(String prefix, boolean daemon) {
        return new CommonThreadFactory(prefix, daemon);
    }

    public static ThreadFactory create(String prefix) {
        return new CommonThreadFactory(prefix, false);
    }
}

