/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.concurrent.async;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.util.concurrent.async.GenericFuture;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class AbstractFuture<V>
implements GenericFuture<V> {
    @Override
    public V get() throws InterruptedException, ExecutionException {
        this.await();
        Throwable cause = this.cause();
        if (cause == null) {
            return this.getNow();
        }
        if (cause instanceof CancellationException) {
            throw (CancellationException)cause;
        }
        throw new ExecutionException(cause);
    }

    @Override
    public final boolean isDone() {
        return this.isSuccess() || this.isCancelled() || this.cause() != null;
    }

    @Override
    public V get(long timeout, @NonNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.await(timeout, unit)) {
            Throwable cause = this.cause();
            if (cause == null) {
                return this.getNow();
            }
            if (cause instanceof CancellationException) {
                throw (CancellationException)cause;
            }
            throw new ExecutionException(cause);
        }
        throw new TimeoutException();
    }
}

