/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.converter;

import com.jn.langx.Converter;
import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.exception.ValueConvertException;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Maps;
import com.jn.langx.util.converter.BooleanConverter;
import com.jn.langx.util.converter.ByteConverter;
import com.jn.langx.util.converter.CharacterConverter;
import com.jn.langx.util.converter.DoubleConverter;
import com.jn.langx.util.converter.FloatConverter;
import com.jn.langx.util.converter.IntegerConverter;
import com.jn.langx.util.converter.LongConverter;
import com.jn.langx.util.converter.LongToDateConverter;
import com.jn.langx.util.converter.NoopConverter;
import com.jn.langx.util.converter.ShortConverter;
import com.jn.langx.util.converter.StringToDateConverter;
import com.jn.langx.util.function.Function;
import com.jn.langx.util.function.Predicate2;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ConverterService {
    public static final ConverterService DEFAULT;
    private static final Map<Class, Converter> TARGET_BUILTIN;
    private static final Map<Class, ConcurrentHashMap<Class, Converter>> TARGET_SOURCE_BUILTIN;
    private final Map<Class, Converter> target_registry = new ConcurrentHashMap<Class, Converter>(TARGET_BUILTIN);
    private ConcurrentHashMap<Class, ConcurrentHashMap<Class, Converter>> target_source_registry = new ConcurrentHashMap<Class, ConcurrentHashMap<Class, Converter>>(TARGET_SOURCE_BUILTIN);

    public void register(@NonNull Class targetClass, @Nullable Class sourceClass, @NonNull Converter converter) {
        if (sourceClass == null) {
            this.register(targetClass, converter);
            return;
        }
        Preconditions.checkNotNull(targetClass);
        Preconditions.checkNotNull(converter);
        ConcurrentHashMap<Class, Converter> map = Maps.putIfAbsent(this.target_source_registry, targetClass, new Function<Class, ConcurrentHashMap<Class, Converter>>(){

            @Override
            public ConcurrentHashMap<Class, Converter> apply(Class input) {
                return new ConcurrentHashMap<Class, Converter>();
            }
        });
        map.put(sourceClass, converter);
    }

    public void register(@NonNull Class targetClass, @NonNull Converter converter) {
        Preconditions.checkNotNull(targetClass);
        Preconditions.checkNotNull(converter);
        this.target_registry.put(targetClass, converter);
    }

    public <T> T convert(@Nullable Object obj, @NonNull Class<T> targetClass) {
        Converter<Object, T> converter = this.findConverter(obj, targetClass);
        if (converter == null) {
            if (obj == null) {
                return null;
            }
            throw new ValueConvertException(StringTemplates.formatWithPlaceholder("Can't cast {} to {}", obj, targetClass));
        }
        return converter.apply(obj);
    }

    public <S, T> Converter<S, T> findConverter(@Nullable S source, @NonNull Class<T> targetClass) {
        Preconditions.checkNotNull(targetClass);
        if (source == null) {
            return this.target_registry.get(targetClass);
        }
        Converter converter = this.findConverter(source.getClass(), targetClass);
        if (converter == null) {
            converter = this.target_registry.get(targetClass);
        }
        if (converter == null && source.getClass() == targetClass) {
            return NoopConverter.INSTANCE;
        }
        return converter;
    }

    public <S, T> Converter<S, T> findConverter(@NonNull Class<S> sourceClass, final @NonNull Class<T> targetClass) {
        Preconditions.checkNotNull(sourceClass);
        Preconditions.checkNotNull(targetClass);
        ConcurrentHashMap<Class, Converter> mapping = this.target_source_registry.get(targetClass);
        if (mapping != null) {
            Converter converter = mapping.get(sourceClass);
            if (converter != null) {
                return converter;
            }
            Map.Entry<Class, Converter> entry = Collects.findFirst(mapping, new Predicate2<Class, Converter>(){

                @Override
                public boolean test(Class sourceClass, Converter converter) {
                    return converter.isConvertible(sourceClass, targetClass);
                }
            });
            if (entry != null) {
                return entry.getValue();
            }
        }
        return null;
    }

    static {
        TARGET_BUILTIN = new HashMap<Class, Converter>();
        TARGET_SOURCE_BUILTIN = new HashMap<Class, ConcurrentHashMap<Class, Converter>>();
        TARGET_BUILTIN.put(Byte.class, ByteConverter.INSTANCE);
        TARGET_BUILTIN.put(Byte.TYPE, ByteConverter.INSTANCE);
        TARGET_BUILTIN.put(Short.class, ShortConverter.INSTANCE);
        TARGET_BUILTIN.put(Short.TYPE, ShortConverter.INSTANCE);
        TARGET_BUILTIN.put(Character.TYPE, CharacterConverter.INSTANCE);
        TARGET_BUILTIN.put(Character.class, CharacterConverter.INSTANCE);
        TARGET_BUILTIN.put(Integer.class, IntegerConverter.INSTANCE);
        TARGET_BUILTIN.put(Integer.TYPE, IntegerConverter.INSTANCE);
        TARGET_BUILTIN.put(Long.class, LongConverter.INSTANCE);
        TARGET_BUILTIN.put(Long.TYPE, LongConverter.INSTANCE);
        TARGET_BUILTIN.put(Float.class, FloatConverter.INSTANCE);
        TARGET_BUILTIN.put(Float.TYPE, FloatConverter.INSTANCE);
        TARGET_BUILTIN.put(Double.class, DoubleConverter.INSTANCE);
        TARGET_BUILTIN.put(Double.TYPE, DoubleConverter.INSTANCE);
        TARGET_BUILTIN.put(Boolean.TYPE, BooleanConverter.INSTANCE);
        TARGET_BUILTIN.put(Boolean.class, BooleanConverter.INSTANCE);
        ConcurrentHashMap<Class, Converter<String, Date>> toDateConverterMap = new ConcurrentHashMap<Class, Converter<String, Date>>();
        toDateConverterMap.put(String.class, StringToDateConverter.INSTANCE);
        toDateConverterMap.put(Long.class, LongToDateConverter.INSTANCE);
        TARGET_SOURCE_BUILTIN.put(Date.class, toDateConverterMap);
        DEFAULT = new ConverterService();
    }
}

