/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.datetime;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.NotEmpty;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.util.Objs;
import com.jn.langx.util.Preconditions;
import java.util.Locale;
import java.util.TimeZone;

public class DateFormatCacheKey {
    @NotEmpty
    public String pattern;
    @Nullable
    public String timeZoneId;
    @Nullable
    public Locale locale;

    public DateFormatCacheKey(@NonNull String pattern) {
        this(pattern, (String)null, null);
    }

    public DateFormatCacheKey(@NonNull String pattern, @Nullable String timeZoneId) {
        this(pattern, timeZoneId, null);
    }

    public DateFormatCacheKey(@NonNull String pattern, @Nullable TimeZone timeZone) {
        this(pattern, timeZone, null);
    }

    public DateFormatCacheKey(@NonNull String pattern, @Nullable Locale locale) {
        this(pattern, (String)null, locale);
    }

    public DateFormatCacheKey(@NonNull String pattern, @Nullable TimeZone timeZone, @Nullable Locale locale) {
        this(pattern, timeZone == null ? null : timeZone.getID(), locale);
    }

    public DateFormatCacheKey(@NonNull String pattern, @Nullable String timeZoneId, @Nullable Locale locale) {
        Preconditions.checkNotNull(pattern);
        this.locale = locale == null ? Locale.getDefault() : locale;
        this.timeZoneId = timeZoneId;
        this.pattern = pattern;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateFormatCacheKey that = (DateFormatCacheKey)o;
        if (!this.pattern.equals(that.pattern)) {
            return false;
        }
        if (!this.timeZoneId.equals(that.timeZoneId)) {
            return false;
        }
        return this.locale.equals(that.locale);
    }

    public int hashCode() {
        return Objs.hash(this.pattern, this.timeZoneId, this.locale);
    }
}

