/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.datetime;

import com.jn.langx.annotation.Singleton;
import com.jn.langx.registry.Registry;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.datetime.DateTimeFormatterFactory;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.reflect.Reflects;
import com.jn.langx.util.spi.CommonServiceProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Singleton
public class DateTimeFormatterFactoryRegistry
implements Registry<Class, DateTimeFormatterFactory> {
    private final Map<Class, DateTimeFormatterFactory> map = new HashMap<Class, DateTimeFormatterFactory>();
    private static volatile DateTimeFormatterFactoryRegistry INSTANCE;

    private DateTimeFormatterFactoryRegistry() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DateTimeFormatterFactoryRegistry getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<DateTimeFormatterFactoryRegistry> clazz = DateTimeFormatterFactoryRegistry.class;
        synchronized (DateTimeFormatterFactoryRegistry.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new DateTimeFormatterFactoryRegistry();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private void init() {
        Collects.forEach(CommonServiceProvider.loadService(DateTimeFormatterFactory.class), new Consumer<DateTimeFormatterFactory>(){

            @Override
            public void accept(DateTimeFormatterFactory factory) {
                DateTimeFormatterFactoryRegistry.this.register(factory);
            }
        });
    }

    @Override
    public DateTimeFormatterFactory get(final Class clazz) {
        Set<Class> classSet;
        Class key;
        DateTimeFormatterFactory factory = this.map.get(clazz);
        if (factory == null && (key = Collects.findFirst(classSet = this.map.keySet(), new Predicate<Class>(){

            @Override
            public boolean test(Class value) {
                return Reflects.isSubClassOrEquals(value, clazz);
            }
        })) != null) {
            factory = this.map.get(key);
        }
        return factory;
    }

    @Override
    public void register(final DateTimeFormatterFactory dateTimeFormatterFactory) {
        List<Class> supported = dateTimeFormatterFactory.supported();
        Collects.forEach(supported, new Consumer<Class>(){

            @Override
            public void accept(Class clazz) {
                DateTimeFormatterFactoryRegistry.this.register(clazz, dateTimeFormatterFactory);
            }
        });
    }

    @Override
    public void register(Class key, DateTimeFormatterFactory dateTimeFormatterFactory) {
        this.map.put(key, dateTimeFormatterFactory);
    }

    @Override
    public void unregister(Class key) {
        this.map.remove(key);
    }

    @Override
    public boolean contains(Class key) {
        return this.map.containsKey(key);
    }
}

