/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.datetime.calendarist;

import com.jn.langx.util.datetime.calendarist.CalendaristConstants;
import com.jn.langx.util.datetime.calendarist.CycleDate;
import com.jn.langx.util.datetime.calendarist.LunarDate;
import com.jn.langx.util.datetime.calendarist.Lunars;
import com.jn.langx.util.datetime.calendarist.SolarDate;
import java.util.Calendar;

public class CalendaristConvert {
    private CalendaristConvert() {
    }

    public static LunarDate toLunar(long timeMillis) {
        int iMonth;
        int iYear;
        int offset = (int)((timeMillis - -2206425943000L) / 86400000L);
        int daysOfYear = 0;
        for (iYear = 1900; iYear < 2100 && offset > 0; offset -= daysOfYear, ++iYear) {
            daysOfYear = Lunars.daysOfYear(iYear);
        }
        if (offset < 0) {
            offset += daysOfYear;
            --iYear;
        }
        int year = iYear;
        int leapMonth = Lunars.leapMonth(iYear);
        boolean leap = false;
        int daysOfMonth = 0;
        for (iMonth = 1; iMonth < 13 && offset > 0; ++iMonth) {
            if (leapMonth > 0 && iMonth == leapMonth + 1 && !leap) {
                --iMonth;
                leap = true;
                daysOfMonth = Lunars.daysOfLeapMonth(year);
            } else {
                daysOfMonth = Lunars.daysOfMonth(year, iMonth);
            }
            offset -= daysOfMonth;
            if (!leap || iMonth != leapMonth + 1) continue;
            leap = false;
        }
        if (offset == 0 && leapMonth > 0 && iMonth == leapMonth + 1) {
            if (leap) {
                leap = false;
            } else {
                leap = true;
                --iMonth;
            }
        }
        if (offset < 0) {
            offset += daysOfMonth;
            --iMonth;
        }
        int month = iMonth;
        int day = offset + 1;
        Calendar calendar = Lunars.getCalendarInstance();
        calendar.setTimeInMillis(timeMillis);
        return new LunarDate(year, month, day, calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14), leap);
    }

    public static SolarDate toSolar(LunarDate lunarDate) {
        long year;
        int d;
        int m;
        if (lunarDate == null) {
            throw new IllegalArgumentException("the param 'lunarDate' must not be null");
        }
        int days = CalendaristConstants.LUNAR_MONTH_DAYS[lunarDate.getYear() - 1887];
        int leap = Lunars.getBitInt(days, 4, 13);
        int offset = 0;
        int loopend = leap;
        if (!lunarDate.isItsLeapMonth()) {
            loopend = lunarDate.getMonth() <= leap || leap == 0 ? lunarDate.getMonth() - 1 : lunarDate.getMonth();
        }
        for (int i = 0; i < loopend; ++i) {
            offset += Lunars.getBitInt(days, 1, 12 - i) == 1 ? 30 : 29;
        }
        int solar11 = CalendaristConstants.SOLAR_CODE[lunarDate.getYear() - 1887];
        int y = Lunars.getBitInt(solar11, 12, 9);
        long g = Lunars.solarToInt(y, m = Lunars.getBitInt(solar11, 4, 5), d = Lunars.getBitInt(solar11, 5, 0)) + (long)(offset += lunarDate.getDay()) - 1L;
        long ddd = g - (365L * (year = (10000L * g + 14780L) / 3652425L) + year / 4L - year / 100L + year / 400L);
        if (ddd < 0L) {
            ddd = g - (365L * --year + year / 4L - year / 100L + year / 400L);
        }
        long mi = (100L * ddd + 52L) / 3060L;
        long mm = (mi + 2L) % 12L + 1L;
        long dd = ddd - (mi * 306L + 5L) / 10L + 1L;
        return new SolarDate((int)(year += (mi + 2L) / 12L), (int)mm, (int)dd, lunarDate.getHour(), lunarDate.getMinute(), lunarDate.getSecond(), lunarDate.getMillis());
    }

    public static CycleDate toCycle(LunarDate lunarDate) {
        if (lunarDate == null) {
            throw new IllegalArgumentException("the param 'lunarDate' must not be null");
        }
        SolarDate solarDate = CalendaristConvert.toSolar(lunarDate);
        int firstNode = Lunars.getFirstTerm(solarDate.getYear(), solarDate.getMonth());
        int cM = (solarDate.getYear() - 1900) * 12 + (solarDate.getMonth() - 1) + 12;
        if (solarDate.getDay() >= firstNode) {
            ++cM;
        }
        long startMillis = -28800000L;
        Calendar calendar = Lunars.getCalendarInstance();
        calendar.set(solarDate.getYear(), solarDate.getMonth() - 1, 1, 0, 0, 0);
        calendar.set(14, 0);
        int cD = (int)((calendar.getTimeInMillis() - startMillis) / 86400000L) + 25567 + 10 + solarDate.getDay() - 1;
        return new CycleDate(lunarDate.getYear() - 1864, cM, cD, solarDate.getHour(), 0, 0, 0);
    }

    public static CycleDate toCycle(SolarDate solarDate) {
        if (solarDate == null) {
            throw new IllegalArgumentException("missing the param 'solarDate'");
        }
        int firstNode = Lunars.getFirstTerm(solarDate.getYear(), solarDate.getMonth());
        int cM = (solarDate.getYear() - 1900) * 12 + (solarDate.getMonth() - 1) + 12;
        if (solarDate.getDay() >= firstNode) {
            ++cM;
        }
        long startMillis = -28800000L;
        Calendar calendar = Lunars.getCalendarInstance();
        calendar.set(solarDate.getYear(), solarDate.getMonth() - 1, 1, 0, 0, 0);
        calendar.set(14, 0);
        int cD = (int)((solarDate.getTimestamp() - startMillis) / 86400000L) + 25567 + 10 + solarDate.getDay() - 1;
        LunarDate lunarDate = CalendaristConvert.toLunar(solarDate.getTimestamp());
        return new CycleDate(lunarDate.getYear() - 1864, cM, cD, solarDate.getHour(), 0, 0, 0);
    }
}

