/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.datetime.calendarist;

import com.jn.langx.util.datetime.calendarist.CalendaristConstants;
import com.jn.langx.util.datetime.calendarist.SolarDate;
import java.util.Calendar;
import java.util.Date;

public class Lunars {
    private Lunars() {
    }

    public static Calendar getCalendarInstance() {
        return Calendar.getInstance(CalendaristConstants.DEFAULT_TIME_ZONE);
    }

    public static String ganZhi(int lunarValue) {
        return CalendaristConstants.TIANGAN_INFO[lunarValue % 10] + CalendaristConstants.DIZHI_INFO[lunarValue % 12];
    }

    public static String getZodiac(int lunarYear) {
        return CalendaristConstants.ZODIAC_INFO[(lunarYear - 4) % 12];
    }

    public static String hourGanZhi(int cycleDay, int cycleHour) {
        int index = cycleDay % 10;
        int hourOfDiZhiIndex = Lunars.hourZhi(cycleHour);
        int hourOfTianGanIndex = hourOfDiZhiIndex + (index %= 5) * 12;
        return CalendaristConstants.TIANGAN_INFO[hourOfTianGanIndex % 10] + CalendaristConstants.DIZHI_INFO[hourOfDiZhiIndex];
    }

    public static int hourZhi(int lunarHour) {
        if (lunarHour >= 23 || lunarHour < 1) {
            return 0;
        }
        if (lunarHour < 3) {
            return 1;
        }
        if (lunarHour < 5) {
            return 2;
        }
        if (lunarHour < 7) {
            return 3;
        }
        if (lunarHour < 9) {
            return 4;
        }
        if (lunarHour < 11) {
            return 5;
        }
        if (lunarHour < 13) {
            return 6;
        }
        if (lunarHour < 15) {
            return 7;
        }
        if (lunarHour < 17) {
            return 8;
        }
        if (lunarHour < 19) {
            return 9;
        }
        if (lunarHour < 21) {
            return 10;
        }
        return 11;
    }

    public static int chineseNewYear(Integer solarYear) {
        if (solarYear > 2100 || solarYear < 1900) {
            throw new RuntimeException("the year should between 1900 and 2100!");
        }
        return CalendaristConstants.CHINESE_NEW_YEAR[solarYear - 1900];
    }

    public static long chineseNewYearTimestamp(Integer solarYear) {
        if (solarYear > 2100 || solarYear < 1900) {
            throw new RuntimeException("the year should between 1900 and 2100!");
        }
        return CalendaristConstants.CHINESE_NEW_YEAR_TIMESTAMP[solarYear - 1900];
    }

    public static long solarToInt(int y, int m, int d) {
        m = (m + 9) % 12;
        return 365L * (long)(y -= m / 10) + (long)(y / 4) - (long)(y / 100) + (long)(y / 400) + (long)((m * 306 + 5) / 10) + (long)(d - 1);
    }

    public static SolarDate solarFromInt(long g) {
        long year = (10000L * g + 14780L) / 3652425L;
        long ddd = g - (365L * year + year / 4L - year / 100L + year / 400L);
        if (ddd < 0L) {
            ddd = g - (365L * --year + year / 4L - year / 100L + year / 400L);
        }
        long mi = (100L * ddd + 52L) / 3060L;
        long mm = (mi + 2L) % 12L + 1L;
        long dd = ddd - (mi * 306L + 5L) / 10L + 1L;
        return new SolarDate((int)(year += (mi + 2L) / 12L), (int)mm, (int)dd);
    }

    public static int getBitInt(int data, int length, int shift) {
        return (data & (1 << length) - 1 << shift) >> shift;
    }

    public static int getFirstTerm(int solarYear, int solarMonth) {
        long times = 31556925974L * (long)(solarYear - 1900) + CalendaristConstants.SOLAR_TERM_INFO[(solarMonth - 1) * 2] * 60000L + (long)((int)(0.7 * (double)(solarYear - 1900)));
        Date offDate = new Date(times - 2208549300000L);
        Calendar cal = Lunars.getCalendarInstance();
        cal.setTime(offDate);
        int zoneOffset = cal.get(15);
        int dstOffset = cal.get(16);
        cal.add(14, -(zoneOffset + dstOffset));
        return cal.get(5);
    }

    public static int daysOfYear(int lunarYear) {
        int sum = 348;
        for (int i = 32768; i > 8; i >>= 1) {
            if ((CalendaristConstants.LUNAR_CODE[lunarYear - 1900] & i) == 0) continue;
            ++sum;
        }
        return sum + Lunars.daysOfLeapMonth(lunarYear);
    }

    public static int daysOfMonth(int lunarYear, int lunarMonth) {
        if ((CalendaristConstants.LUNAR_CODE[lunarYear - 1900] & 65536 >> lunarMonth) == 0) {
            return 29;
        }
        return 30;
    }

    public static int daysOfLeapMonth(int lunarYear) {
        if (Lunars.leapMonth(lunarYear) != 0) {
            if ((CalendaristConstants.LUNAR_CODE[lunarYear - 1900] & 0x10000) != 0) {
                return 30;
            }
            return 29;
        }
        return 0;
    }

    public static int leapMonth(int lunarYear) {
        return CalendaristConstants.LUNAR_CODE[lunarYear - 1900] & 0xF;
    }
}

