/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.datetime.formatter;

import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.datetime.DateTimeFormatter;
import com.jn.langx.util.datetime.formatter.AbstractUtcTimestampFormatter;
import com.jn.langx.util.datetime.formatter.DateFormatter;
import java.util.Date;
import java.util.List;

public class LongTimestampFormatter
extends AbstractUtcTimestampFormatter<Long> {
    private long min13 = 1000000000000L;
    private long min10 = 1000000000L;
    private static final List<Class> SUPPORTED = Collects.immutableArrayList(Long.TYPE, Long.class);

    @Override
    public String format(Long d) {
        Preconditions.checkNotNull(d);
        Preconditions.checkTrue(d >= this.min10);
        if (d < this.min13) {
            d = d * 1000L;
        }
        Date date = new Date(d);
        DateFormatter dateFormatter = new DateFormatter(this.getPattern(), this.getTimeZone(), this.getLocale());
        return dateFormatter.format(date);
    }

    @Override
    public List<Class> supported() {
        return SUPPORTED;
    }

    @Override
    public DateTimeFormatter<Long> get() {
        return new LongTimestampFormatter();
    }
}

