/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.datetime.parser;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.util.collection.ArrayKey;
import com.jn.langx.util.datetime.DateTimeParsedResult;
import com.jn.langx.util.datetime.DateTimeParser;
import com.jn.langx.util.datetime.parser.CandidateDateTimeParseService;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractCandidateDateTimeParseService
implements CandidateDateTimeParseService {
    private ConcurrentHashMap<ArrayKey, DateTimeParser> cache = new ConcurrentHashMap();

    @Override
    public DateTimeParsedResult parse(String dt, List<String> candidatePatterns, List<TimeZone> candidateTimeZones, List<Locale> candidateLocales) {
        ArrayKey key = new ArrayKey(candidatePatterns, candidateTimeZones, candidateLocales);
        DateTimeParser parser = this.cache.get(key);
        if (parser == null && (parser = this.newParser(candidatePatterns, candidateTimeZones, candidateLocales)) != null) {
            this.cache.put(key, parser);
        }
        if (parser != null) {
            return (DateTimeParsedResult)parser.parse(dt);
        }
        return null;
    }

    @NonNull
    protected abstract DateTimeParser newParser(List<String> var1, List<TimeZone> var2, List<Locale> var3);
}

