/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.datetime.time;

import com.jn.langx.util.concurrent.threadlocal.GlobalThreadLocalMap;
import com.jn.langx.util.datetime.time.TimeParsedResult;
import com.jn.langx.util.datetime.time.TimeParser;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class SimpleTimeParser
implements TimeParser {
    private String pattern;
    private Locale locale;

    public SimpleTimeParser(String pattern) {
        this(pattern, Locale.getDefault());
    }

    public SimpleTimeParser(String pattern, Locale locale) {
        this.pattern = pattern;
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getPattern() {
        return this.pattern;
    }

    @Override
    public TimeParsedResult parse(String time) {
        SimpleDateFormat format = GlobalThreadLocalMap.getSimpleDateFormat(this.pattern, this.locale);
        try {
            Date date = format.parse(time);
            TimeParsedResult timeParsedResult = new TimeParsedResult();
            timeParsedResult.setHour(date.getHours());
            timeParsedResult.setMinute(date.getMinutes());
            timeParsedResult.setSecond(date.getSeconds());
            String longTime = "" + date.getTime();
            String mills = longTime.substring(longTime.length() - 3);
            timeParsedResult.setMills(Integer.parseInt(mills));
            return timeParsedResult;
        }
        catch (ParseException ex) {
            return null;
        }
    }
}

