/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.enums;

import com.jn.langx.Named;
import com.jn.langx.annotation.NonNull;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.Objs;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Maps;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.enums.EnumGetter;
import com.jn.langx.util.enums.JvmEnumGetter;
import com.jn.langx.util.enums.base.CommonEnum;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.function.Supplier0;
import com.jn.langx.util.reflect.Reflects;
import com.jn.langx.util.spi.CommonServiceProvider;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Enums {
    private static final Map<Class, EnumGetter> GETTER_REGISTRY;

    private Enums() {
    }

    private static EnumGetter selectGetter(final Class tClass) {
        EnumGetter getter = GETTER_REGISTRY.get(tClass);
        if (getter == null && Reflects.isSubClass(CommonEnum.class, tClass)) {
            getter = GETTER_REGISTRY.get(CommonEnum.class);
        }
        if (getter == null) {
            Pipeline.of(GETTER_REGISTRY.keySet()).findFirst(new Predicate<Class>(){

                @Override
                public boolean test(Class aClass) {
                    if (aClass == Enum.class) {
                        return false;
                    }
                    return Reflects.isSubClassOrEquals(aClass, tClass);
                }
            });
        }
        if (getter == null) {
            getter = GETTER_REGISTRY.get(Enum.class);
        }
        return getter;
    }

    public static <T extends Enum<T>> T ofValue(final int value, Class<T> targetClass) {
        Preconditions.checkTrue(targetClass.isEnum(), targetClass.getName() + " not an enum class");
        return (T)((Enum)Collects.findFirst(EnumSet.allOf(targetClass), new Predicate<T>(){

            @Override
            public boolean test(T e) {
                return ((Enum)e).ordinal() == value;
            }
        }));
    }

    public static <T extends Enum<T>> T ofCode(@NonNull Class<T> tClass, int code) {
        Preconditions.checkNotNull(tClass);
        EnumGetter getter = Enums.selectGetter(tClass);
        Enum t = getter.getByCode(tClass, code);
        if (t == null && !(getter instanceof JvmEnumGetter)) {
            getter = Enums.getJvmEnumGetter();
            t = getter.getByCode(tClass, code);
        }
        return (T)t;
    }

    public static <T extends Enum<T>> T ofName(@NonNull Class<T> tClass, String name) {
        Preconditions.checkNotNull(tClass);
        EnumGetter getter = Enums.selectGetter(tClass);
        Enum t = getter.getByName(tClass, name);
        if (t == null && !(getter instanceof JvmEnumGetter)) {
            getter = Enums.getJvmEnumGetter();
            t = getter.getByName(tClass, name);
        }
        return (T)t;
    }

    public static <T extends Enum<T>> T ofToString(@NonNull Class<T> tClass, String value) {
        Preconditions.checkNotNull(tClass);
        EnumGetter getter = Enums.selectGetter(tClass);
        Enum t = getter.getByToString(tClass, value);
        if (t == null && !(getter instanceof JvmEnumGetter)) {
            getter = Enums.getJvmEnumGetter();
            t = getter.getByToString(tClass, value);
        }
        return (T)t;
    }

    public static <T extends Enum<T>> T ofDisplayText(@NonNull Class<T> tClass, String displayText) {
        Preconditions.checkNotNull(tClass);
        EnumGetter getter = Enums.selectGetter(tClass);
        Enum t = getter.getByDisplayText(tClass, displayText);
        if (t == null && !(getter instanceof JvmEnumGetter)) {
            getter = Enums.getJvmEnumGetter();
            t = getter.getByDisplayText(tClass, displayText);
        }
        return (T)t;
    }

    private static EnumGetter getJvmEnumGetter() {
        return GETTER_REGISTRY.get(Enum.class);
    }

    public static <T extends Enum<T>> T inferEnum(Class<T> targetClass, String text) {
        T v;
        if (targetClass.isEnum() && Reflects.isSubClassOrEquals(Enum.class, targetClass) && (v = Enums.ofDisplayText(targetClass, text)) == null) {
            return Enums.ofName(targetClass, text);
        }
        return null;
    }

    public static <T extends Enum<T>> T ofField(Class<T> targetClass, String field, Object value) {
        return Enums.ofField(targetClass, field, value, null);
    }

    public static <T extends Enum<T>> T ofField(Class<T> targetClass, String field, Supplier0<Object> valueSupplier) {
        return Enums.ofField(targetClass, field, valueSupplier, null);
    }

    public static <T extends Enum<T>> T ofField(Class<T> targetClass, String field, final Object value, Predicate<T> predicate) {
        return Enums.ofField(targetClass, field, new Supplier0<Object>(){

            @Override
            public Object get() {
                return value;
            }
        }, predicate);
    }

    public static <T extends Enum<T>> T ofField(Class<T> targetClass, final String field, final Supplier0<Object> valueSupplier, Predicate<T> predicate) {
        Preconditions.checkNotNull(targetClass);
        Preconditions.checkNotNull(field);
        if (targetClass.isEnum() && Reflects.isSubClassOrEquals(Enum.class, targetClass)) {
            if (predicate == null) {
                return (T)((Enum)Collects.findFirst(EnumSet.allOf(targetClass), new Predicate<T>(){

                    @Override
                    public boolean test(T e) {
                        Object fieldValue = Reflects.getAnyFieldValue(e, field, true, false);
                        Object expectedValue = valueSupplier == null ? null : valueSupplier.get();
                        return Objs.deepEquals(fieldValue, expectedValue);
                    }
                }));
            }
            return (T)((Enum)Collects.findFirst(EnumSet.allOf(targetClass), predicate));
        }
        throw new IllegalArgumentException(StringTemplates.formatWithPlaceholder("{} not a enum class", Reflects.getFQNClassName(targetClass)));
    }

    public static <T extends Enum<T>> Set<T> getEnumSet(Class<T> enumClass) {
        return EnumSet.allOf(enumClass);
    }

    public static <T extends Enum<T>> List<T> getEnumList(Class<T> enumClass) {
        return Collects.asList(Enums.getEnumSet(enumClass));
    }

    public static int getIndex(Enum e) {
        return e.ordinal();
    }

    public static int getCode(Enum e) {
        EnumGetter getter = Enums.selectGetter(e.getClass());
        int code = getter.getCode(e);
        return code;
    }

    public static String getName(Enum e) {
        if (e instanceof Named) {
            return ((Named)((Object)e)).getName();
        }
        EnumGetter getter = Enums.selectGetter(e.getClass());
        String name = getter.getName(e);
        return name;
    }

    public static String getDisplayText(Enum e) {
        EnumGetter getter = Enums.selectGetter(e.getClass());
        String name = getter.getDisplayText(e);
        return name;
    }

    static {
        final LinkedHashMap<Class, EnumGetter> r = Maps.newLinkedHashMap();
        Pipeline.of(new CommonServiceProvider<EnumGetter>().get(EnumGetter.class)).forEach(new Consumer<EnumGetter>(){

            @Override
            public void accept(final EnumGetter selector) {
                List<Class> targetEnumClass = selector.applyTo();
                Pipeline.of(targetEnumClass).forEach(new Consumer<Class>(){

                    @Override
                    public void accept(Class aClass) {
                        r.put(aClass, selector);
                    }
                });
            }
        });
        GETTER_REGISTRY = r;
    }
}

