/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.function;

import com.jn.langx.Filter;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Maths;
import com.jn.langx.util.Objs;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.function.Consumer2;
import com.jn.langx.util.function.Function;
import com.jn.langx.util.function.Function2;
import com.jn.langx.util.function.Mapper;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.function.Predicate2;
import com.jn.langx.util.function.Supplier;
import com.jn.langx.util.function.Supplier0;
import com.jn.langx.util.function.predicate.EmptyPredicate;
import com.jn.langx.util.reflect.Reflects;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class Functions {
    private Functions() {
    }

    public static <E> Function<E, E> noopFunction() {
        return new Function<E, E>(){

            @Override
            public E apply(E input) {
                return input;
            }
        };
    }

    public static <E> Mapper<E, E> noopMapper() {
        return new Mapper<E, E>(){

            @Override
            public E apply(E input) {
                return input;
            }
        };
    }

    public static <E> Mapper<E, String> toStringFunction() {
        return new Mapper<E, String>(){

            @Override
            public String apply(E input) {
                Preconditions.checkNotNull(input);
                return input.toString();
            }
        };
    }

    public static Function2<Integer, Integer, Integer> maxIntegerFunction() {
        return new Function2<Integer, Integer, Integer>(){

            @Override
            public Integer apply(Integer a, Integer b) {
                return Maths.max(a, b);
            }
        };
    }

    public static Function2<Float, Float, Float> maxFloatFunction() {
        return new Function2<Float, Float, Float>(){

            @Override
            public Float apply(Float a, Float b) {
                return Float.valueOf(Maths.maxFloat(a.floatValue(), b.floatValue()));
            }
        };
    }

    public static Function2<Long, Long, Long> maxLongFunction() {
        return new Function2<Long, Long, Long>(){

            @Override
            public Long apply(Long a, Long b) {
                return Maths.maxLong(a, b);
            }
        };
    }

    public static Function2<Double, Double, Double> maxDoubleFunction() {
        return new Function2<Double, Double, Double>(){

            @Override
            public Double apply(Double a, Double b) {
                return Maths.maxDouble(a, b);
            }
        };
    }

    public static Function2<Integer, Integer, Integer> minIntegerFunction() {
        return new Function2<Integer, Integer, Integer>(){

            @Override
            public Integer apply(Integer a, Integer b) {
                return Maths.min(a, b);
            }
        };
    }

    public static Function2<Float, Float, Float> minFloatFunction() {
        return new Function2<Float, Float, Float>(){

            @Override
            public Float apply(Float a, Float b) {
                return Float.valueOf(Maths.minFloat(a.floatValue(), b.floatValue()));
            }
        };
    }

    public static Function2<Long, Long, Long> minLongFunction() {
        return new Function2<Long, Long, Long>(){

            @Override
            public Long apply(Long a, Long b) {
                return Maths.minLong(a, b);
            }
        };
    }

    public static Function2<Double, Double, Double> minDoubleFunction() {
        return new Function2<Double, Double, Double>(){

            @Override
            public Double apply(Double a, Double b) {
                return Maths.minDouble(a, b);
            }
        };
    }

    public static Function2<Integer, Integer, Integer> sumIntegerFunction() {
        return new Function2<Integer, Integer, Integer>(){

            @Override
            public Integer apply(Integer a, Integer b) {
                return Maths.sum(a, b);
            }
        };
    }

    public static Function2<Float, Float, Float> sumFloatFunction() {
        return new Function2<Float, Float, Float>(){

            @Override
            public Float apply(Float a, Float b) {
                return Float.valueOf(Maths.sumFloat(a.floatValue(), b.floatValue()));
            }
        };
    }

    public static Function2<Long, Long, Long> sumLongFunction() {
        return new Function2<Long, Long, Long>(){

            @Override
            public Long apply(Long a, Long b) {
                return Maths.sumLong(a, b);
            }
        };
    }

    public static Function2<Double, Double, Double> sumDoubleFunction() {
        return new Function2<Double, Double, Double>(){

            @Override
            public Double apply(Double a, Double b) {
                return Maths.sumDouble(a, b);
            }
        };
    }

    public static Function<String, String> toLowerCase() {
        return new Function<String, String>(){

            @Override
            public String apply(String input) {
                return input.toLowerCase();
            }
        };
    }

    public static Function<String, String> toUpperCase() {
        return new Function<String, String>(){

            @Override
            public String apply(String input) {
                return input.toUpperCase();
            }
        };
    }

    public static <E> Predicate<E> nonNullPredicate() {
        return new Predicate<E>(){

            @Override
            public boolean test(E value) {
                return value != null;
            }
        };
    }

    public static <E> Predicate<E> nullPredicate() {
        return new Predicate<E>(){

            @Override
            public boolean test(E value) {
                return value == null;
            }
        };
    }

    public static <E1, E2> Predicate2<E1, E2> nonNullPredicate2() {
        return new Predicate2<E1, E2>(){

            @Override
            public boolean test(E1 e1, E2 value) {
                return value != null;
            }
        };
    }

    public static <E1, E2> Predicate2<E1, E2> nullPredicate2() {
        return new Predicate2<E1, E2>(){

            @Override
            public boolean test(E1 e1, E2 value) {
                return value == null;
            }
        };
    }

    public static <E> Predicate<E> emptyPredicate() {
        return EmptyPredicate.IS_EMPTY_PREDICATE;
    }

    public static <E> Predicate<E> isInstancePredicate(final Class<E> itfc) {
        return new Predicate<E>(){

            @Override
            public boolean test(E obj) {
                return Reflects.isInstance(obj, itfc);
            }
        };
    }

    public static <E> Predicate<E> notEmptyPredicate() {
        return EmptyPredicate.IS_NOT_EMPTY_PREDICATE;
    }

    public static <E> Filter<E> trueFilter() {
        return new Filter<E>(){

            @Override
            public boolean accept(E e) {
                return true;
            }
        };
    }

    public static <E> Filter<E> falseFilter() {
        return new Filter<E>(){

            @Override
            public boolean accept(E e) {
                return false;
            }
        };
    }

    public static <E> Predicate<E> truePredicate() {
        return Functions.booleanPredicate(true);
    }

    public static <E> Predicate<E> falsePredicate() {
        return Functions.booleanPredicate(false);
    }

    public static <E> Predicate<E> booleanPredicate(final boolean value) {
        return new Predicate<E>(){

            @Override
            public boolean test(E element) {
                return value;
            }
        };
    }

    public static <E1, E2> Predicate2<E1, E2> truePredicate2() {
        return Functions.booleanPredicate2(true);
    }

    public static <E> Predicate<E> reversePredicate(final Predicate<E> predicate) {
        return new Predicate<E>(){

            @Override
            public boolean test(E e) {
                return !predicate.test(e);
            }
        };
    }

    public static <E1, E2> Predicate2<E1, E2> reversePredicate(final Predicate2<E1, E2> predicate) {
        return new Predicate2<E1, E2>(){

            @Override
            public boolean test(E1 key, E2 value) {
                return !predicate.test(key, value);
            }
        };
    }

    public static <E1, E2> Predicate2<E1, E2> falsePredicate2() {
        return Functions.booleanPredicate2(false);
    }

    public static <E1, E2> Predicate2<E1, E2> booleanPredicate2(final boolean value) {
        return new Predicate2<E1, E2>(){

            @Override
            public boolean test(E1 e1, E2 e2) {
                return value;
            }
        };
    }

    public static <E> Predicate<E> allPredicate(List<Predicate<E>> predicates) {
        final Pipeline<Predicate<E>> pipeline = Pipeline.of(predicates);
        return new Predicate<E>(){

            @Override
            public boolean test(final E value) {
                return pipeline.allMatch(new Predicate<Predicate<E>>(){

                    @Override
                    public boolean test(Predicate<E> predicate) {
                        return predicate.test(value);
                    }
                });
            }
        };
    }

    public static <E> Predicate<E> allPredicate(Predicate<E> ... predicates) {
        Preconditions.checkTrue(Emptys.isNotEmpty(predicates));
        Preconditions.checkTrue(predicates.length >= 1);
        return Functions.allPredicate(Collects.asList(predicates));
    }

    public static <E> Predicate<E> anyPredicate(List<Predicate<E>> predicates) {
        final Pipeline<Predicate<E>> pipeline = Pipeline.of(predicates);
        return new Predicate<E>(){

            @Override
            public boolean test(final E value) {
                return pipeline.anyMatch(new Predicate<Predicate<E>>(){

                    @Override
                    public boolean test(Predicate<E> filter) {
                        return filter.test(value);
                    }
                });
            }
        };
    }

    public static <E> Predicate<E> anyPredicate(Predicate<E> ... predicates) {
        Preconditions.checkTrue(Emptys.isNotEmpty(predicates));
        Preconditions.checkTrue(predicates.length >= 1);
        return Functions.anyPredicate(Collects.asList(predicates));
    }

    public static <E> Predicate<E> nonePredicate(List<Predicate<E>> predicates) {
        final Pipeline<Predicate<E>> pipeline = Pipeline.of(predicates);
        return new Predicate<E>(){

            @Override
            public boolean test(final E value) {
                return pipeline.noneMatch(new Predicate<Predicate<E>>(){

                    @Override
                    public boolean test(Predicate<E> filter) {
                        return filter.test(value);
                    }
                });
            }
        };
    }

    public static <E> Predicate<E> nonePredicate(Predicate<E> ... predicates) {
        Preconditions.checkTrue(Emptys.isNotEmpty(predicates));
        Preconditions.checkTrue(predicates.length >= 1);
        return Functions.nonePredicate(Collects.asList(predicates));
    }

    public static <E> Predicate<E> andPredicate(Predicate<E> ... predicates) {
        return Functions.allPredicate(predicates);
    }

    public static <E> Predicate<E> orPredicate(Predicate<E> ... predicates) {
        return Functions.anyPredicate(predicates);
    }

    public static <E1, E2> Predicate2<E1, E2> deepEqualsPredicate() {
        return new Predicate2<E1, E2>(){

            @Override
            public boolean test(E1 v1, E2 v2) {
                return Objs.deepEquals(v1, v2);
            }
        };
    }

    public static <E> Predicate<E> equalsPredicate(final E obj) {
        return new Predicate<E>(){

            @Override
            public boolean test(E value) {
                return Objs.equals(obj, value);
            }
        };
    }

    public static <E> Predicate<E> notEqualsPredicate(final E obj) {
        return new Predicate<E>(){

            @Override
            public boolean test(E value) {
                return !Objs.equals(obj, value);
            }
        };
    }

    public static <E1, E2> Predicate2<E1, E2> equalsPredicate() {
        return new Predicate2<E1, E2>(){

            @Override
            public boolean test(E1 v1, E2 v2) {
                return Objs.equals(v1, v2);
            }
        };
    }

    public static Predicate<String> stringContainsPredicate(String cantained) {
        return Functions.stringContainsPredicate(cantained, false);
    }

    public static Predicate<String> stringContainsPredicate(final String cantained, final boolean ignoreCase) {
        Preconditions.checkTrue(Emptys.isNotEmpty(cantained));
        return new Predicate<String>(){

            @Override
            public boolean test(String value) {
                return Strings.contains(value, cantained, ignoreCase);
            }
        };
    }

    public static <K, V> Supplier<K, List<V>> emptyArrayListSupplier() {
        return new Supplier<K, List<V>>(){

            @Override
            public List<V> get(K input) {
                return Collects.emptyArrayList();
            }
        };
    }

    public static <K, V> Supplier<K, List<V>> emptyLinkedListSupplier() {
        return new Supplier<K, List<V>>(){

            @Override
            public List<V> get(K input) {
                return Collects.emptyLinkedList();
            }
        };
    }

    public static <E> Supplier0<HashSet<E>> emptyHashSetSupplier0() {
        return new Supplier0<HashSet<E>>(){

            @Override
            public HashSet<E> get() {
                return Collects.emptyHashSet();
            }
        };
    }

    public static <I, E> Supplier<I, HashSet<E>> emptyHashSetSupplier() {
        return new Supplier<I, HashSet<E>>(){

            @Override
            public HashSet<E> get(I input) {
                return Collects.emptyHashSet();
            }
        };
    }

    public static <I, E> Supplier<I, LinkedHashSet<E>> emptyLinkedHashSetSupplier() {
        return new Supplier<I, LinkedHashSet<E>>(){

            @Override
            public LinkedHashSet<E> get(I input) {
                return (LinkedHashSet)Collects.emptyHashSet(true);
            }
        };
    }

    public static <E> Supplier0<TreeSet<E>> emptyTreeSetSupplier0(final Comparator<E> comparator) {
        return new Supplier0<TreeSet<E>>(){

            @Override
            public TreeSet<E> get() {
                return Collects.emptyTreeSet(comparator);
            }
        };
    }

    public static <I, V> Supplier<I, Set<V>> emptyTreeSetSupplier(final Comparator<V> comparator) {
        return new Supplier<I, Set<V>>(){

            @Override
            public Set<V> get(Object input) {
                return Collects.emptyTreeSet(comparator);
            }
        };
    }

    public static <T> Supplier<T, T> noopSupplier() {
        return new Supplier<T, T>(){

            @Override
            public T get(T input) {
                return input;
            }
        };
    }

    public static <T> Consumer<T> noopConsumer() {
        return new Consumer<T>(){

            @Override
            public void accept(T t) {
            }
        };
    }

    public static <T1, T2> Consumer2<T1, T2> noopConsumer2() {
        return new Consumer2<T1, T2>(){

            @Override
            public void accept(T1 t1, T2 t2) {
            }
        };
    }
}

