/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.hash;

import com.jn.langx.io.stream.IOStreamPipeline;
import com.jn.langx.io.stream.OutputStreamInterceptor;
import com.jn.langx.io.stream.WrappedOutputStream;
import com.jn.langx.util.hash.StreamingHasher;
import java.io.OutputStream;

public final class HashingOutputStream
extends WrappedOutputStream {
    public HashingOutputStream(final StreamingHasher hasher, OutputStream out) {
        super(out, IOStreamPipeline.of(new OutputStreamInterceptor(){

            @Override
            public boolean beforeWrite(OutputStream outputStream, byte[] b, int off, int len) {
                return true;
            }

            @Override
            public boolean afterWrite(OutputStream outputStream, byte[] b, int off, int len) {
                hasher.update(b, 0, len);
                return true;
            }
        }));
    }
}

