/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.hash.streaming;

import com.jn.langx.util.Preconditions;
import com.jn.langx.util.hash.streaming.AbstractStreamingHasher;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public abstract class AdvancedStreamingHasher
extends AbstractStreamingHasher {
    private final ByteBuffer buffer;
    private final int bufferSize;
    private final int chunkSize;

    protected AdvancedStreamingHasher(int chunkSize) {
        this(chunkSize, chunkSize);
    }

    protected AdvancedStreamingHasher(int chunkSize, int bufferSize) {
        Preconditions.checkArgument(bufferSize % chunkSize == 0);
        this.buffer = ByteBuffer.allocate(bufferSize + 7).order(ByteOrder.LITTLE_ENDIAN);
        this.bufferSize = bufferSize;
        this.chunkSize = chunkSize;
    }

    protected abstract void process(ByteBuffer var1);

    protected void processRemaining(ByteBuffer bb) {
        bb.position(bb.limit());
        bb.limit(this.chunkSize + 7);
        while (bb.position() < this.chunkSize) {
            bb.putLong(0L);
        }
        bb.limit(this.chunkSize);
        bb.flip();
        this.process(bb);
    }

    @Override
    public void update(byte[] bytes, int off, int len) {
        this.putBytes(bytes, off, len);
    }

    @Override
    public long getHash() {
        long h = this.doFinal();
        this.reset();
        return h;
    }

    protected final AdvancedStreamingHasher putBytes(byte[] bytes, int off, int len) {
        return this.putBytesInternal(ByteBuffer.wrap(bytes, off, len).order(ByteOrder.LITTLE_ENDIAN));
    }

    private AdvancedStreamingHasher putBytesInternal(ByteBuffer readBuffer) {
        if (readBuffer.remaining() <= this.buffer.remaining()) {
            this.buffer.put(readBuffer);
            this.munchIfFull();
            return this;
        }
        int bytesToCopy = this.bufferSize - this.buffer.position();
        for (int i = 0; i < bytesToCopy; ++i) {
            this.buffer.put(readBuffer.get());
        }
        this.munch();
        while (readBuffer.remaining() >= this.chunkSize) {
            this.process(readBuffer);
        }
        this.buffer.put(readBuffer);
        return this;
    }

    protected final long doFinal() {
        this.munch();
        this.buffer.flip();
        if (this.buffer.remaining() > 0) {
            this.processRemaining(this.buffer);
            this.buffer.position(this.buffer.limit());
        }
        return this.makeHash();
    }

    protected abstract long makeHash();

    private void munchIfFull() {
        if (this.buffer.remaining() < 8) {
            this.munch();
        }
    }

    private void munch() {
        this.buffer.flip();
        while (this.buffer.remaining() >= this.chunkSize) {
            this.process(this.buffer);
        }
        this.buffer.compact();
    }
}

