/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.hash.streaming.crc;

import com.jn.langx.registry.GenericRegistry;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.hash.streaming.crc.CrcAlgoMetadata;
import java.util.List;

public class CRCs {
    private static final GenericRegistry<CrcAlgoMetadata> ALGO_METADATA_REGISTRY = new GenericRegistry();

    private CRCs() {
    }

    public static CrcAlgoMetadata getCrcAlgoMetadata(String name) {
        return (CrcAlgoMetadata)ALGO_METADATA_REGISTRY.get(name);
    }

    public static List<String> getCrcNames() {
        return ALGO_METADATA_REGISTRY.names();
    }

    static {
        ALGO_METADATA_REGISTRY.init();
        List<CrcAlgoMetadata> metadatas = Collects.asList(new CrcAlgoMetadata("CRC-8", 8, 7L, 0L, false, false, 0L, 244L), new CrcAlgoMetadata("CRC-8/CDMA2000", 8, 155L, 255L, false, false, 0L, 218L), new CrcAlgoMetadata("CRC-8/DARC", 8, 57L, 0L, true, true, 0L, 21L), new CrcAlgoMetadata("CRC-8/DVB-S2", 8, 213L, 0L, false, false, 0L, 188L), new CrcAlgoMetadata("CRC-8/EBU", 8, 29L, 255L, true, true, 0L, 151L), new CrcAlgoMetadata("CRC-8/I-CODE", 8, 29L, 253L, false, false, 0L, 126L), new CrcAlgoMetadata("CRC-8/ITU", 8, 7L, 0L, false, false, 85L, 161L), new CrcAlgoMetadata("CRC-8/MAXIM", 8, 49L, 0L, true, true, 0L, 161L), new CrcAlgoMetadata("CRC-8/ROHC", 8, 7L, 255L, true, true, 0L, 208L), new CrcAlgoMetadata("CRC-8/WCDMA", 8, 155L, 0L, true, true, 0L, 37L), new CrcAlgoMetadata("CRC-16/CCITT-FALSE", 16, 4129L, 65535L, false, false, 0L, 10673L), new CrcAlgoMetadata("CRC-16/ARC", 16, 32773L, 0L, true, true, 0L, 47933L), new CrcAlgoMetadata("CRC-16/AUG-CCITT", 16, 4129L, 7439L, false, false, 0L, 58828L), new CrcAlgoMetadata("CRC-16/BUYPASS", 16, 32773L, 0L, false, false, 0L, 65256L), new CrcAlgoMetadata("CRC-16/CDMA2000", 16, 51303L, 65535L, false, false, 0L, 19462L), new CrcAlgoMetadata("CRC-16/DDS-110", 16, 32773L, 32781L, false, false, 0L, 40655L), new CrcAlgoMetadata("CRC-16/DECT-R", 16, 1417L, 0L, false, false, 1L, 126L), new CrcAlgoMetadata("CRC-16/DECT-X", 16, 1417L, 0L, false, false, 0L, 127L), new CrcAlgoMetadata("CRC-16/DNP", 16, 15717L, 0L, true, true, 65535L, 60034L), new CrcAlgoMetadata("CRC-16/EN-13757", 16, 15717L, 0L, false, false, 65535L, 49847L), new CrcAlgoMetadata("CRC-16/GENIBUS", 16, 4129L, 65535L, false, false, 65535L, 54862L), new CrcAlgoMetadata("CRC-16/MAXIM", 16, 32773L, 0L, true, true, 65535L, 17602L), new CrcAlgoMetadata("CRC-16/MCRF4XX", 16, 4129L, 65535L, true, true, 0L, 28561L), new CrcAlgoMetadata("CRC-16/RIELLO", 16, 4129L, 45738L, true, true, 0L, 25552L), new CrcAlgoMetadata("CRC-16/T10-DIF", 16, 35767L, 0L, false, false, 0L, 53467L), new CrcAlgoMetadata("CRC-16/TELEDISK", 16, 41111L, 0L, false, false, 0L, 4019L), new CrcAlgoMetadata("CRC-16/TMS37157", 16, 4129L, 35308L, true, true, 0L, 9905L), new CrcAlgoMetadata("CRC-16/USB", 16, 32773L, 65535L, true, true, 65535L, 46280L), new CrcAlgoMetadata("CRC-A", 16, 4129L, 50886L, true, true, 0L, 48901L), new CrcAlgoMetadata("CRC-16/KERMIT", 16, 4129L, 0L, true, true, 0L, 8585L), new CrcAlgoMetadata("CRC-16/MODBUS", 16, 32773L, 65535L, true, true, 0L, 19255L), new CrcAlgoMetadata("CRC-16/X-25", 16, 4129L, 65535L, true, true, 65535L, 36974L), new CrcAlgoMetadata("CRC-16/XMODEM", 16, 4129L, 0L, false, false, 0L, 12739L), new CrcAlgoMetadata("CRC-32", 32, 79764919L, 0xFFFFFFFFL, true, true, 0xFFFFFFFFL, 3421780262L), new CrcAlgoMetadata("CRC-32/BZIP2", 32, 79764919L, 0xFFFFFFFFL, false, false, 0xFFFFFFFFL, 4236843288L), new CrcAlgoMetadata("CRC-32C", 32, 517762881L, 0xFFFFFFFFL, true, true, 0xFFFFFFFFL, 3808858755L), new CrcAlgoMetadata("CRC-32D", 32, 2821953579L, 0xFFFFFFFFL, true, true, 0xFFFFFFFFL, 2268157302L), new CrcAlgoMetadata("CRC-32/JAMCRC", 32, 79764919L, 0xFFFFFFFFL, true, true, 0L, 873187033L), new CrcAlgoMetadata("CRC-32/MPEG-2", 32, 79764919L, 0xFFFFFFFFL, false, false, 0L, 58124007L), new CrcAlgoMetadata("CRC-32/POSIX", 32, 79764919L, 0L, false, false, 0xFFFFFFFFL, 1985902208L), new CrcAlgoMetadata("CRC-32Q", 32, 2168537515L, 0L, false, false, 0L, 806403967L), new CrcAlgoMetadata("CRC-32/XFER", 32, 175L, 0L, false, false, 0L, 3171672888L), new CrcAlgoMetadata("CRC-64", 64, 4823603603198064275L, 0L, false, false, 0L, 7800480153909949255L), new CrcAlgoMetadata("CRC-64/WE", 64, 4823603603198064275L, -1L, false, false, -1L, 7128171145767219210L), new CrcAlgoMetadata("CRC-64/XZ", 64, 4823603603198064275L, -1L, true, true, -1L, -7395533204333446662L));
        Collects.forEach(metadatas, new Consumer<CrcAlgoMetadata>(){

            @Override
            public void accept(CrcAlgoMetadata crcAlgoMetadata) {
                ALGO_METADATA_REGISTRY.register(crcAlgoMetadata);
            }
        });
    }
}

