/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.hash.streaming.crc;

import com.jn.langx.util.hash.AbstractHasher;
import com.jn.langx.util.hash.UnsupportedHashAlgorithmException;
import com.jn.langx.util.hash.streaming.AbstractStreamingHasher;
import com.jn.langx.util.hash.streaming.crc.CRCs;
import com.jn.langx.util.hash.streaming.crc.CrcAlgoMetadata;
import com.jn.langx.util.hash.streaming.crc.CrcCalculator;

public class CrcHasher
extends AbstractStreamingHasher {
    private CrcCalculator calculator;
    private long h;

    public CrcHasher(String name) {
        CrcAlgoMetadata metadata = CRCs.getCrcAlgoMetadata(name);
        if (metadata == null) {
            throw new UnsupportedHashAlgorithmException(name);
        }
        this.calculator = new CrcCalculator(metadata);
        this.reset();
    }

    @Override
    public void setSeed(long seed) {
        this.h = this.seed = this.calculator.getInit();
    }

    @Override
    public void update(byte[] bytes, int off, int len) {
        this.h = this.calculator.update(this.h, bytes, off, len);
    }

    @Override
    public long getHash() {
        long r = this.calculator.getHashResult(this.h);
        this.reset();
        return r;
    }

    @Override
    protected AbstractHasher createInstance(Object initParams) {
        return new CrcHasher(this.calculator.getMetadata().getName());
    }

    @Override
    public String getName() {
        return this.calculator.getMetadata().getName();
    }
}

